/*
 * Decompiled with CFR 0.152.
 */
package org.mcavallo.opencloud;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Date;
import org.mcavallo.opencloud.Cloud;

public class Tag
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name = null;
    private String link = null;
    private double score = 1.0;
    private transient double normScore = 0.0;
    private transient double weight = 0.0;
    private Date date = new Date();

    public Tag() {
    }

    public Tag(String string) {
        this.setName(string);
    }

    public Tag(String string, String string2) {
        this.setName(string);
        this.setLink(string2);
    }

    public Tag(String string, double d) {
        this.setName(string);
        this.setScore(d);
    }

    public Tag(String string, String string2, double d) {
        this.setName(string);
        this.setLink(string2);
        this.setScore(d);
    }

    public Tag(String string, String string2, Date date) {
        this.setName(string);
        this.setLink(string2);
        this.setDate(date);
    }

    public Tag(String string, String string2, double d, Date date) {
        this.setName(string);
        this.setLink(string2);
        this.setScore(d);
        this.setDate(date);
    }

    public Tag(Tag tag) {
        this.setName(tag.getName());
        this.setLink(tag.getLink());
        this.setScore(tag.getScore());
        this.setNormScore(tag.getNormScore());
        this.setWeight(tag.getWeight());
        this.setDate(tag.getDate());
    }

    public double getWeight() {
        return this.weight;
    }

    public int getWeightInt() {
        return (int)Math.ceil(this.weight);
    }

    public int getWeightInt(Cloud.Rounding rounding) {
        if (rounding == Cloud.Rounding.FLOOR) {
            return (int)Math.floor(this.weight);
        }
        if (rounding == Cloud.Rounding.ROUND) {
            return (int)Math.round(this.weight);
        }
        return (int)Math.ceil(this.weight);
    }

    public void setWeight(double d) {
        this.weight = d;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String string) {
        this.link = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void add(double d) {
        this.score += d;
    }

    public void multiply(double d) {
        this.score *= d;
    }

    public void divide(double d) {
        this.score /= d;
    }

    public void normalize(double d) {
        this.normScore = this.score / d;
    }

    public double getScore() {
        return this.score;
    }

    public void setScore(double d) {
        this.score = d;
    }

    public int getScoreInt() {
        return (int)Math.ceil(this.score);
    }

    public int getScoreInt(Cloud.Rounding rounding) {
        if (rounding == Cloud.Rounding.FLOOR) {
            return (int)Math.floor(this.score);
        }
        if (rounding == Cloud.Rounding.ROUND) {
            return (int)Math.round(this.score);
        }
        return (int)Math.ceil(this.score);
    }

    public double getNormScore() {
        return this.normScore;
    }

    public void setNormScore(double d) {
        this.normScore = d;
    }

    public int getNormScoreInt() {
        return (int)Math.ceil(this.normScore);
    }

    public int getNormScoreInt(Cloud.Rounding rounding) {
        if (rounding == Cloud.Rounding.FLOOR) {
            return (int)Math.floor(this.normScore);
        }
        if (rounding == Cloud.Rounding.ROUND) {
            return (int)Math.round(this.normScore);
        }
        return (int)Math.ceil(this.normScore);
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Tag tag = (Tag)object;
        return !(this.name == null ? tag.name != null : !this.name.equals(tag.name));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ScoreComparatorDesc
    implements Comparator<Tag> {
        @Override
        public int compare(Tag tag, Tag tag2) {
            int n = Double.compare(tag2.getScore(), tag.getScore());
            if (n == 0) {
                return new NameComparatorAsc().compare(tag, tag2);
            }
            return n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ScoreComparatorAsc
    implements Comparator<Tag> {
        @Override
        public int compare(Tag tag, Tag tag2) {
            int n = Double.compare(tag.getScore(), tag2.getScore());
            if (n == 0) {
                return new NameComparatorAsc().compare(tag, tag2);
            }
            return n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NameComparatorDesc
    implements Comparator<Tag> {
        @Override
        public int compare(Tag tag, Tag tag2) {
            return tag2.getName().compareToIgnoreCase(tag.getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NameComparatorAsc
    implements Comparator<Tag> {
        @Override
        public int compare(Tag tag, Tag tag2) {
            return tag.getName().compareToIgnoreCase(tag2.getName());
        }
    }
}

