/*
 * Decompiled with CFR 0.152.
 */
package org.mcavallo.opencloud.filters;

import java.io.InputStream;
import java.io.Reader;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Scanner;
import java.util.Set;
import org.mcavallo.opencloud.Tag;
import org.mcavallo.opencloud.filters.TagFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DictionaryFilter
extends TagFilter {
    private static final long serialVersionUID = 1L;
    private Set<String> blackList = new HashSet<String>();
    public static final String defaultPropertyFile = "dictionary_blacklist";
    private boolean ignoreCase = true;

    public DictionaryFilter() {
        this.update();
    }

    public DictionaryFilter(Locale locale) {
        this.update(locale);
    }

    public DictionaryFilter(ResourceBundle resourceBundle) {
        this.update(resourceBundle);
    }

    public DictionaryFilter(Collection<? extends String> collection) {
        this.blackList.addAll(collection);
    }

    public DictionaryFilter(String[] stringArray) {
        this.update(stringArray);
    }

    public DictionaryFilter(InputStream inputStream) {
        Scanner scanner = new Scanner(inputStream);
        this.update(scanner);
    }

    public DictionaryFilter(Reader reader) {
        Scanner scanner = new Scanner(reader);
        this.update(scanner);
    }

    public DictionaryFilter(Scanner scanner) {
        this.update(scanner);
    }

    public void setIgnoreCase(boolean bl) {
        this.ignoreCase = bl;
    }

    public boolean getIgnoreCase() {
        return this.ignoreCase;
    }

    public void update() {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(defaultPropertyFile);
        this.update(resourceBundle);
    }

    public void update(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(defaultPropertyFile, locale);
        this.update(resourceBundle);
    }

    public void update(InputStream inputStream) {
        Scanner scanner = new Scanner(inputStream);
        this.update(scanner);
    }

    public void update(Reader reader) {
        Scanner scanner = new Scanner(reader);
        this.update(scanner);
    }

    public void update(Scanner scanner) {
        this.blackList.clear();
        while (scanner.hasNextLine()) {
            String string = scanner.nextLine();
            if (string.length() == 0) continue;
            this.blackList.add(string);
        }
    }

    public void update(ResourceBundle resourceBundle) {
        Enumeration<String> enumeration = resourceBundle.getKeys();
        this.blackList.clear();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (string.length() == 0) continue;
            if (this.ignoreCase) {
                this.blackList.add(string.toLowerCase());
                continue;
            }
            this.blackList.add(string);
        }
    }

    public void update(String[] stringArray) {
        this.blackList.clear();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string == null || string.length() == 0) continue;
            this.blackList.add(string);
        }
    }

    @Override
    public boolean accept(Tag tag) {
        if (tag == null) {
            return true;
        }
        String string = tag.getName();
        if (this.ignoreCase) {
            string = string.toLowerCase();
        }
        return !this.blackList.contains(string);
    }

    public Set<String> getDictionary() {
        return this.blackList;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.blackList == null ? 0 : ((Object)this.blackList).hashCode());
        n = 31 * n + (this.ignoreCase ? 1231 : 1237);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DictionaryFilter dictionaryFilter = (DictionaryFilter)object;
        if (this.blackList == null ? dictionaryFilter.blackList != null : !((Object)this.blackList).equals(dictionaryFilter.blackList)) {
            return false;
        }
        return this.ignoreCase == dictionaryFilter.ignoreCase;
    }
}

