/*
 * Decompiled with CFR 0.152.
 */
package org.mcavallo.opencloud.filters;

import org.mcavallo.opencloud.Tag;
import org.mcavallo.opencloud.filters.TagFilter;

public class LengthFilter
extends TagFilter {
    private static final long serialVersionUID = 1L;
    private int minLength = 0;
    private int maxLength = Integer.MAX_VALUE;

    public LengthFilter(int n, int n2) {
        this.setMinLength(n);
        this.setMaxLength(n2);
    }

    public boolean accept(Tag tag) {
        if (tag == null || tag.getName() == null) {
            return false;
        }
        return tag.getName().length() >= this.getMinLength() && tag.getName().length() <= this.getMaxLength();
    }

    public int getMinLength() {
        return this.minLength;
    }

    public void setMinLength(int n) {
        this.minLength = n;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int n) {
        this.maxLength = n;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.maxLength;
        n = 31 * n + this.minLength;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        LengthFilter lengthFilter = (LengthFilter)object;
        if (this.maxLength != lengthFilter.maxLength) {
            return false;
        }
        return this.minLength == lengthFilter.minLength;
    }
}

