/*
 * Decompiled with CFR 0.152.
 */
package org.mcavallo.opencloud.filters;

import org.mcavallo.opencloud.Tag;
import org.mcavallo.opencloud.filters.TagFilter;

public class MaxLengthFilter
extends TagFilter {
    private static final long serialVersionUID = 1L;
    private int maxLength = Integer.MAX_VALUE;

    public MaxLengthFilter() {
    }

    public MaxLengthFilter(int n) {
        this.setMaxLength(n);
    }

    public boolean accept(Tag tag) {
        if (tag == null || tag.getName() == null) {
            return false;
        }
        return tag.getName().length() <= this.getMaxLength();
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int n) {
        this.maxLength = n;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.maxLength;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MaxLengthFilter maxLengthFilter = (MaxLengthFilter)object;
        return this.maxLength == maxLengthFilter.maxLength;
    }
}

