/*
 * Decompiled with CFR 0.152.
 */
package org.mcavallo.opencloud.filters;

import org.mcavallo.opencloud.Tag;
import org.mcavallo.opencloud.filters.TagFilter;

public class MinLengthFilter
extends TagFilter {
    private static final long serialVersionUID = 1L;
    private int minLength = 0;

    public MinLengthFilter() {
    }

    public MinLengthFilter(int n) {
        this.setMinLength(n);
    }

    public boolean accept(Tag tag) {
        if (tag == null || tag.getName() == null) {
            return false;
        }
        return tag.getName().length() >= this.getMinLength();
    }

    public int getMinLength() {
        return this.minLength;
    }

    public void setMinLength(int n) {
        this.minLength = n;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.minLength;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MinLengthFilter minLengthFilter = (MinLengthFilter)object;
        return this.minLength == minLengthFilter.minLength;
    }
}

