/*
 * Decompiled with CFR 0.152.
 */
package org.mcavallo.opencloud.formatters;

import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.mcavallo.opencloud.Cloud;
import org.mcavallo.opencloud.Tag;
import org.mcavallo.opencloud.formatters.CssStatement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLFormatter {
    private Map<String, List<CssStatement>> cssFragments = new TreeMap<String, List<CssStatement>>();
    private String htmlTemplateTop = "<div>\n";
    private String htmlTemplateTag = "<a href=\"%tag-link%\" style=\"font-size: %tag-weight%px\">%tag-name%</a>\n";
    private String htmlTemplateBottom = "</div>\n";
    private static final String templateVarTagName = "%tag-name%";
    private static final String templateVarTagLink = "%tag-link%";
    private static final String templateVarTagWeight = "%tag-weight%";
    private static final String templateVarTagWeightInt = "%tag-weight-int%";
    private static final String templateVarTagScore = "%tag-score%";
    private static final String templateVarTagNormScore = "%tag-norm-score%";
    private static final String templateVarTagScoreInt = "%tag-score-int%";
    private static final String templateVarTagNormScoreInt = "%tag-norm-score-int%";

    public HTMLFormatter() {
    }

    public HTMLFormatter(HTMLFormatter hTMLFormatter) {
        this.setCssFragments(new TreeMap<String, List<CssStatement>>(hTMLFormatter.getCssFragments()));
        this.setHtmlTemplateTop(hTMLFormatter.getHtmlTemplateTop());
        this.setHtmlTemplateTag(hTMLFormatter.getHtmlTemplateTag());
        this.setHtmlTemplateBottom(hTMLFormatter.getHtmlTemplateBottom());
    }

    public void addCss(String string) {
        this.addCss("", string);
    }

    public void addCss(String string, String string2) {
        this.addCss(string, new CssStatement(string2));
    }

    public void addCss(String string, String string2, String string3) {
        if (string == null || string.length() == 0 || string2 == null || string3 == null) {
            return;
        }
        this.addCss(string, string2 + ": " + string3 + ";");
    }

    protected void addCss(String string, CssStatement cssStatement) {
        if (string == null || !this.isValid(cssStatement)) {
            return;
        }
        List<CssStatement> list = this.getCssFragments().get(string);
        if (list == null) {
            list = new LinkedList<CssStatement>();
            list.add(cssStatement);
            this.getCssFragments().put(string, list);
        } else {
            list.add(cssStatement);
        }
    }

    public void addCss(String string, String string2, String string3, String string4) {
        if (string == null || string2 == null || string3 == null || string4 == null) {
            return;
        }
        this.addCss(string, new CssStatement(string2, string3, string4));
    }

    public void addCss(String string, String string2, String[] stringArray) {
        if (string == null || string2 == null || stringArray == null) {
            return;
        }
        this.addCss(string, new CssStatement(string2, stringArray));
    }

    protected boolean isValid(CssStatement cssStatement) {
        return cssStatement != null && cssStatement.getProperty() != null;
    }

    public String html(Cloud cloud, Comparator<? super Tag> comparator) {
        String string = "";
        List<Tag> list = comparator == null ? cloud.tags() : cloud.tags(comparator);
        String string2 = this.css(cloud);
        if (string2 != null && string2.length() == 0) {
            string = string + "<style>\n" + string2 + "</style>\n";
        }
        string = string + this.getHtmlTemplateTop();
        for (Tag tag : list) {
            String string3;
            String string4 = tag.getName();
            if (string4 == null) {
                string4 = "";
            }
            if ((string3 = tag.getLink()) == null) {
                string3 = "";
            }
            String string5 = this.getHtmlTemplateTag();
            string5 = string5.replaceAll(templateVarTagName, string4);
            string5 = string5.replaceAll(templateVarTagLink, string3);
            string5 = string5.replaceAll(templateVarTagWeight, Double.toString(tag.getWeight()));
            string5 = string5.replaceAll(templateVarTagWeightInt, Integer.toString(tag.getWeightInt(cloud.getRounding())));
            string5 = string5.replaceAll(templateVarTagNormScore, Double.toString(tag.getNormScore()));
            string5 = string5.replaceAll(templateVarTagScore, Double.toString(tag.getScore()));
            string5 = string5.replaceAll(templateVarTagScoreInt, Integer.toString(tag.getScoreInt()));
            string5 = string5.replaceAll(templateVarTagNormScoreInt, Integer.toString(tag.getNormScoreInt()));
            string = string + string5;
        }
        string = string + this.getHtmlTemplateBottom();
        return string;
    }

    public String html(Cloud cloud) {
        return this.html(cloud, null);
    }

    public String css(Cloud cloud) {
        int n;
        int n2;
        String string = "";
        if (cloud.getRounding() == Cloud.Rounding.FLOOR) {
            n2 = (int)Math.floor(cloud.getMinWeight());
            n = (int)Math.floor(cloud.getMaxWeight());
        } else if (cloud.getRounding() == Cloud.Rounding.ROUND) {
            n2 = (int)Math.round(cloud.getMinWeight());
            n = (int)Math.round(cloud.getMaxWeight());
        } else {
            n2 = (int)Math.ceil(cloud.getMinWeight());
            n = (int)Math.ceil(cloud.getMaxWeight());
        }
        int n3 = n - n2 + 1;
        for (String string2 : this.cssFragments.keySet()) {
            List<CssStatement> list = this.cssFragments.get(string2);
            if (string2.length() == 0) {
                for (CssStatement cssStatement : list) {
                    if (cssStatement.getProperty() == null) continue;
                    string = string + cssStatement.getProperty() + "\n\n";
                }
                continue;
            }
            if (string2.contains(templateVarTagWeightInt)) {
                for (int i = 0; i < n3; ++i) {
                    string = string + string2.replace(templateVarTagWeightInt, Integer.toString(i)) + " {\n";
                    for (CssStatement cssStatement : list) {
                        String string3 = this.generateVariableCss(cssStatement, i, n3);
                        if (string3 == null || string3.length() == 0) continue;
                        string = string + "\t" + string3;
                    }
                    string = string + "}\n\n";
                }
                continue;
            }
            for (int i = 0; i < n3; ++i) {
                string = string + string2 + " {\n";
                for (CssStatement cssStatement : list) {
                    if (cssStatement.getProperty() == null) continue;
                    string = string + "\t" + cssStatement.getProperty() + "\n";
                }
                string = string + "}\n\n";
            }
        }
        return string;
    }

    protected String generateVariableCss(CssStatement cssStatement, int n, int n2) {
        String string = "";
        if (cssStatement.getProperty() != null) {
            if (cssStatement.getLowValue() != null && cssStatement.getHighValue() != null) {
                double d = cssStatement.getLowValue().doubleValue();
                double d2 = cssStatement.getHighValue().doubleValue();
                double d3 = d + (d2 - d) * (double)n / (double)(n2 - 1);
                string = string + cssStatement.getProperty() + ": ";
                string = cssStatement.getLowValue() instanceof Double || cssStatement.getLowValue() instanceof Float || cssStatement.getHighValue() instanceof Double || cssStatement.getHighValue() instanceof Float ? string + d3 : string + (int)d3;
                string = string + ";\n";
            } else if (cssStatement.getValues() != null && cssStatement.getValues().length > 0) {
                String string2;
                int n3 = cssStatement.getValues().length - n2 + n;
                if (n3 < 0) {
                    n3 = 0;
                }
                if ((string2 = cssStatement.getValues()[n3]) != null && string2.length() != 0) {
                    string = string + cssStatement.getProperty() + ": " + string2 + ";\n";
                }
            } else {
                string = string + cssStatement.getProperty() + "\n";
            }
        }
        return string;
    }

    public String getHtmlTemplateBottom() {
        return this.htmlTemplateBottom;
    }

    public void setHtmlTemplateBottom(String string) {
        this.htmlTemplateBottom = string;
    }

    public String getHtmlTemplateTag() {
        return this.htmlTemplateTag;
    }

    public void setHtmlTemplateTag(String string) {
        this.htmlTemplateTag = string;
    }

    public String getHtmlTemplateTop() {
        return this.htmlTemplateTop;
    }

    public void setHtmlTemplateTop(String string) {
        this.htmlTemplateTop = string;
    }

    protected Map<String, List<CssStatement>> getCssFragments() {
        return this.cssFragments;
    }

    protected void setCssFragments(Map<String, List<CssStatement>> map) {
        this.cssFragments = map;
    }
}

