/*
 * Decompiled with CFR 0.152.
 */
package org.mcavallo.opencloud.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLFile {
    private XPath xpath;
    private NamespaceContext namespaceContext;
    private Document document = null;
    private Node rootNode = null;
    private Proxy proxy = null;
    private int connectTimeout = 10000;
    private int readTimeout = 10000;

    public XMLFile() throws ParserConfigurationException {
        this.inizialize();
    }

    private void inizialize() throws ParserConfigurationException {
        this.xpath = XPathFactory.newInstance().newXPath();
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        this.document = documentBuilder.newDocument();
    }

    public void readFile(String string) throws IOException, ParserConfigurationException, SAXException {
        FileInputStream fileInputStream = new FileInputStream(string);
        this.readInputStream(fileInputStream);
    }

    public void readString(String string) throws ParserConfigurationException, SAXException, IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        this.readInputStream(byteArrayInputStream);
    }

    public void readURL(URL uRL) throws IOException, ParserConfigurationException, SAXException {
        URLConnection uRLConnection = this.proxy == null ? uRL.openConnection() : uRL.openConnection(this.proxy);
        uRLConnection.setConnectTimeout(this.connectTimeout);
        uRLConnection.setReadTimeout(this.readTimeout);
        uRLConnection.connect();
        InputStream inputStream = uRLConnection.getInputStream();
        this.readInputStream(inputStream);
    }

    public void readInputStream(InputStream inputStream) throws ParserConfigurationException, SAXException, IOException {
        if (inputStream == null) {
            return;
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        this.document = documentBuilder.parse(inputStream);
    }

    public void readDocument(Document document) {
        this.document = document;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(final Proxy proxy) {
        this.proxy = proxy;
        ProxySelector.setDefault(new ProxySelector(){

            @Override
            public void connectFailed(URI uRI, SocketAddress socketAddress, IOException iOException) {
                iOException.printStackTrace();
            }

            @Override
            public List<Proxy> select(URI uRI) {
                ArrayList<Proxy> arrayList = new ArrayList<Proxy>();
                arrayList.add(proxy);
                return arrayList;
            }
        });
    }

    public void setProxy(String string, int n) {
        Proxy proxy;
        this.proxy = proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(string, n));
        ProxySelector.setDefault(new ProxySelector(){

            @Override
            public void connectFailed(URI uRI, SocketAddress socketAddress, IOException iOException) {
                iOException.printStackTrace();
            }

            @Override
            public List<Proxy> select(URI uRI) {
                ArrayList<Proxy> arrayList = new ArrayList<Proxy>();
                arrayList.add(proxy);
                return arrayList;
            }
        });
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int n) {
        this.connectTimeout = n;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int n) {
        this.readTimeout = n;
    }

    public NamespaceContext getNamespaceContext() {
        return this.namespaceContext;
    }

    public void setNamespaceContext(NamespaceContext namespaceContext) {
        this.namespaceContext = namespaceContext;
    }

    public void setNamespaceContext(final String string, final String string2) {
        this.namespaceContext = new NamespaceContext(){

            public String getNamespaceURI(String string3) {
                if (string3 == null) {
                    throw new NullPointerException("Null prefix");
                }
                if (string3.equals(string)) {
                    return string2;
                }
                return "";
            }

            public String getPrefix(String string3) {
                throw new UnsupportedOperationException();
            }

            public Iterator getPrefixes(String string3) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Node getNode(String string) throws XPathExpressionException {
        Node node = null;
        if (this.rootNode != null) {
            node = (Node)this.xpath.evaluate(string, this.rootNode, XPathConstants.NODE);
        } else if (this.document != null) {
            node = (Node)this.xpath.evaluate(string, this.document, XPathConstants.NODE);
        }
        return node;
    }

    public Node getNode(String string, Node node) throws XPathExpressionException {
        Node node2 = null;
        if (node != null) {
            node2 = (Node)this.xpath.evaluate(string, node, XPathConstants.NODE);
        } else if (this.document != null) {
            node2 = this.getNode(string);
        }
        return node2;
    }

    public NodeList getNodes(String string) throws XPathExpressionException {
        NodeList nodeList = null;
        if (this.rootNode != null) {
            nodeList = (NodeList)this.xpath.evaluate(string, this.rootNode, XPathConstants.NODESET);
        } else if (this.document != null) {
            nodeList = (NodeList)this.xpath.evaluate(string, this.document, XPathConstants.NODESET);
        }
        return nodeList;
    }

    public NodeList getNodes(String string, Node node) throws XPathExpressionException {
        NodeList nodeList = null;
        nodeList = node != null ? (NodeList)this.xpath.evaluate(string, node, XPathConstants.NODESET) : this.getNodes(string);
        return nodeList;
    }

    public Document getDocument() {
        return this.document;
    }

    public void writeToFile(String string) throws FileNotFoundException, TransformerException {
        this.writeToStream(new FileOutputStream(string));
    }

    public void writeToFile(File file) throws FileNotFoundException, TransformerException {
        this.writeToStream(new FileOutputStream(file));
    }

    public void writeToStream(OutputStream outputStream) throws TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(new DOMSource(this.document), new StreamResult(outputStream));
    }

    public void addNode(Node node, Node node2) {
        if (node == null) {
            return;
        }
        node.appendChild(node2);
    }

    public void addNode(Node node, String string) {
        if (node == null) {
            return;
        }
        Element element = this.document.createElement(string);
        node.appendChild(element);
    }

    public void addNode(String string, Node node) throws XPathExpressionException {
        Node node2 = this.getNode(string);
        this.addNode(node2, node);
    }

    public void addNode(String string, String string2) throws XPathExpressionException {
        Node node = this.getNode(string);
        this.addNode(node, string2);
    }

    public void addAttribute(Node node, String string, String string2) {
        if (node == null) {
            return;
        }
        Attr attr = this.document.createAttribute(string);
        attr.setValue(string2);
        node.appendChild(attr);
    }

    public void addAttribute(String string, String string2, String string3) throws XPathExpressionException {
        Node node = this.getNode(string);
        this.addAttribute(node, string2, string3);
    }

    public void addText(Node node, String string) {
        if (node == null) {
            return;
        }
        node.setTextContent(string);
    }

    public void addText(String string, String string2) throws XPathExpressionException {
        Node node = this.getNode(string);
        this.addText(node, string2);
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public Node getRootNode() {
        return this.rootNode;
    }

    public void setRootNode(Node node) {
        this.rootNode = node;
    }

    public void setRootNode(String string) throws XPathExpressionException {
        this.rootNode = string == null ? null : (Node)this.xpath.evaluate(string, this.document, XPathConstants.NODE);
    }
}

