/*
 * Decompiled with CFR 0.152.
 */
package mds.devices;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import mds.Mds;
import mds.MdsException;
import mds.data.CTX;
import mds.data.TREE;
import mds.data.descriptor.Descriptor;
import mds.data.descriptor_r.Conglom;
import mds.data.descriptor_s.NODE;
import mds.data.descriptor_s.Nid;
import mds.data.descriptor_s.StringDsc;
import mds.devices.Interface;
import mds.jtraverser.editor.Editor;
import mds.jtraverser.editor.EnumEditor;
import mds.jtraverser.editor.ExprEditor;
import mds.mdsip.MdsIp;

public class Device
implements Interface {
    protected final NODE<?> head;
    protected final Editor[] edit;
    protected final NODE<?>[] node;
    protected final boolean editable;
    protected JComponent pane;
    protected final Frame frame;
    private final TREE tree;
    private final Mds mds;

    public static Device getEditor(Frame frame, Nid nid, boolean editable) throws Exception {
        return Device.getEditor(frame, nid, editable, Device.getModel(nid));
    }

    public static Device getEditor(Frame frame, Nid nid, boolean editable, String model) throws Exception {
        Class device_cls;
        try {
            device_cls = Class.forName("mds.devices." + model.toString());
        }
        catch (ClassNotFoundException e) {
            device_cls = Device.class;
        }
        return (Device)device_cls.getConstructor(Frame.class, NODE.class, Boolean.TYPE).newInstance(frame, nid, editable);
    }

    private static final String getModel(Nid nid) throws Exception {
        Conglom conglom = (Conglom)nid.getRecord();
        if (conglom == null) {
            throw new Exception("Record not a Conglom");
        }
        StringDsc model = (StringDsc)conglom.getModel().getDataS();
        if (model == null) {
            throw new Exception("No model string");
        }
        return model.toString();
    }

    public static void main(String ... args) throws Exception {
        Device.showDeviceSetup(args[0], Integer.parseInt(args[1]), args[2]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showDeviceSetup(String experiment, int shot, String path) throws Exception {
        block28: {
            try (MdsIp mds = new MdsIp();
                 TREE tree = new TREE((Mds)mds, experiment, shot, TREE.NORMAL);){
                Nid nid = tree.getNode(path);
                final JDialog dialog = Device.showDialog(null, nid, !tree.is_readonly());
                if (dialog == null) break block28;
                dialog.addWindowListener(new WindowAdapter(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void windowClosed(WindowEvent e) {
                        JDialog jDialog = dialog;
                        synchronized (jDialog) {
                            dialog.notifyAll();
                        }
                    }
                });
                JDialog jDialog = dialog;
                synchronized (jDialog) {
                    while (dialog.isShowing()) {
                        dialog.wait(1000L);
                    }
                }
            }
        }
    }

    public static JDialog showDialog(Frame frame, Nid nid, boolean editable) throws Exception {
        String model = Device.getModel(nid);
        try {
            int nidnum = nid.getNidNumber();
            Class<?> devicesetup = Class.forName("DeviceSetup");
            Interface.Setup setup = (Interface.Setup)devicesetup.getMethod("getSetup", Integer.TYPE, Boolean.TYPE).invoke(null, nidnum, !editable);
            if (setup == null) {
                return (JDialog)devicesetup.getMethod("newSetup", Integer.TYPE, String.class, Interface.class, Object.class, Boolean.TYPE).invoke(null, nidnum, model, new Device((NODE<?>)nid), frame, !editable);
            }
            return null;
        }
        catch (Exception e) {
            return Device.getEditor(frame, nid, editable, model).showDialog();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Device(Frame frame, NODE<?> head, boolean editable) {
        byte usage;
        int i;
        NODE[] nodes;
        TREE.NodeInfo[] node_infos;
        this.frame = frame;
        this.pane = new JPanel();
        this.head = head;
        this.editable = editable;
        this.tree = head.getTree();
        this.mds = this.tree.getMds();
        try {
            Nid olddefault = this.tree.getDefaultC();
            this.head.setDefault();
            try {
                node_infos = TREE.NodeInfo.getDeviceNodeInfos(head, (Mds)this.mds, (CTX)this.tree);
            }
            finally {
                olddefault.setDefault();
            }
            nodes = new NODE[node_infos.length];
        }
        catch (MdsException e) {
            System.err.println((Object)e);
            nodes = new NODE[]{head};
            node_infos = null;
        }
        this.node = nodes;
        this.edit = new Editor[nodes.length];
        this.pane.setLayout(new GridLayout(0, 1));
        if (node_infos == null) {
            return;
        }
        for (i = 1; i < this.node.length; ++i) {
            String orig_name;
            usage = node_infos[i].usage;
            int flags = node_infos[i].get_flags;
            if (usage == 1 || (flags & 0x880) > 0 || (flags & 0x1040) == 0) continue;
            String name = node_infos[i].minpath;
            this.node[i] = new Nid(node_infos[i].nid_number, this.tree);
            this.node[i].setNodeInfoC(node_infos[i]);
            try {
                orig_name = this.node[i].getNciOriginalPartName();
            }
            catch (MdsException e) {
                orig_name = name;
            }
            this.addExpr(i, name, orig_name, false, false);
        }
        if (this.pane.getComponentCount() == 0) {
            for (i = 1; i < this.node.length; ++i) {
                String orig_name;
                usage = node_infos[i].usage;
                if (usage == 1) continue;
                String name = node_infos[i].minpath;
                this.node[i] = new Nid(node_infos[i].nid_number, this.tree);
                this.node[i].setNodeInfoC(node_infos[i]);
                try {
                    orig_name = this.node[i].getNciOriginalPartName();
                }
                catch (MdsException e) {
                    orig_name = name;
                }
                this.addExpr(i, name, orig_name, false, false);
            }
        }
        JScrollPane sp = new JScrollPane(this.pane);
        sp.setVerticalScrollBarPolicy(22);
        int lineheight = this.pane.getComponent((int)0).getPreferredSize().height;
        int maxheight = lineheight * 7 + 3;
        sp.getVerticalScrollBar().setUnitIncrement(lineheight);
        sp.setMaximumSize(new Dimension(-1, maxheight));
        Dimension prefsize = sp.getPreferredSize();
        if (prefsize.height > maxheight) {
            prefsize.height = maxheight;
        }
        prefsize.width *= 3;
        sp.setPreferredSize(prefsize);
        this.pane = sp;
    }

    protected Device(Frame frame, NODE<?> head, boolean editable, int nargs) {
        this.frame = frame;
        this.pane = new JPanel();
        this.head = head;
        this.editable = editable;
        this.edit = new Editor[nargs];
        this.node = new NODE[nargs];
        this.tree = head.getTree();
        this.mds = this.tree.getMds();
    }

    public Device(NODE<?> head) {
        this.head = head;
        this.tree = head.getTree();
        this.mds = this.tree.getMds();
        this.edit = null;
        this.node = null;
        this.frame = null;
        this.editable = false;
    }

    protected final void addEnum(int idx, String path, String tooltip, EnumEditor.MODE mode, String ... items) {
        try {
            if (this.node[idx] == null) {
                this.node[idx] = this.head.getNode(path);
            }
            TREE.NodeInfo ni = this.node[idx].getNodeInfoC();
            this.edit[idx] = Editor.addLabel(String.format("%s   [%s]", path, NODE.getUsageStr((byte)ni.usage)), new EnumEditor(this.node[idx].getRecord(), this.editable, (CTX)this.head.getTree(), tooltip, mode, items));
            this.pane.add(Editor.addButtons(this.edit[idx], this.node[idx]));
        }
        catch (MdsException e) {
            JOptionPane.showMessageDialog(this.frame, (Object)((Object)e) + "\n" + e.getMessage(), "addEnum " + path, 2);
        }
    }

    protected final void addExpr(int idx, String path, String tooltip, boolean default_to_string, boolean isField) {
        try {
            if (this.node[idx] == null) {
                this.node[idx] = this.head.getNode(path);
            }
            TREE.NodeInfo ni = this.node[idx].getNodeInfoC();
            this.edit[idx] = Editor.addLabel(String.format("%s   [%s]", path, NODE.getUsageStr((byte)ni.usage)), new ExprEditor(this.node[idx].getRecord(), this.editable, (CTX)this.head.getTree(), tooltip, default_to_string, isField));
            this.pane.add(Editor.addButtons(this.edit[idx], this.node[idx]));
        }
        catch (MdsException e) {
            JOptionPane.showMessageDialog(this.frame, (Object)((Object)e) + "\n" + e.getMessage(), "addExpr " + path, 2);
        }
    }

    @Override
    public void dataChanged(int ... nids) {
    }

    @Override
    public final void doDeviceMethod(int nid, String method) throws Exception {
        this.tree.doDeviceMethod(nid, method, new Descriptor[0]);
    }

    @Override
    public String execute(String expr) throws Exception {
        return this.mds.getDescriptor((CTX)this.tree, expr, new Descriptor[0]).decompile();
    }

    @Override
    public final String getDataExpr(int nid) throws Exception {
        return this.tree.getRecord(nid).decompile();
    }

    @Override
    public final int getDefault() throws Exception {
        return this.tree.getDefault();
    }

    @Override
    public double getDouble(String expr) throws Exception {
        return this.mds.getDouble((CTX)this.tree, expr, new Descriptor[0]);
    }

    @Override
    public float getFloat(String expr) throws Exception {
        return this.mds.getFloat((CTX)this.tree, expr, new Descriptor[0]);
    }

    @Override
    public float[] getFloatArray(String expr) throws Exception {
        return this.mds.getFloatArray((CTX)this.tree, expr, new Descriptor[0]);
    }

    @Override
    public final String getFullPath(int nid) throws Exception {
        return this.tree.getNciFullPath(nid);
    }

    @Override
    public int getInt(String expr) throws Exception {
        return this.mds.getInteger((CTX)this.tree, expr, new Descriptor[0]);
    }

    @Override
    public int[] getIntArray(String expr) throws Exception {
        return this.mds.getIntegerArray((CTX)this.tree, expr, new Descriptor[0]);
    }

    @Override
    public final String getName() {
        return this.tree.expt;
    }

    @Override
    public int getNode(String path) throws Exception {
        return this.tree.getNode(path).getNciNidNumber();
    }

    @Override
    public String getNodeName(int nid) throws Exception {
        return this.tree.getNciNodeName(nid);
    }

    @Override
    public int getNumConglomerateNids(int nid) throws Exception {
        return this.tree.getNciNumberOfElts(nid);
    }

    public JComponent getPane() {
        return this.pane;
    }

    @Override
    public final int getShot() {
        return this.tree.shot;
    }

    @Override
    public String getString(String expr) throws Exception {
        return this.mds.getString((CTX)this.tree, expr, new Descriptor[0]);
    }

    @Override
    public String[] getStringArray(String expr) throws Exception {
        return this.mds.getStringArray((CTX)this.tree, expr, new Descriptor[0]);
    }

    @Override
    public String getUsage(int nid) throws Exception {
        return NODE.getUsageStr((byte)this.tree.getNciUsage(nid));
    }

    @Override
    public boolean isOn(int nid) throws Exception {
        return this.tree.getNciState(nid) == 0;
    }

    @Override
    public void putDataExpr(int nid, String expr) throws Exception {
        this.tree.putRecord(nid, this.mds.getAPI().tdiCompile((CTX)this.tree, expr, new Descriptor[0]).getData());
    }

    @Override
    public final void setDefault(int nid) throws Exception {
        this.tree.setDefault(nid);
    }

    @Override
    public void setOn(int nid, boolean on) throws Exception {
        this.tree.getNode(nid).setOn(on);
    }

    public final JDialog showDialog() {
        String path;
        try {
            path = this.head.getNciPath();
        }
        catch (MdsException e) {
            path = this.head.toString();
        }
        String title = this.getClass().getSimpleName() + ": " + path;
        JDialog dialog = new JDialog(this.frame, title);
        dialog.add(this.pane);
        dialog.pack();
        dialog.setVisible(true);
        return dialog;
    }
}

