/*
 * Decompiled with CFR 0.152.
 */
package mds.devices.acq4xx;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.lang.reflect.Constructor;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import mds.Mds;
import mds.MdsException;
import mds.data.TREE;
import mds.data.descriptor_s.NODE;
import mds.data.descriptor_s.Nid;
import mds.devices.Device;
import mds.devices.acq4xx.ACQ480;
import mds.devices.acq4xx.ACQ4xx;
import mds.jtraverser.editor.Editor;
import mds.jtraverser.editor.EnumEditor;
import mds.mdsip.MdsIp;

public class ACQ1001
extends Device {
    final ACQ4xx module;
    final ACQ4xx.Master master;
    final Class<?> module_class;

    public static void main(String ... args) throws MdsException {
        try (MdsIp mds = new MdsIp();
             TREE tree = new TREE((Mds)mds, "test", 1, TREE.NEW);){
            Nid dev = tree.getTop().addConglom("DEVICE", "ACQ2106_ACQ480x4");
            new ACQ1001(null, (NODE<?>)dev, true, ACQ480.class).showDialog();
        }
    }

    public ACQ1001(Frame frame, NODE<?> head, boolean editable, Class<?> module_class) {
        super(frame, head, editable, 8);
        ACQ4xx mod;
        this.module_class = module_class;
        JComponent main = this.pane;
        main.setLayout(new BorderLayout());
        this.pane = new JPanel(new GridLayout(0, 1));
        this.addExpr(0, "CLOCK", "sampling clock", false, false);
        this.addExpr(1, "HOST", "hostname/ip of acq", true, false);
        this.addExpr(2, "COMMENT", "a comment", true, false);
        try {
            this.addEnum(3, "CLOCK:SRC", "master clock in", EnumEditor.MODE.ASIS, head.getNode("CLOCK:SRC:ZCLK").decompile());
        }
        catch (MdsException e) {
            this.addExpr(3, "CLOCK:SRC", "master clock in", false, false);
        }
        this.addExpr(4, "TRIGGER", "time offset of first trigger", false, false);
        this.addEnum(5, "TRIGGER:EDGE", "triggger edge", EnumEditor.MODE.STRING, "rising", "falling");
        this.addExpr(6, "TRIGGER:POST", "number of samples post trigger", false, false);
        this.addExpr(7, "TRIGGER:PRE", "number of samples pre trigger", false, false);
        main.add((Component)this.pane, "North");
        this.pane = new JTabbedPane();
        this.pane.add((Component)main, "Master");
        String path = "MODULE1";
        try {
            Constructor<?> modconst = this.module_class.getConstructor(Frame.class, NODE.class, Boolean.TYPE, Integer.TYPE);
            mod = (ACQ4xx)modconst.newInstance(this.frame, this.head == null ? null : this.head.getNode("MODULE1"), this.editable, 0);
        }
        catch (Exception e) {
            mod = null;
            JOptionPane.showMessageDialog(null, e.getMessage(), String.format("MODULE1 (%s)", module_class.getName()), 0);
        }
        this.module = mod;
        if (mod == null) {
            this.master = null;
        } else {
            this.pane.add((Component)this.module.getPane(), "MODULE1");
            this.master = this.module.getMaster();
            if (this.master != null) {
                main.add((Component)Editor.addLabel("MASTER", this.master.getPane()), "South");
            }
        }
    }
}

