/*
 * Decompiled with CFR 0.152.
 */
package mds.devices.acq4xx;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import javax.swing.JScrollPane;
import mds.MdsException;
import mds.data.descriptor_s.NODE;
import mds.data.descriptor_s.Nid;
import mds.devices.acq4xx.ACQ4xx;
import mds.jtraverser.editor.Editor;
import mds.jtraverser.editor.EnumEditor;

public class ACQ425
extends ACQ4xx {
    private final Channel[] channel;
    private final int index;
    private final int maxfreq = 2000;

    private ACQ425(Frame frame, NODE<?> node, boolean editable, int index, int numchan) {
        super(frame, node, editable, 0);
        this.pane.setLayout(new GridLayout(0, 1));
        this.index = index;
        this.channel = new Channel[numchan];
        for (int i = 0; i < this.channel.length; ++i) {
            this.addChannel(i);
        }
        JScrollPane sp = new JScrollPane(this.pane);
        sp.setVerticalScrollBarPolicy(22);
        int lineheight = this.pane.getComponent((int)0).getPreferredSize().height;
        int maxheight = lineheight * 8 + 3;
        sp.getVerticalScrollBar().setUnitIncrement(lineheight);
        sp.setMaximumSize(new Dimension(-1, maxheight));
        Dimension prefsize = sp.getPreferredSize();
        if (prefsize.height > maxheight) {
            prefsize.height = maxheight;
            sp.setPreferredSize(prefsize);
        }
        this.pane = sp;
    }

    private void addChannel(int i) {
        String path = String.format("CHANNEL%02d", this.index * this.channel.length + i + 1);
        try {
            Nid chan = this.head == null ? null : this.head.getNode(path);
            this.channel[i] = new Channel((NODE<?>)chan);
            this.pane.add(Editor.addLabel(path, this.channel[i].getPane()));
        }
        catch (MdsException e) {
            System.err.println(path);
            e.printStackTrace();
        }
    }

    public class Channel
    extends ACQ4xx.Channel {
        protected Channel(NODE<?> node) {
            super(ACQ425.this, node, 3);
            this.addEnum(0, "GAIN", "input range in volt", EnumEditor.MODE.ASIS, "10", "5", "2", "1");
            this.addExpr(1, "OFFSET", "input offset in volt", false, false);
            this.addEnum(2, "RANGE", "range expression used for data reduction DATA[RANGE]", EnumEditor.MODE.ASIS, "*:*:1");
        }
    }

    public static class ACQ425_8CH
    extends ACQ425 {
        public ACQ425_8CH(Frame frame, NODE<?> node, boolean editable, int index) {
            super(frame, node, editable, index, 8);
        }
    }

    public static class ACQ425_4CH
    extends ACQ425 {
        public ACQ425_4CH(Frame frame, NODE<?> node, boolean editable, int index) {
            super(frame, node, editable, index, 4);
        }
    }

    public static class ACQ425_16CH
    extends ACQ425 {
        public ACQ425_16CH(Frame frame, NODE<?> node, boolean editable, int index) {
            super(frame, node, editable, index, 16);
        }
    }

    public static class ACQ425_12CH
    extends ACQ425 {
        public ACQ425_12CH(Frame frame, NODE<?> node, boolean editable, int index) {
            super(frame, node, editable, index, 12);
        }
    }
}

