/*
 * Decompiled with CFR 0.152.
 */
package mds.jtraverser;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.nio.channels.ReadableByteChannel;
import java.util.Stack;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicButtonUI;
import mds.Mds;
import mds.MdsException;
import mds.TransferEventListener;
import mds.data.TREE;
import mds.jtraverser.Node;
import mds.jtraverser.TreeManager;
import mds.jtraverser.TreeView;
import mds.mdsip.MdsIp;

public class MdsView
extends JTabbedPane
implements TransferEventListener {
    private static final long serialVersionUID = 1L;
    final TreeManager treeman;
    private final Mds mds;
    private final Stack<TreeView> trees = new Stack();
    Vector<TreeManager.Job> change_report_listeners = new Vector();

    public MdsView(TreeManager treeman, Mds mds) {
        this.treeman = treeman;
        this.mds = mds;
        try {
            mds.getAPI().setenv("MDSPLUS_DEFAULT_RESAMPLE_MODE", "MinMax");
        }
        catch (MdsException e) {
            MdsException.stderr((String)"MDSPLUS_DEFAULT_RESAMPLE_MODE not set!", (Exception)((Object)e));
        }
        mds.addTransferEventListener((TransferEventListener)this);
        this.setPreferredSize(new Dimension(300, 400));
        this.setTabLayoutPolicy(1);
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ce) {
                TREE tree = MdsView.this.getCurrentTree();
                if (tree == null) {
                    return;
                }
                try {
                    tree.setActive();
                }
                catch (MdsException mdsException) {
                    // empty catch block
                }
                MdsView.this.reportChange();
            }
        });
    }

    public void addChangeReportListener(TreeManager.Job job) {
        this.change_report_listeners.add(job);
    }

    public final MdsView close(boolean quit) {
        while (!this.trees.empty()) {
            this.trees.pop().close(quit);
        }
        this.mds.close();
        if (this.mds instanceof MdsIp) {
            MdsIp.removeSharedConnection((MdsIp)((MdsIp)this.mds));
        }
        return this;
    }

    public final void closeTree(boolean quit) {
        TreeView treeview = this.getCurrentTreeView();
        if (treeview == null) {
            return;
        }
        this.closeTree(this.getSelectedIndex(), quit);
    }

    private void closeTree(int idx, boolean quit) {
        if (idx >= this.getTabCount() || idx < 0) {
            return;
        }
        this.trees.remove(this.getTreeAt(idx).close(quit));
        this.removeTabAt(idx);
        if (this.getTabCount() == 0) {
            this.treeman.reportChange();
        }
    }

    public void dispatchChangeReportListener() {
        for (TreeManager.Job job : this.change_report_listeners) {
            job.program();
        }
    }

    public final Node getCurrentNode() {
        TreeView tree = this.getCurrentTreeView();
        if (tree == null) {
            return null;
        }
        return tree.getCurrentNode();
    }

    public final TREE getCurrentTree() {
        TreeView tree = this.getCurrentTreeView();
        if (tree == null) {
            return null;
        }
        return tree.getTree();
    }

    public final TreeView getCurrentTreeView() {
        if (this.getTabCount() == 0) {
            return null;
        }
        return (TreeView)((JScrollPane)this.getSelectedComponent()).getViewport().getView();
    }

    public final Mds getMds() {
        return this.mds;
    }

    private final TreeView getTreeAt(int index) {
        return (TreeView)((JScrollPane)this.getComponentAt(index)).getViewport().getView();
    }

    public void handleTransferEvent(ReadableByteChannel is, String info, int read, int to_read) {
        if (to_read == 0) {
            this.setCursor(new Cursor(0));
            this.treeman.setProgress(this, 0, 1);
        } else {
            this.setCursor(new Cursor(3));
            this.treeman.setProgress(this, read, to_read);
        }
    }

    public final void openTree(String expt, int shot, TREE.MODE mode) {
        TreeView tree;
        if (shot == 0) {
            try {
                shot = this.mds.getAPI().treeGetCurrentShotId(null, expt);
            }
            catch (MdsException mdsException) {
                // empty catch block
            }
        }
        int index = -1;
        int i = this.getTabCount();
        while (i-- > 0) {
            TreeView tree2 = this.getTreeAt(i);
            if (!tree2.getExpt().equalsIgnoreCase(expt) || tree2.getShot() != shot) continue;
            tree2.close(false);
            this.remove(i);
            index = i;
        }
        if (index < 0) {
            index = this.getTabCount();
        }
        try {
            tree = new TreeView(this, expt, shot, mode);
        }
        catch (MdsException e) {
            JOptionPane.showMessageDialog(this.treeman, e.getMessage(), "Error opening tree " + expt, 0);
            return;
        }
        tree.addChangeReportListener(new TreeManager.Job(){

            @Override
            public void program() {
                MdsView.this.reportChange();
            }
        });
        tree.expandRow(0);
        this.add(new JScrollPane(tree), tree.getLabel(), index);
        this.setTabComponentAt(index, new ClosableTab());
        this.setSelectedIndex(index);
    }

    public void removeChangeReportListener(TreeManager.Job job) {
        this.change_report_listeners.remove(job);
    }

    public final synchronized void reportChange() {
        this.treeman.reportChange();
    }

    public void set_copy_format(int format) {
        for (TreeView tree : this.trees) {
            tree.set_copy_format(format);
        }
    }

    @Override
    public final String toString() {
        return this.mds.toString();
    }

    class ClosableTab
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public ClosableTab() {
            this.setLayout(new FlowLayout(0, 0, 0));
            this.setOpaque(false);
            JLabel label = new JLabel(){
                private static final long serialVersionUID = 1L;

                @Override
                public String getText() {
                    int index = MdsView.this.indexOfTabComponent(ClosableTab.this);
                    if (index != -1) {
                        return MdsView.this.getTitleAt(index);
                    }
                    return null;
                }
            };
            this.add(label);
            this.add(new CloseButton());
        }

        class CloseButton
        extends JButton
        implements MouseListener {
            private static final long serialVersionUID = 1L;
            static final int size = 8;
            static final int top = 3;
            static final int left = 2;

            public CloseButton() {
                this.setPreferredSize(new Dimension(10, 11));
                this.setToolTipText("close Tree");
                this.setContentAreaFilled(false);
                this.setBorderPainted(false);
                this.setFocusable(false);
                this.setUI(new BasicButtonUI());
                this.addMouseListener(this);
                this.setRolloverEnabled(true);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                int index = MdsView.this.indexOfTabComponent(ClosableTab.this);
                if (index != -1) {
                    MdsView.this.closeTree(index, false);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                this.setForeground(Color.RED);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                this.setForeground(Color.BLACK);
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                Graphics2D g2 = (Graphics2D)g.create();
                if (this.getModel().isPressed()) {
                    g2.translate(1, 1);
                }
                g2.setStroke(new BasicStroke(2.0f));
                g2.setColor(new Color(126, 118, 91));
                if (this.getModel().isRollover()) {
                    g2.setColor(Color.RED);
                }
                g2.drawLine(3, 4, this.getWidth() - 2, this.getHeight() - 2);
                g2.drawLine(this.getWidth() - 2, 4, 3, this.getHeight() - 2);
                g2.dispose();
            }

            @Override
            public void updateUI() {
            }
        }
    }
}

