/*
 * Decompiled with CFR 0.152.
 */
package mds.jtraverser;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import mds.MdsException;
import mds.data.DATA;
import mds.data.DTYPE;
import mds.data.TREE;
import mds.data.descriptor.Descriptor;
import mds.data.descriptor.Descriptor_S;
import mds.data.descriptor_r.Action;
import mds.data.descriptor_s.NODE;
import mds.data.descriptor_s.Nid;
import mds.devices.Device;
import mds.jtraverser.TreeView;

public class Node {
    private static Node copied;
    private static boolean cut;
    private static final ImageIcon[] ICONS;
    private static final String tab = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
    private TreeNodeLabel label;
    private Node[] members;
    public final Nid nid;
    private Node parent;
    private Node[] children;
    public final TreeView treeview;
    private DefaultMutableTreeNode treenode;
    private boolean needsOnCheck;
    DefaultMutableTreeNode dummy = null;
    boolean is_leaf;
    private int tooltip_default;
    private long tooltip_life;
    private String tooltip_text;
    private int length;
    private int ownerid;
    private int minpath_default;
    private String minpath;
    private String path;
    private String fullpath;
    private String name;
    private String timeinserted;
    private byte usage;
    private NODE.Flags flags;
    private byte dtype;
    private byte dclass;
    private String[] tags;
    private int rlength;
    private int num_segments;
    private int status;

    public static void copySubtreeContent(Node fromNode, Node toNode) {
        int i;
        try {
            fromNode.expand();
            toNode.expand();
        }
        catch (Exception exc) {
            MdsException.stderr((String)"Error expanding nodes", (Exception)exc);
        }
        try {
            Descriptor<?> data = fromNode.getRecord();
            if (data != null && !(data instanceof Action)) {
                toNode.setData(data);
            }
        }
        catch (MdsException data) {
            // empty catch block
        }
        for (i = 0; i < fromNode.children.length; ++i) {
            Node.copySubtreeContent(fromNode.children[i], toNode.children[i]);
        }
        for (i = 0; i < fromNode.members.length; ++i) {
            Node.copySubtreeContent(fromNode.members[i], toNode.members[i]);
        }
    }

    public static final Node getNode(DefaultMutableTreeNode treenode) {
        return treenode.getUserObject() instanceof Node ? (Node)treenode.getUserObject() : null;
    }

    public static final Node getNode(TreeNode treenode) {
        return Node.getNode((DefaultMutableTreeNode)treenode);
    }

    public static final String getUniqueName(String name, String[] usedNames) {
        int i;
        for (i = 0; i < usedNames.length && !name.equals(usedNames[i]); ++i) {
        }
        if (i == usedNames.length) {
            return name;
        }
        for (i = name.length() - 1; i > 0 && name.charAt(i) >= '0' && name.charAt(i) <= '9'; --i) {
        }
        String prevName = (name = name.substring(0, i + 1)).length() < 10 ? name : name.substring(0, 9);
        for (i = 1; i < 1000; ++i) {
            int j;
            String newName = prevName + i;
            for (j = 0; j < usedNames.length && !newName.equals(usedNames[j]); ++j) {
            }
            if (j != usedNames.length) continue;
            return newName;
        }
        return "XXXXXXX";
    }

    public static final boolean isCopied() {
        return copied != null;
    }

    private static final ImageIcon loadIcon(String gifname) {
        String base = System.getProperty("icon_base");
        if (base == null) {
            return new ImageIcon(Node.class.getClassLoader().getResource(gifname));
        }
        return new ImageIcon(base + "/" + gifname);
    }

    public static final void updateCell() {
    }

    public Node(TreeView treeview, Nid nid) {
        this(treeview, nid, null, null);
    }

    public Node(TreeView treeview, Nid nid, Node parent, TREE.NodeInfo info) {
        this.treeview = treeview;
        this.nid = nid;
        this.parent = parent;
        this.children = new Node[0];
        this.members = new Node[0];
        this.update();
        if (info == null) {
            try {
                this.readNodeInfo();
            }
            catch (Exception exc) {
                MdsException.stderr((String)"Error reading node info", (Exception)exc);
            }
        } else {
            this.copyNodeInfo(info);
        }
    }

    public final Node addChild(String new_name) throws MdsException {
        return this.addNode(new_name, (byte)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Node addDevice(String nodename, String type) throws MdsException {
        Nid new_nid;
        if (nodename == null || nodename.length() == 0 || nodename.length() > 12) {
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "Name length must range between 1 and 12 characters", "Error adding Node", 2);
            return null;
        }
        if (type == null || type.length() == 0) {
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "Missing device type", "Error adding Node", 2);
            return null;
        }
        Nid prev_default = this.nid.getTree().getDefaultNid();
        this.nid.setDefault();
        try {
            new_nid = this.nid.getTree().addConglom(nodename, type);
        }
        finally {
            prev_default.setDefault();
        }
        return this.addNode(new_nid, 3);
    }

    private final Node addNode(Nid new_nid, int new_usage) {
        boolean ismember = new_usage != 1 || new_usage != 11;
        Node newNode = new Node(this.treeview, new_nid, this, null);
        this.expand();
        if (ismember) {
            Node[] newNodes = new Node[this.members.length + 1];
            System.arraycopy(this.members, 0, newNodes, 0, this.members.length);
            newNodes[this.members.length] = newNode;
            this.members = newNodes;
        } else {
            Node[] newNodes = new Node[this.children.length + 1];
            System.arraycopy(this.children, 0, newNodes, 0, this.children.length);
            newNodes[this.children.length] = newNode;
            this.children = newNodes;
        }
        newNode.setTreeNode(new DefaultMutableTreeNode(newNode));
        this.treeview.addNodeToParent(newNode.getTreeNode(), this.getTreeNode());
        this.treeview.setCurrentNode(newNode);
        return newNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Node addNode(String new_name, byte new_usage) throws MdsException {
        Nid new_nid;
        Nid prev_default = this.nid.getTree().getDefaultNid();
        this.nid.setDefault();
        try {
            new_nid = this.nid.getTree().addNode(new_name, new_usage);
        }
        finally {
            prev_default.setDefault();
        }
        return this.addNode(new_nid, (int)new_usage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean changePath(Node newParent, String newName) {
        if (newParent == this.parent && newName == this.getName()) {
            return false;
        }
        if (newName.length() > 12 || newName.length() == 0) {
            JOptionPane.showMessageDialog(this.treeview, "Node name lengh must be between 1 and 12 characters", "Error renaming node: " + newName.length(), 2);
            return false;
        }
        try {
            Nid prev_default = this.nid.getTree().getDefaultNid();
            this.parent.setDefault();
            try {
                this.nid.setPath(newName);
            }
            finally {
                prev_default.setDefault();
            }
        }
        catch (Exception exc) {
            JOptionPane.showMessageDialog(this.treeview, "Error changing node path: " + exc, "Error changing node path", 2);
            return false;
        }
        if (newParent != this.parent) {
            this.parent = newParent;
            DefaultTreeModel tree_model = (DefaultTreeModel)this.treeview.getModel();
            tree_model.removeNodeFromParent(this.getTreeNode());
            this.treeview.addNodeToParent(this.getTreeNode(), this.parent.getTreeNode());
        }
        this.fullpath = null;
        this.path = null;
        this.minpath = null;
        this.name = null;
        this.treeview.reportChange();
        return true;
    }

    public final void clearFlag(byte idx) throws MdsException {
        this.clearFlags(1 << idx);
    }

    public final void clearFlags(int clr_flags) throws MdsException {
        this.flags = null;
        this.nid.clearFlags(clr_flags);
    }

    public final void copy() {
        cut = false;
        copied = this;
        MdsException.stdout((String)("copy: " + copied + " from " + Node.copied.parent));
    }

    private final void copyNodeInfo(TREE.NodeInfo info) {
        this.usage = info.usage;
        this.flags = new NODE.Flags(info.get_flags);
        this.status = info.status;
        this.is_leaf = info.num_descendants == 0;
        this.name = info.node_name;
        this.minpath = info.minpath;
        this.path = info.path;
        this.fullpath = info.fullpath;
    }

    public final void copyToClipboard() {
        try {
            Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection content = new StringSelection(this.getFullPath());
            cb.setContents(content, null);
        }
        catch (Exception e) {
            MdsException.stderr((String)"Cannot copy fullPath to Clipboard", (Exception)e);
        }
    }

    public final void cut() {
        cut = true;
        copied = this;
        MdsException.stdout((String)("cut: " + copied + " from " + Node.copied.parent));
    }

    public final void delete() {
        if (this.treeview.isEditable()) {
            this.treeview.deleteNode(this);
        } else {
            MdsException.stdout((String)("Cannot delete " + this + ". Tree not in edit mode."));
        }
    }

    public final boolean deleteExecute() {
        try {
            this.nid.getTree().deleteNodeExecute();
            return true;
        }
        catch (Exception exc) {
            MdsException.stderr((String)"Error executing delete", (Exception)exc);
            return false;
        }
    }

    public final int deleteInitialize() {
        try {
            return this.nid.deleteInitialize();
        }
        catch (Exception exc) {
            MdsException.stderr((String)"Error starting delete", (Exception)exc);
            return -1;
        }
    }

    public final void doAction() {
        this.nid.doAction();
    }

    public final void expand() {
        if (this.is_leaf) {
            return;
        }
        try {
            TREE tree = this.nid.getTree();
            TREE.NodeInfo[][] infos = TREE.NodeInfo.getNodeInfos((NODE)this.nid);
            TREE.NodeInfo[] children_info = infos[0];
            this.children = new Node[children_info.length];
            for (int i = 0; i < children_info.length; ++i) {
                this.children[i] = new Node(this.treeview, new Nid(children_info[i].nid_number, tree), this, children_info[i]);
            }
            TREE.NodeInfo[] members_info = infos[1];
            this.members = new Node[members_info.length];
            for (int i = 0; i < members_info.length; ++i) {
                this.members[i] = new Node(this.treeview, new Nid(members_info[i].nid_number, tree), this, members_info[i]);
            }
            if (this.members.length + this.children.length == 0) {
                this.is_leaf = true;
            }
        }
        catch (MdsException e) {
            MdsException.stderr((String)"expand", (Exception)((Object)e));
            e.printStackTrace();
            this.members = new Node[0];
            this.children = new Node[0];
        }
    }

    public final Node[] getChildren() {
        return this.children;
    }

    public final DATA<?> getData() throws MdsException {
        if (this.isSegmented()) {
            return (DATA)this.nid.getSegmentData(0);
        }
        return this.nid.getDATA();
    }

    public final String getDate() {
        if (this.timeinserted == null) {
            return this.readDate();
        }
        return this.timeinserted;
    }

    public final byte getDClass() {
        if (this.dclass == -1) {
            return this.readDClass();
        }
        return this.dclass;
    }

    public final DTYPE getDType() {
        if (this.dtype == -1) {
            this.readDType();
        }
        return DTYPE.values()[this.dtype & 0xFF];
    }

    public final NODE.Flags getFlags() {
        if (this.flags == null) {
            return this.readFlags();
        }
        return this.flags;
    }

    public final String getFullPath() {
        if (this.fullpath == null) {
            return this.readFullPath();
        }
        return this.fullpath;
    }

    public final Component getIcon(boolean isSelected) {
        byte lusage = this.getUsage();
        ImageIcon icon = lusage <= ICONS.length ? ICONS[lusage] : null;
        this.label = new TreeNodeLabel(this, this.getName(), icon, isSelected);
        return this.label;
    }

    public final String getInfoTextBox() {
        try {
            this.readRecordInfo();
        }
        catch (MdsException e) {
            MdsException.stderr((String)"Node.readRecordInfo", (Exception)((Object)e));
        }
        StringBuilder sb = new StringBuilder("<html><table width=\"240\"> <tr><td width=\"60\" align=\"left\"/><nobr>full path:</nobr></td><td align=\"left\">");
        sb.append(this.getFullPath());
        sb.append(" (").append(this.nid.getNidNumber()).append(")");
        sb.append("</td></tr><tr><td align=\"left\" valign=\"top\">Status:</td><td align=\"left\"><nobr>");
        String sep = "</nobr>, <nobr>";
        NODE.Flags lflags = this.getFlags();
        lflags.info(sb, "</nobr>, <nobr>");
        if (this.getUsage() == 1) {
            sb.append("</nobr>");
        } else if (this.getUsage() == 11) {
            String filename;
            sb.append("</nobr></td></tr><tr><td align=\"left\">File:</td><td align=\"left\">");
            TREE tree = this.nid.getTree();
            try {
                filename = this.nid.getNidNumber() == 0 ? tree.getFileName() : tree.getFileName(this.name);
            }
            catch (MdsException e) {
                filename = String.format("Could not find tree file.", this.name, this.nid.getTree().shot);
            }
            sb.append("<nobr>").append(filename).append("</nobr>");
        } else {
            sb.append("</nobr></td></tr><tr><td align=\"left\">Data:</td><td align=\"left\">");
            if (this.getLength() == 0) {
                sb.append("<nobr>There is no data stored for this node</nobr>");
            } else {
                String ldtype = this.getDType().name();
                String ldclass = Descriptor.getDClassName((byte)this.getDClass());
                sb.append("<nobr>").append(ldtype).append(tab).append(ldclass).append(tab).append(this.getLength()).append(" B (").append(this.getRLength()).append(" B)</nobr>");
                sb.append("</td></tr><tr><td align=\"left\">Inserted:</td><td align=\"left\">");
                sb.append(this.getDate());
            }
        }
        return sb.append("</td></tr></table></html>").toString();
    }

    public int getLength() {
        if (this.length == -1) {
            return this.readLength();
        }
        return this.length;
    }

    public final Node[] getMembers() {
        return this.members;
    }

    public final String getMinPath() {
        if (this.minpath == null || this.minpath_default != this.treeview.getDefault().getNidNumber()) {
            return this.readMinPath();
        }
        return this.minpath;
    }

    public String getName() {
        if (this.name == null) {
            return this.readName();
        }
        return this.name;
    }

    public int getNumSegments() {
        if (this.num_segments == -1) {
            return this.readNumSegments();
        }
        return this.num_segments;
    }

    public int getOwner() {
        if (this.ownerid == -1) {
            return this.readOwner();
        }
        return this.ownerid;
    }

    public final String getPath() {
        if (this.path == null) {
            return this.readPath();
        }
        return this.path;
    }

    public final Descriptor<?> getRecord() throws MdsException {
        if (this.isSegmented()) {
            return this.nid.getSegment(0);
        }
        return this.nid.getRecord();
    }

    public int getRLength() {
        if (this.rlength == -1) {
            return this.readRLength();
        }
        return this.rlength;
    }

    public final Descriptor<?> getSignal() throws MdsException {
        NODE res = this.nid.followReference();
        if (res.isSegmented()) {
            return res.getSegment(0);
        }
        return res.getRecord();
    }

    public int getStatus() {
        if (this.status == -1) {
            return this.readStatus();
        }
        return this.status;
    }

    public final String[] getTags() {
        if (this.tags == null) {
            return this.readTags();
        }
        return this.tags;
    }

    public final String getTagTextBox() {
        this.getTags();
        if (this.tags == null || this.tags.length == 0) {
            return "No Tags";
        }
        StringBuilder text = new StringBuilder(256).append("<html>");
        for (String tag : this.tags) {
            text.append(tag).append("<br>");
        }
        int len = text.length();
        return text.replace(len - 4, len, "</ht").append("ml>").toString();
    }

    public final String getToolTipText() {
        long now = System.nanoTime();
        int defaultnid = this.treeview.getDefault().getNidNumber();
        if (this.tooltip_text == null || now > this.tooltip_life || this.tooltip_default != defaultnid) {
            String text = null;
            String info = this.getInfoTextBox();
            byte lusage = this.getUsage();
            if (lusage == 1 || lusage == 11 || this.getLength() == 0) {
                this.tooltip_text = info;
            } else {
                try {
                    Descriptor<?> data = this.getRecord();
                    text = data.toStringX().replace("<", "&lt;").replace(">", "&gt;").replace("\t", "&nbsp&nbsp&nbsp&nbsp ").replace("\n", "<br>");
                }
                catch (MdsException e) {
                    text = e.getMessage();
                }
                StringBuilder sb = new StringBuilder().append(info.substring(0, info.length() - 7)).append("<hr><table");
                if (text.length() > 80) {
                    sb.append(" width=\"320\"");
                }
                this.tooltip_text = sb.append(">").append(text).append("</table></html>").toString();
            }
            this.tooltip_life = now + 10000000000L;
            this.tooltip_default = defaultnid;
        }
        return this.tooltip_text;
    }

    public final DefaultMutableTreeNode getTreeNode() {
        return this.treenode;
    }

    public final byte getUsage() {
        if (this.usage == -1) {
            return this.readUsage();
        }
        return this.usage;
    }

    public final boolean isDefault() {
        return this.treeview.getDefault().equals((Descriptor_S)this.nid);
    }

    public final boolean isOn() {
        if (this.needsOnCheck) {
            this.needsOnCheck = false;
            this.readFlags();
        }
        return this.flags.isOn();
    }

    public final boolean isSegmented() {
        if (this.flags.isSegmented()) {
            return true;
        }
        return this.getNumSegments() > 0;
    }

    public final boolean isSubTree() {
        return this.getUsage() == 11;
    }

    final boolean move(Node newParent) {
        return this.changePath(newParent, this.getName());
    }

    public final void paste() {
        if (!this.treeview.equals(Node.copied.treeview)) {
            MdsException.stderr((String)"Copying between different trees is not yet supported.", null);
        } else if (!this.treeview.isEditable()) {
            MdsException.stderr((String)("Cannot paste " + copied + ". Tree not in edit mode."), null);
        } else {
            MdsException.stdout((String)((cut ? "moved: " : "copied: ") + copied + " from " + Node.copied.parent + " to " + this));
            if (copied != null && copied != this) {
                if (cut) {
                    if (copied.move(this)) {
                        copied = null;
                    }
                } else {
                    this.treeview.pasteSubtree(copied, this, true);
                }
            }
        }
    }

    public final String readDate() {
        try {
            this.timeinserted = this.nid.getNciTimeInsertedStr();
            return this.timeinserted;
        }
        catch (MdsException e) {
            MdsException.stderr((String)"Error updating timeinserted", (Exception)((Object)e));
            return this.timeinserted;
        }
    }

    public final byte readDClass() {
        try {
            this.dclass = this.nid.getNciClass();
            return this.dclass;
        }
        catch (MdsException e) {
            MdsException.stderr((String)"Error updating class", (Exception)((Object)e));
            return this.dclass;
        }
    }

    public final byte readDType() {
        try {
            this.dtype = this.nid.getNciDType();
            return this.dtype;
        }
        catch (MdsException e) {
            MdsException.stderr((String)"Error updating dtype", (Exception)((Object)e));
            return this.dtype;
        }
    }

    public final NODE.Flags readFlags() {
        try {
            this.flags = new NODE.Flags(this.nid.getNciFlags());
            return this.flags;
        }
        catch (Exception e) {
            MdsException.stderr((String)"Error updating flags", (Exception)e);
            return this.flags;
        }
    }

    public final String readFullPath() {
        try {
            this.fullpath = this.nid.getNciFullPath();
            return this.fullpath;
        }
        catch (MdsException e) {
            MdsException.stderr((String)"Error updating fullpath", (Exception)((Object)e));
            return this.fullpath;
        }
    }

    public final int readLength() {
        try {
            this.length = this.nid.getNciLength();
            return this.length;
        }
        catch (MdsException e) {
            return this.length;
        }
    }

    public final String readMinPath() {
        try {
            this.minpath_default = this.treeview.getDefault().getNidNumber();
            this.minpath = this.nid.getNciMinPath();
            return this.minpath;
        }
        catch (MdsException e) {
            return this.minpath;
        }
    }

    public final String readName() {
        try {
            this.name = this.nid.getNciNodeName();
            return this.name;
        }
        catch (MdsException e) {
            return this.name;
        }
    }

    public final void readNodeInfo() throws MdsException {
        this.copyNodeInfo(this.nid.getNodeInfo());
    }

    public final int readNumSegments() {
        try {
            this.num_segments = this.nid.getNumSegments();
            return this.num_segments;
        }
        catch (MdsException e) {
            return this.num_segments;
        }
    }

    public final int readOwner() {
        try {
            this.ownerid = this.nid.getNciOwnerId();
            return this.ownerid;
        }
        catch (MdsException e) {
            return this.ownerid;
        }
    }

    public final String readPath() {
        try {
            this.path = this.nid.getNciPath();
            return this.path;
        }
        catch (MdsException e) {
            return this.path;
        }
    }

    public final void readRecordInfo() throws MdsException {
        TREE.RecordInfo ri = this.nid.getRecordInfo();
        this.dtype = ri.dtype;
        this.dclass = ri.dclass;
        this.flags = new NODE.Flags(ri.get_flags);
        this.length = ri.length;
        this.rlength = ri.rlength;
        this.num_segments = ri.num_segments;
    }

    public final int readRLength() {
        try {
            this.rlength = this.nid.getNciRLength();
            return this.rlength;
        }
        catch (MdsException e) {
            return this.rlength;
        }
    }

    public final int readStatus() {
        try {
            this.status = this.nid.getNciStatus();
            return this.status;
        }
        catch (MdsException e) {
            return this.status;
        }
    }

    public final String[] readTags() {
        try {
            this.tags = this.nid.getTags();
            return this.tags;
        }
        catch (MdsException e) {
            this.tags = new String[0];
            return this.tags;
        }
    }

    public final byte readUsage() {
        try {
            this.usage = this.nid.getNciUsage();
            return this.usage;
        }
        catch (MdsException e) {
            return this.usage;
        }
    }

    public final boolean rename(String newName) {
        return this.changePath(this.parent, newName);
    }

    public final Nid resolveRefSimple() throws MdsException {
        return this.nid.followReference().toNid();
    }

    public final void setAllOnUnchecked() {
        Node currNode = this;
        while (currNode.parent != null) {
            currNode = currNode.parent;
        }
        currNode.setOnUnchecked();
    }

    public final void setData(Descriptor<?> data) throws MdsException {
        this.timeinserted = null;
        this.nid.putRecord(data);
    }

    public final void setDefault() throws MdsException {
        this.nid.setDefault();
        this.treeview.updateDefault();
    }

    public final void setFlag(byte idx) throws MdsException {
        this.setFlags(1 << idx);
    }

    public final void setFlags(int flags) throws MdsException {
        this.flags = null;
        this.nid.setFlags(flags);
    }

    public final void setOnUnchecked() {
        this.needsOnCheck = true;
        this.flags = null;
        for (Node child : this.children) {
            child.setOnUnchecked();
        }
        for (Node member : this.members) {
            member.setOnUnchecked();
        }
    }

    public void setSubtree() throws MdsException {
        this.nid.setSubtree();
        this.label = null;
    }

    public final void setTags(String[] tags) throws MdsException {
        this.tags = null;
        this.nid.setTags(tags);
    }

    public final DefaultMutableTreeNode setTreeNode(DefaultMutableTreeNode treenode) {
        if (!this.is_leaf) {
            this.dummy = new DefaultMutableTreeNode(new JLabel("loading..."));
            treenode.add(this.dummy);
        }
        this.treenode = treenode;
        return this.treenode;
    }

    public final void setupDevice(boolean editable) {
        try {
            Device.showDialog((Frame)SwingUtilities.getRoot(this.treeview), this.nid, editable);
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this.treeview, e + "\n" + e.getMessage(), "Error opening device setup", 2);
        }
    }

    public final void toggle() throws MdsException {
        if (this.nid.isOn()) {
            this.turnOff();
        } else {
            this.turnOn();
        }
    }

    public final void toggleFlags(int mask) throws MdsException {
        int isflags = this.nid.getNciFlags();
        int clear = isflags & mask;
        int set = ~isflags & mask;
        this.flags = null;
        if (set != 0) {
            this.nid.setFlags(set);
        }
        if (clear != 0) {
            this.nid.clearFlags(clear);
        }
    }

    public final String toString() {
        return this.getName();
    }

    public final void turnOff() {
        try {
            this.nid.setOn(false);
        }
        catch (Exception exc) {
            MdsException.stderr((String)"Error turning off", (Exception)exc);
        }
        this.flags = null;
        this.setOnUnchecked();
        this.treeview.reportChange();
    }

    public final void turnOn() {
        try {
            this.nid.setOn(true);
        }
        catch (Exception exc) {
            MdsException.stderr((String)"Error turning on", (Exception)exc);
        }
        this.flags = null;
        this.setOnUnchecked();
        this.treeview.reportChange();
    }

    public final void update() {
        this.needsOnCheck = true;
        this.is_leaf = false;
        this.tooltip_life = 0L;
        this.status = -1;
        this.minpath_default = -1;
        this.ownerid = -1;
        this.rlength = -1;
        this.length = -1;
        this.num_segments = -1;
        this.timeinserted = null;
        this.fullpath = null;
        this.path = null;
        this.minpath = null;
        this.name = null;
        this.tooltip_text = null;
        this.dclass = (byte)-1;
        this.dtype = (byte)-1;
        this.usage = (byte)-1;
        this.flags = null;
    }

    static {
        ICONS = new ImageIcon[]{Node.loadIcon("mds/jtraverser/any.gif"), Node.loadIcon("mds/jtraverser/structure.gif"), Node.loadIcon("mds/jtraverser/action.gif"), Node.loadIcon("mds/jtraverser/device.gif"), Node.loadIcon("mds/jtraverser/dispatch.gif"), Node.loadIcon("mds/jtraverser/numeric.gif"), Node.loadIcon("mds/jtraverser/signal.gif"), Node.loadIcon("mds/jtraverser/task.gif"), Node.loadIcon("mds/jtraverser/text.gif"), Node.loadIcon("mds/jtraverser/window.gif"), Node.loadIcon("mds/jtraverser/axis.gif"), Node.loadIcon("mds/jtraverser/subtree.gif"), Node.loadIcon("mds/jtraverser/compound.gif")};
    }

    public static class TreeNodeLabel
    extends JLabel {
        private static final long serialVersionUID = 1L;
        static Font plain_f = new Font("Serif", 0, 12);
        static Font bold_f = new Font("Serif", 1, 12);
        final Color CExclude = new Color(128, 128, 128);
        final Color CInclude = new Color(0, 0, 0);
        final Color CMSetup = new Color(0, 0, 128);
        final Color CMSetupO = new Color(96, 0, 128);
        final Color CNorm = new Color(0, 0, 0);
        final Color CNormO = new Color(96, 0, 96);
        final Color CNoWrite = new Color(128, 0, 0);
        final Color CNoWriteO = new Color(192, 0, 0);
        final Color CSSetup = new Color(128, 0, 128);
        final Color CSSetupO = new Color(128, 0, 64);
        final Color CWrite = new Color(0, 128, 0);
        final Color CWriteO = new Color(96, 64, 0);
        final Node node;

        public TreeNodeLabel(Node node, String name, Icon icon, boolean isSelected) {
            super(node.isDefault() ? new StringBuilder(name.length() + 2).append('(').append(name).append(')').toString() : name, icon, 2);
            this.node = node;
            NODE.Flags flags = node.getFlags();
            byte lusage = node.getUsage();
            if (lusage == 11) {
                this.setForeground(flags.isIncludeInPulse() ? this.CInclude : this.CExclude);
            } else if (flags.isNoWriteModel() & flags.isNoWriteModel()) {
                this.setForeground(this.CNoWrite);
            } else if (flags.isNoWriteModel()) {
                this.setForeground(node.treeview.isModel() ? (flags.isWriteOnce() ? this.CNoWriteO : this.CNoWrite) : (flags.isWriteOnce() ? this.CWriteO : this.CWrite));
            } else if (flags.isNoWriteShot()) {
                this.setForeground(!node.treeview.isModel() ? (flags.isWriteOnce() ? this.CNoWriteO : this.CNoWrite) : (flags.isWriteOnce() ? this.CWriteO : this.CWrite));
            } else if (flags.isSetup()) {
                this.setForeground(node.treeview.isModel() ? (flags.isWriteOnce() ? this.CMSetupO : this.CMSetup) : (flags.isWriteOnce() ? this.CSSetupO : this.CSSetup));
            } else {
                this.setForeground(flags.isWriteOnce() ? this.CNormO : this.CNorm);
            }
            this.setFont(flags.isOn() && flags.isParentOn() ? bold_f : plain_f);
            this.setBorder(BorderFactory.createLineBorder(isSelected ? Color.black : Color.white, 1));
        }

        @Override
        public final String getToolTipText() {
            return this.node.getToolTipText();
        }
    }
}

