/*
 * Decompiled with CFR 0.152.
 */
package mds.jtraverser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Stack;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ToolTipManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import mds.Mds;
import mds.MdsException;
import mds.TCL;
import mds.data.CTX;
import mds.data.DTYPE;
import mds.data.TREE;
import mds.data.descriptor.Descriptor;
import mds.data.descriptor_s.NODE;
import mds.data.descriptor_s.Nid;
import mds.jtraverser.MdsView;
import mds.jtraverser.Node;
import mds.jtraverser.TreeView;
import mds.jtraverser.dialogs.ActionList;
import mds.jtraverser.dialogs.DataDialog;
import mds.jtraverser.dialogs.Dialogs;
import mds.jtraverser.dialogs.GraphPanel;
import mds.jtraverser.dialogs.OpenTreeDialog;
import mds.jtraverser.dialogs.SubTreeList;
import mds.jtraverser.dialogs.TagsDialog;
import mds.jtraverser.jTraverserFacade;
import mds.jtraverser.tools.DecompileTree;
import mds.mdsip.MdsIp;

public class TreeManager
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final JProgressBar progress = new JProgressBar();
    private final JLabel status = new JLabel();
    public final Dialogs dialogs;
    private final jTraverserFacade frame;
    private final OpenTreeDialog opentree_dialog;
    private final Stack<MdsView> mdsviews = new Stack();
    private final JTabbedPane tabs = new JTabbedPane();
    private final Vector<Thread> jobs = new Vector();
    private final JButton abort;

    public TreeManager(jTraverserFacade frame) {
        super(new BorderLayout());
        this.frame = frame;
        this.setPreferredSize(new Dimension(300, 400));
        this.opentree_dialog = new OpenTreeDialog(this);
        this.dialogs = new Dialogs(this);
        this.add((Component)this.tabs, "Center");
        JPanel jp = new JPanel(new BorderLayout());
        jp.add((Component)this.progress, "Center");
        this.abort = new JButton("abort");
        this.abort.setEnabled(!this.jobs.isEmpty());
        this.abort.setMargin(new Insets(0, 0, 0, 0));
        this.abort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TreeManager.this.abortJobs();
            }
        });
        jp.add((Component)this.abort, "After");
        this.add((Component)jp, "Last");
        this.tabs.setForeground(new Color(0, 0, 127));
        this.tabs.setTabLayoutPolicy(1);
        this.tabs.addChangeListener(new ChangeListener(){

            @Override
            public final void stateChanged(ChangeEvent ce) {
                TREE tree = TreeManager.this.getCurrentTree();
                if (tree == null) {
                    return;
                }
                try {
                    tree.setActive();
                }
                catch (MdsException mdsException) {
                    // empty catch block
                }
                TreeManager.this.reportChange();
            }
        });
        String version = TreeManager.class.getPackage().getImplementationVersion();
        if (version == null) {
            version = "unknown";
        }
        this.status.setText(new StringBuilder(64).append("jTaverser started (Version: ").append(version).append(")").toString());
        this.progress.setLayout(new BorderLayout(0, 0));
        this.progress.add((Component)this.status, "Center");
        MdsIp mdslocal = Mds.getLocal();
        if (mdslocal != null) {
            this.addMds(mdslocal.setActive());
        }
        MdsException.setStatusLabel((JLabel)this.status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortJobs() {
        Vector<Thread> vector = this.jobs;
        synchronized (vector) {
            for (Thread thread : this.jobs) {
                thread.interrupt();
            }
        }
    }

    public final MdsView addMds(Mds mds) {
        for (int i = 0; i < this.tabs.getTabCount(); ++i) {
            MdsView mdsview = (MdsView)this.tabs.getComponentAt(i);
            if (!mdsview.getMds().equals(mds)) continue;
            this.tabs.setSelectedComponent(mdsview);
            return mdsview;
        }
        MdsView mdsview = new MdsView(this, mds);
        mdsview.addChangeReportListener(new Job(){

            @Override
            public void program() {
                TreeManager.this.reportChange();
            }
        });
        this.tabs.addTab(mdsview.toString(), mdsview);
        this.tabs.setSelectedIndex(this.tabs.getTabCount() - 1);
        return mdsview;
    }

    public final void closeMds() {
        MdsView mdsview = this.getCurrentMdsView();
        if (mdsview == null) {
            return;
        }
        this.closeMds(this.tabs.getSelectedIndex());
    }

    public final void closeMds(int idx) {
        if (idx >= this.tabs.getTabCount() || idx < 0) {
            return;
        }
        this.mdsviews.remove(this.getMdsViewAt(idx).close(false));
        this.tabs.removeTabAt(idx);
        if (this.tabs.getTabCount() == 0) {
            this.frame.reportChange(null);
        }
    }

    public final void closeTree() {
        MdsView mdsview = this.getCurrentMdsView();
        if (mdsview == null) {
            return;
        }
        mdsview.closeTree(false);
    }

    public void dispatchJob(final Job job) {
        new Thread(){

            @Override
            public void run() {
                TreeManager.this.jobs.addElement(this);
                TreeManager.this.abort.setEnabled(true);
                try {
                    job.program();
                    TreeManager.this.jobs.remove(this);
                }
                catch (Throwable throwable) {
                    TreeManager.this.jobs.remove(this);
                    TreeManager.this.abort.setEnabled(!TreeManager.this.jobs.isEmpty());
                    throw throwable;
                }
                TreeManager.this.abort.setEnabled(!TreeManager.this.jobs.isEmpty());
            }
        }.start();
    }

    public final MouseListener getContextMenu() {
        return new ContextMenuML();
    }

    public final MdsView getCurrentMdsView() {
        if (this.tabs.getTabCount() == 0) {
            return null;
        }
        return (MdsView)this.tabs.getSelectedComponent();
    }

    public final Node getCurrentNode() {
        MdsView mdsview = this.getCurrentMdsView();
        if (mdsview == null) {
            return null;
        }
        return mdsview.getCurrentNode();
    }

    public final TREE getCurrentTree() {
        MdsView mdsview = this.getCurrentMdsView();
        if (mdsview == null) {
            return null;
        }
        return mdsview.getCurrentTree();
    }

    public TreeView getCurrentTreeView() {
        MdsView mdsview = this.getCurrentMdsView();
        if (mdsview == null) {
            return null;
        }
        return mdsview.getCurrentTreeView();
    }

    public final Mds getMds() {
        MdsView mdsview = this.getCurrentMdsView();
        if (mdsview == null) {
            return null;
        }
        return mdsview.getMds();
    }

    private final MdsView getMdsViewAt(int index) {
        return (MdsView)this.tabs.getComponentAt(index);
    }

    public final MdsView openMds(MdsIp.Provider provider) {
        FileMenu.prev_provider = provider.toString();
        MdsIp mds = MdsIp.sharedConnection((MdsIp.Provider)provider);
        if (mds.isReady() != null) {
            JOptionPane.showMessageDialog(this.frame, "Could not connect to server " + provider.toString(), "Connection Error", 0);
            return null;
        }
        return this.addMds((Mds)mds);
    }

    public final void openTree(String expt, int shot, TREE.MODE mode) {
        this.opentree_dialog.setFields(expt, shot);
        MdsView mdsview = this.getCurrentMdsView();
        if (mdsview == null) {
            return;
        }
        mdsview.openTree(expt, shot, mode);
    }

    public final void quit() {
        while (!this.mdsviews.empty()) {
            this.mdsviews.pop().close(true);
        }
        System.exit(0);
    }

    public final void rename() {
        Node currnode = this.getCurrentNode();
        if (currnode == null) {
            return;
        }
        JTextField new_name = new JTextField();
        Object[] ob = new Object[]{"Enter new name:", new_name};
        int result = JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), ob, "Rename: " + currnode, 2);
        if (result != 0) {
            return;
        }
        String name = new_name.getText();
        if (name == null || name.length() == 0) {
            return;
        }
        try {
            currnode.rename(name);
        }
        catch (Exception exc) {
            JOptionPane.showMessageDialog(this.frame, exc.getMessage(), "Error renaming Node", 2);
            return;
        }
        this.reportChange();
    }

    public final synchronized void reportChange() {
        this.dialogs.update();
        this.frame.reportChange(this.getCurrentMdsView());
        this.frame.repaint();
    }

    public void set_copy_format(int format) {
        for (MdsView view : this.mdsviews) {
            view.set_copy_format(format);
        }
    }

    public final void setProgress(MdsView mdsView, int value, int max) {
        if (!mdsView.equals(this.getCurrentMdsView())) {
            return;
        }
        this.progress.setValue(value);
        this.progress.setMaximum(max);
    }

    public final void setTreePathEnv(String exp, String path) {
        Mds mds;
        if (exp == null || path == null || exp.length() == 0 || path.length() == 0 || (mds = this.getMds()) == null) {
            return;
        }
        try {
            mds.getAPI().setenv(new StringBuilder(16).append(exp.toLowerCase()).append("_path").toString(), path);
        }
        catch (MdsException e) {
            JOptionPane.showMessageDialog(this, "Could not set environment variable.\n" + e.getMessage(), "Error setting tree_path", 2);
        }
    }

    public final void writeTree() {
        this.getCurrentTreeView().writeTree();
    }

    static {
        ToolTipManager.sharedInstance().setDismissDelay(60000);
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(true);
    }

    public static final class ModifyMenu
    extends Menu {
        public ModifyMenu(TreeManager treeman, JComponent menu, int column) {
            super(treeman, menu, column);
            this.addMenuItem("Modify Data", (ActionListener)new Menu.DataPanelAL(true));
            this.addMenuItem("Modify Flags", (ActionListener)new ModifyFlags());
            this.addSeparator();
            this.addMenuItem("Turn On", (ActionListener)new TurnOnOff(true));
            this.addMenuItem("Turn Off", (ActionListener)new TurnOnOff(false));
            this.addSeparator();
            this.addMenuItem("Setup Device", (ActionListener)new SetupDevice());
            this.addMenuItem("Do Action", (ActionListener)new DoAction());
        }

        @Override
        public final void checkSupport() {
            Node node = this.treeman.getCurrentNode();
            boolean[] mask = new boolean[this.items.size()];
            if (node != null) {
                byte usage = node.getUsage();
                boolean isst = usage == 1 || usage == 11;
                boolean isact = usage == 2 || usage == 7;
                boolean isdev = usage == 3;
                mask = new boolean[]{!isst, true, true, true, isdev, isact};
            }
            for (int i = 0; i < mask.length; ++i) {
                ((JMenuItem)this.items.get(i)).setEnabled(mask[i]);
            }
        }

        private final class TurnOnOff
        implements ActionListener {
            private final boolean on;

            public TurnOnOff(boolean on) {
                this.on = on;
            }

            @Override
            public final void actionPerformed(ActionEvent e) {
                Node currnode = ModifyMenu.this.treeman.getCurrentNode();
                if (currnode == null) {
                    return;
                }
                if (this.on) {
                    currnode.turnOn();
                } else {
                    currnode.turnOff();
                }
                ModifyMenu.this.treeman.reportChange();
            }
        }

        public final class SetupDevice
        implements ActionListener {
            @Override
            public final void actionPerformed(ActionEvent e) {
                ModifyMenu.this.treeman.dispatchJob(new Job(){

                    @Override
                    public final void program() {
                        try {
                            Node currnode = ModifyMenu.this.treeman.getCurrentNode();
                            if (currnode == null) {
                                return;
                            }
                            currnode.setupDevice(true);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                });
            }
        }

        public final class ModifyFlags
        implements ActionListener {
            @Override
            public final void actionPerformed(ActionEvent e) {
                ModifyMenu.this.treeman.dialogs.modifyFlags.open();
            }
        }

        public final class DoAction
        implements ActionListener {
            @Override
            public final void actionPerformed(ActionEvent ae) {
                final Node currnode = ModifyMenu.this.treeman.getCurrentNode();
                if (currnode == null) {
                    return;
                }
                ModifyMenu.this.treeman.dispatchJob(new Job(){

                    @Override
                    public final void program() {
                        try {
                            currnode.doAction();
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                });
            }
        }
    }

    public static class Menu {
        protected final ArrayList<JMenuItem> items = new ArrayList();
        protected final TreeManager treeman;
        protected final GridBagConstraints gbc;
        protected final JComponent menu;

        public Menu(TreeManager treeman, JComponent menu) {
            this(treeman, menu, -1);
        }

        public Menu(TreeManager treeman, JComponent menu, int column) {
            this.treeman = treeman;
            this.menu = menu;
            if (column < 0) {
                this.gbc = null;
            } else {
                this.gbc = new GridBagConstraints();
                this.gbc.gridx = column;
            }
        }

        protected final JMenuItem addMenuItem(JMenuItem item, ActionListener l) {
            this.items.add(item);
            item.addActionListener(l);
            if (this.gbc == null) {
                this.menu.add(item);
            } else {
                this.menu.add((Component)item, this.gbc);
            }
            return item;
        }

        protected final JMenuItem addMenuItem(String name, ActionListener l) {
            return this.addMenuItem(new JMenuItem(name), l);
        }

        protected void addSeparator() {
            if (this.gbc == null) {
                this.menu.add(new JSeparator());
            }
        }

        public void checkSupport() {
        }

        protected final class DataPanelAL
        implements ActionListener {
            private final boolean editable;

            public DataPanelAL(boolean editable) {
                this.editable = editable;
            }

            @Override
            public final void actionPerformed(ActionEvent e) {
                final Node currnode = Menu.this.treeman.getCurrentNode();
                if (currnode == null) {
                    return;
                }
                Menu.this.treeman.dispatchJob(new Job(){

                    @Override
                    public final void program() {
                        try {
                            DataDialog.open(currnode.nid, DataPanelAL.this.editable);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                });
            }
        }
    }

    public static interface Job {
        public void program();
    }

    public static final class FileMenu
    extends Menu {
        private static String prev_provider = "";

        public FileMenu(TreeManager treeman, JComponent menu, int column) {
            super(treeman, menu, column);
            this.addMenuItem("Connect", (ActionListener)new OpenMds());
            this.addMenuItem("Open", (ActionListener)new OpenTree());
            this.addMenuItem("Write", (ActionListener)new Write());
            this.addMenuItem("Close", (ActionListener)new CloseTree());
            this.addMenuItem("Disconnect", (ActionListener)new CloseMds());
            this.addSeparator();
            this.addMenuItem("Export", (ActionListener)new Decompile());
            this.addSeparator();
            this.addMenuItem("Reset", (ActionListener)new ResetTree());
            this.addMenuItem("Quit", (ActionListener)new Quit());
        }

        @Override
        public final void checkSupport() {
            boolean noconnected = this.treeman.getCurrentMdsView() == null;
            boolean nodisconnect = noconnected || this.treeman.getMds().isLocal();
            boolean noopen = noconnected || this.treeman.getCurrentTree() == null;
            int i = 1;
            ((JMenuItem)this.items.get(i++)).setEnabled(!noconnected);
            ((JMenuItem)this.items.get(i++)).setEnabled(noopen ? false : this.treeman.getCurrentTree().is_editable());
            ((JMenuItem)this.items.get(i++)).setEnabled(!noopen);
            ((JMenuItem)this.items.get(i++)).setEnabled(!nodisconnect);
            ((JMenuItem)this.items.get(i++)).setEnabled(!noopen);
            ((JMenuItem)this.items.get(i++)).setEnabled(!noopen);
        }

        private final class Write
        implements ActionListener {
            private Write() {
            }

            @Override
            public final void actionPerformed(ActionEvent e) {
                FileMenu.this.treeman.writeTree();
            }
        }

        private final class ResetTree
        implements ActionListener {
            private ResetTree() {
            }

            @Override
            public final void actionPerformed(ActionEvent e) {
                FileMenu.this.treeman.getCurrentTreeView().reset();
            }
        }

        private final class Quit
        implements ActionListener {
            private Quit() {
            }

            @Override
            public final void actionPerformed(ActionEvent e) {
                FileMenu.this.treeman.quit();
            }
        }

        private final class OpenTree
        implements ActionListener {
            private OpenTree() {
            }

            @Override
            public final void actionPerformed(ActionEvent e) {
                FileMenu.this.treeman.opentree_dialog.open();
            }
        }

        private final class OpenMds
        implements ActionListener {
            private OpenMds() {
            }

            @Override
            public final void actionPerformed(ActionEvent e) {
                final JTextField provider = new JTextField(prev_provider, 20);
                provider.addAncestorListener(new AncestorListener(){

                    @Override
                    public void ancestorAdded(AncestorEvent ae) {
                        ((JTextField)ae.getSource()).grabFocus();
                    }

                    @Override
                    public void ancestorMoved(AncestorEvent ae) {
                    }

                    @Override
                    public void ancestorRemoved(AncestorEvent ae) {
                    }
                });
                Object[] ob = new Object[]{"[ssh://][<user>@]<hostname>[:<port>]", provider};
                int result = JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), ob, "Open new connection", 2, -1);
                if (result == 0) {
                    new Thread(null, new Runnable(){

                        @Override
                        public void run() {
                            FileMenu.this.treeman.openMds(new MdsIp.Provider(provider.getText()));
                        }
                    }, provider.getText()).start();
                }
            }
        }

        private final class Decompile
        implements ActionListener {
            private Decompile() {
            }

            @Override
            public final void actionPerformed(ActionEvent e) {
                new DecompileTree().decompile(FileMenu.this.treeman.getCurrentTree(), FileMenu.this.treeman.frame, true);
            }
        }

        private final class CloseTree
        implements ActionListener {
            private CloseTree() {
            }

            @Override
            public final void actionPerformed(ActionEvent e) {
                FileMenu.this.treeman.closeTree();
            }
        }

        private final class CloseMds
        implements ActionListener {
            private CloseMds() {
            }

            @Override
            public final void actionPerformed(ActionEvent e) {
                FileMenu.this.treeman.closeMds();
            }
        }
    }

    public static final class ExtrasMenu
    extends Menu {
        public ExtrasMenu(TreeManager treeman, JComponent menu) {
            super(treeman, menu);
            this.addMenuItem(new JCheckBoxMenuItem("Always on top"), (ActionListener)new AlwaysOnTop());
            menu.add(new CopyFormat());
            this.addSeparator();
            this.addMenuItem("Show DataBase", (ActionListener)new ShowDatabase());
            this.addMenuItem("MdsTCL", (ActionListener)new OpenTCL());
            this.addSeparator();
            this.addMenuItem("List Actions", (ActionListener)new ShowActionList());
            this.addMenuItem("List Subtrees", (ActionListener)new ShowSubTreeList());
            this.addMenuItem("List Tags", (ActionListener)new ShowTags());
        }

        @Override
        public final void checkSupport() {
            boolean open = this.treeman.getCurrentTree() != null;
            ((JMenuItem)this.items.get(0)).setEnabled(this.treeman.frame.isAlwaysOnTopSupported());
            ((JCheckBoxMenuItem)this.items.get(0)).setSelected(this.treeman.frame.isAlwaysOnTop());
            ((JMenuItem)this.items.get(1)).setEnabled(this.treeman.getCurrentMdsView() != null);
            for (JMenuItem item : this.items.subList(3, this.items.size())) {
                item.setEnabled(open);
            }
        }

        public final class ShowTags
        implements ActionListener {
            @Override
            public final void actionPerformed(ActionEvent e) {
                final DefaultTableModel tabmodel = new DefaultTableModel(0, 2);
                JTable table = new JTable(tabmodel);
                table.setPreferredScrollableViewportSize(new Dimension(600, 500));
                table.getColumnModel().getColumn(0).setHeaderValue("Tag");
                table.getColumnModel().getColumn(1).setHeaderValue("Full Path");
                table.getColumnModel().getColumn(0).setPreferredWidth(100);
                table.getColumnModel().getColumn(1).setPreferredWidth(300);
                JScrollPane scollpane = new JScrollPane(table);
                scollpane.setHorizontalScrollBarPolicy(31);
                scollpane.setVerticalScrollBarPolicy(22);
                Thread thread = new Thread("ShowTags"){
                    {
                        super(x0);
                        this.setDaemon(true);
                        this.setPriority(1);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public final void run() {
                        TreeView treeview = ExtrasMenu.this.treeman.getCurrentTreeView();
                        TREE tree = treeview.getTree();
                        try {
                            for (Object[] objectArray : tree.findTagsPath()) {
                                tabmodel.addRow(objectArray);
                                1 var7_8 = this;
                                synchronized (var7_8) {
                                    if (this.isInterrupted()) {
                                        return;
                                    }
                                }
                            }
                        }
                        catch (MdsException mdsException) {
                            // empty catch block
                        }
                    }
                };
                thread.start();
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), scollpane, ExtrasMenu.this.treeman.getCurrentTree().toString(), -1);
                if (thread.isAlive()) {
                    thread.interrupt();
                }
            }
        }

        public final class ShowSubTreeList
        implements ActionListener {
            @Override
            public final void actionPerformed(ActionEvent e) {
                new SubTreeList(ExtrasMenu.this.treeman).open();
            }
        }

        public final class ShowDatabase
        implements ActionListener {
            @Override
            public final void actionPerformed(ActionEvent e) {
                Mds mds = ExtrasMenu.this.treeman.getMds();
                TCL tcl = mds.getTCL();
                String msg = tcl.showDatabase();
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), msg, mds.toString(), -1);
            }
        }

        public final class ShowActionList
        implements ActionListener {
            @Override
            public final void actionPerformed(ActionEvent e) {
                new ActionList(ExtrasMenu.this.treeman).open();
            }
        }

        public final class OpenTCL
        implements ActionListener {
            @Override
            public final void actionPerformed(ActionEvent e) {
                JFrame f = TCL.getPrompt((Mds)ExtrasMenu.this.treeman.getMds());
                f.setLocation(ExtrasMenu.this.treeman.getLocationOnScreen());
                f.setVisible(true);
            }
        }

        public final class CopyFormat
        extends JMenu
        implements ActionListener {
            private static final long serialVersionUID = 1L;
            public static final int FULLPATH = 0;
            public static final int PATH = 1;
            public static final int MINPATH = 2;
            public static final int NODENAME = 3;
            final JRadioButtonMenuItem fullpath;
            final JRadioButtonMenuItem path;
            final JRadioButtonMenuItem minpath;
            final JRadioButtonMenuItem nodename;

            public CopyFormat() {
                super("Copy Format");
                ButtonGroup group = new ButtonGroup();
                this.fullpath = new JRadioButtonMenuItem("FullPath");
                group.add(this.add(this.fullpath));
                this.path = new JRadioButtonMenuItem("Path");
                group.add(this.add(this.path));
                this.minpath = new JRadioButtonMenuItem("MinPath");
                group.add(this.add(this.minpath));
                this.nodename = new JRadioButtonMenuItem("NodeName");
                group.add(this.add(this.nodename));
                this.fullpath.setSelected(true);
                this.fullpath.addActionListener(this);
                this.path.addActionListener(this);
                this.minpath.addActionListener(this);
                this.nodename.addActionListener(this);
            }

            @Override
            public final void actionPerformed(ActionEvent e) {
                if (e.getSource().equals(this.fullpath)) {
                    ExtrasMenu.this.treeman.set_copy_format(0);
                } else if (e.getSource().equals(this.path)) {
                    ExtrasMenu.this.treeman.set_copy_format(1);
                } else if (e.getSource().equals(this.minpath)) {
                    ExtrasMenu.this.treeman.set_copy_format(2);
                } else if (e.getSource().equals(this.nodename)) {
                    ExtrasMenu.this.treeman.set_copy_format(3);
                }
            }
        }

        public final class AlwaysOnTop
        implements ActionListener {
            @Override
            public final void actionPerformed(ActionEvent e) {
                ExtrasMenu.this.treeman.frame.setAlwaysOnTop(!ExtrasMenu.this.treeman.frame.isAlwaysOnTop());
            }
        }
    }

    public static final class EditMenu
    extends Menu {
        public EditMenu(TreeManager treeman, JComponent menu, int column) {
            super(treeman, menu, column);
            JMenu submenu = new JMenu("Add Node...");
            this.items.add(submenu);
            if (this.gbc == null) {
                menu.add(submenu);
            } else {
                menu.add((Component)submenu, this.gbc);
            }
            AddNodeMenu unused = new AddNodeMenu(treeman, submenu);
            this.addMenuItem("Delete Node", (ActionListener)new DeleteNode());
            this.addMenuItem("Rename Node", (ActionListener)new RenameNode());
            this.addMenuItem("Edit Tags", (ActionListener)new EditTags());
            this.addSeparator();
            this.addMenuItem("Copy", (ActionListener)new CopyNode());
            this.addMenuItem("Paste", (ActionListener)new PasteNode());
        }

        @Override
        public final void checkSupport() {
            Node node = this.treeman.getCurrentNode();
            boolean[] mask = new boolean[this.items.size()];
            if (node != null) {
                byte usage = node.getUsage();
                boolean isst = usage == 11;
                mask = new boolean[]{!isst || node.nid.getNidNumber() == 0, node.nid.getNidNumber() != 0, !isst, !isst, node.nid.getNidNumber() > 0, Node.isCopied()};
            }
            for (int i = 0; i < mask.length; ++i) {
                ((JMenuItem)this.items.get(i)).setEnabled(mask[i]);
            }
        }

        public final class RenameNode
        implements ActionListener {
            @Override
            public final void actionPerformed(ActionEvent e) {
                EditMenu.this.treeman.rename();
            }
        }

        public final class PasteNode
        implements ActionListener {
            @Override
            public final void actionPerformed(ActionEvent e) {
                EditMenu.this.treeman.getCurrentNode().paste();
            }
        }

        public final class EditTags
        implements ActionListener {
            @Override
            public final void actionPerformed(ActionEvent e) {
                Node currnode = EditMenu.this.treeman.getCurrentNode();
                if (currnode == null) {
                    return;
                }
                TagsDialog.open(currnode);
            }
        }

        private final class DeleteNode
        implements ActionListener {
            private DeleteNode() {
            }

            @Override
            public final void actionPerformed(ActionEvent e) {
                EditMenu.this.treeman.getCurrentTreeView().deleteNode();
            }
        }

        private final class CopyNode
        implements ActionListener {
            private CopyNode() {
            }

            @Override
            public final void actionPerformed(ActionEvent e) {
                EditMenu.this.treeman.getCurrentNode().copy();
            }
        }
    }

    public static final class DisplayMenu
    extends Menu {
        private final DisplayDataMenu displaydatamenu;

        static String escapeHTML(String s) {
            StringBuilder out = new StringBuilder(Math.max(16, s.length()));
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (c > '\u007f' || c == '\"' || c == '<' || c == '>' || c == '&') {
                    out.append("&#");
                    out.append((int)c);
                    out.append(';');
                    continue;
                }
                out.append(c);
            }
            return out.toString();
        }

        public DisplayMenu(TreeManager treeman, JComponent menu, int column) {
            super(treeman, menu, column);
            this.addMenuItem("Follow Ref", (ActionListener)new FollowRef());
            this.addMenuItem("Display Data", (ActionListener)new Menu.DataPanelAL(false));
            this.displaydatamenu = new DisplayDataMenu(treeman);
            this.addMenuItem(this.displaydatamenu.getMenu(), null);
            this.addMenuItem("Device Setup", (ActionListener)new DeviceSetup());
            this.addSeparator();
            this.addMenuItem("Display Nci", (ActionListener)new DisplayNci());
            this.addMenuItem("Display Flags", (ActionListener)new ModifyFlags());
            this.addMenuItem("Display Tags", (ActionListener)new DisplayTags());
            this.addSeparator();
            this.addMenuItem("Set Default", (ActionListener)new SetDefault());
        }

        @Override
        public final void checkSupport() {
            this.displaydatamenu.checkSupport();
            Node node = this.treeman.getCurrentNode();
            if (node == null) {
                return;
            }
            DTYPE dtype = node.getDType();
            ((JMenuItem)this.items.get(0)).setVisible(DTYPE.NID.equals((Object)dtype) || DTYPE.PATH.equals((Object)dtype));
            byte usage = node.getUsage();
            boolean enable = usage != 1 && usage != 11;
            boolean device = usage == 3;
            boolean[] mask = new boolean[]{enable, enable, enable, device, true, true, true, true};
            for (int i = 0; i < mask.length; ++i) {
                ((JMenuItem)this.items.get(i)).setEnabled(mask[i]);
            }
        }

        public final class SetDefault
        implements ActionListener {
            @Override
            public final void actionPerformed(ActionEvent e) {
                Node currnode = DisplayMenu.this.treeman.getCurrentNode();
                if (currnode == null) {
                    return;
                }
                try {
                    currnode.setDefault();
                }
                catch (MdsException exc) {
                    MdsException.stderr((String)"SetDefault", (Exception)((Object)exc));
                }
            }
        }

        public final class ModifyFlags
        implements ActionListener {
            @Override
            public final void actionPerformed(ActionEvent e) {
                DisplayMenu.this.treeman.dialogs.modifyFlags.open();
            }
        }

        public final class FollowRef
        implements ActionListener {
            @Override
            public final void actionPerformed(ActionEvent e) {
                Thread thread = new Thread("FollowRef"){
                    {
                        this.setDaemon(true);
                    }

                    @Override
                    public final void run() {
                        Node currnode = DisplayMenu.this.treeman.getCurrentNode();
                        int row = 0;
                        try {
                            NODE link = (NODE)currnode.getRecord();
                            row = currnode.treeview.expandPath(link);
                        }
                        catch (MdsException exc) {
                            return;
                        }
                        catch (Exception exc) {
                            currnode.treeview.scrollRowToVisible(row);
                            currnode.treeview.setSelectionRow(row);
                        }
                    }
                };
                thread.start();
            }
        }

        public final class DisplayTags
        implements ActionListener {
            @Override
            public final void actionPerformed(ActionEvent e) {
                Node currnode = DisplayMenu.this.treeman.getCurrentNode();
                if (currnode == null) {
                    return;
                }
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), currnode.getTagTextBox(), "Display Node Tags", -1);
            }
        }

        public final class DisplaySignal
        implements ActionListener {
            @Override
            public final void actionPerformed(ActionEvent ae) {
                Node currnode = DisplayMenu.this.treeman.getCurrentNode();
                if (currnode == null) {
                    return;
                }
                Nid node = currnode.nid;
                String fullpath = currnode.getFullPath();
                DisplayMenu.this.treeman.dispatchJob(new Job((NODE)node, fullpath){
                    final /* synthetic */ NODE val$node;
                    final /* synthetic */ String val$fullpath;
                    {
                        this.val$node = nODE;
                        this.val$fullpath = string;
                    }

                    @Override
                    public final void program() {
                        try {
                            GraphPanel.plotNode(this.val$node, JOptionPane.getRootFrame(), this.val$fullpath);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        }

        public final class DisplayNci
        implements ActionListener {
            @Override
            public final void actionPerformed(ActionEvent e) {
                Node currnode = DisplayMenu.this.treeman.getCurrentNode();
                if (currnode == null) {
                    return;
                }
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), currnode.getInfoTextBox(), "Display NCI information", -1);
            }
        }

        public final class DisplayDataMenu
        extends Menu {
            public DisplayDataMenu(TreeManager treeman) {
                super(treeman, new JMenu("Display Data..."));
                this.addMenuItem("Plot Signal", (ActionListener)new DisplaySignal());
                this.addMenuItem("DATA($)", (ActionListener)new EvalActionListener("DATA($)"));
                this.addMenuItem("RAW_OF($)", (ActionListener)new EvalActionListener("RAW_OF($)"));
                this.addMenuItem("DIM_OF($)", (ActionListener)new EvalActionListener("DIM_OF($)"));
                this.addMenuItem("SHAPE($)", (ActionListener)new EvalActionListener("SHAPE($)"));
            }

            @Override
            public final void checkSupport() {
                Node node = this.treeman.getCurrentNode();
                boolean[] mask = new boolean[this.items.size()];
                if (node != null) {
                    byte usage = node.getUsage();
                    boolean enable = usage != 1 && usage != 11;
                    mask = new boolean[]{enable, enable, enable, enable, enable};
                }
                for (int i = 0; i < mask.length; ++i) {
                    ((JMenuItem)this.items.get(i)).setEnabled(mask[i]);
                }
            }

            public JMenuItem getMenu() {
                return (JMenuItem)this.menu;
            }

            private class EvalActionListener
            implements ActionListener {
                private final String evalexpr;

                EvalActionListener(String evalexpr) {
                    this.evalexpr = evalexpr;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    String aedata;
                    Node currnode = DisplayMenu.this.treeman.getCurrentNode();
                    if (currnode == null) {
                        return;
                    }
                    try {
                        NODE datanode = currnode.nid.followReference();
                        TREE tree = DisplayDataMenu.this.treeman.getCurrentTree();
                        aedata = tree.getMds().getAPI().tdiDecompile((CTX)tree, this.evalexpr, new Descriptor[]{datanode});
                        if (aedata == null) {
                            aedata = "no data";
                        }
                    }
                    catch (MdsException de) {
                        aedata = de.getMessage();
                    }
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(aedata), null);
                    JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "<html><body><p style='width: 360px;'>" + DisplayMenu.escapeHTML(aedata) + "</p></body></html>", this.evalexpr.replace("$", currnode.getFullPath()), -1);
                }
            }
        }

        public final class DeviceSetup
        implements ActionListener {
            @Override
            public final void actionPerformed(ActionEvent e) {
                DisplayMenu.this.treeman.dispatchJob(new Job(){

                    @Override
                    public final void program() {
                        try {
                            Node currnode = DisplayMenu.this.treeman.getCurrentNode();
                            if (currnode == null) {
                                return;
                            }
                            currnode.setupDevice(false);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                });
            }
        }
    }

    public final class ContextMenuML
    extends MouseAdapter {
        private static final int CtrlClick = 1152;

        @Override
        public final void mouseClicked(MouseEvent ev) {
            if (ev.isPopupTrigger()) {
                TreeView tree = (TreeView)ev.getSource();
                DefaultMutableTreeNode tree_node = (DefaultMutableTreeNode)tree.getClosestPathForLocation(ev.getX(), ev.getY()).getLastPathComponent();
                Node currnode = Node.getNode(tree_node);
                tree.setCurrentNode(currnode);
                JPopupMenu pop = new JPopupMenu();
                pop.setLayout(new GridBagLayout());
                new DisplayMenu(TreeManager.this, pop, 0).checkSupport();
                if (!tree.isReadOnly()) {
                    new ModifyMenu(TreeManager.this, pop, 1).checkSupport();
                }
                if (tree.isEditable()) {
                    new EditMenu(TreeManager.this, pop, 2).checkSupport();
                }
                pop.show((Component)ev.getSource(), ev.getX(), ev.getY());
            } else if ((ev.getModifiers() & 0x10) == 16 && (ev.getModifiersEx() & 0x480) == 1152) {
                TreeView tree = (TreeView)ev.getSource();
                DefaultMutableTreeNode tree_node = (DefaultMutableTreeNode)tree.getClosestPathForLocation(ev.getX(), ev.getY()).getLastPathComponent();
                Node currnode = Node.getNode(tree_node);
                tree.setCurrentNode(currnode);
                if (currnode.isSubTree()) {
                    try {
                        currnode.toggleFlags(32768);
                    }
                    catch (MdsException e) {
                        MdsException.stderr((String)"INCLUDE_IN_PULSE", (Exception)((Object)e));
                    }
                } else {
                    try {
                        currnode.toggle();
                    }
                    catch (MdsException e) {
                        MdsException.stderr((String)"TOGGLE STATE", (Exception)((Object)e));
                    }
                }
                tree.treeDidChange();
                TreeManager.this.dialogs.update();
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.mouseClicked(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.mouseClicked(e);
        }
    }

    public static final class AddNodeMenu
    extends Menu {
        private final String[] name = new String[]{"Structure", "Subtree", "Action", "Any", "Axis", "Dispatch", "Numeric", "Signal", "Task", "Text", "Window"};
        private final byte[] usage = new byte[]{1, 11, 2, 0, 10, 4, 5, 6, 7, 8, 9};

        public AddNodeMenu(TreeManager treeman, JComponent menu) {
            super(treeman, menu);
            this.addMenuItem("Device", (ActionListener)new AddDevice());
            this.addSeparator();
            for (int i = 0; i < this.name.length; ++i) {
                this.addMenuItem(this.name[i], (ActionListener)new AddNodeAL(this.usage[i]));
                if (i != 1) continue;
                this.addSeparator();
            }
        }

        public final class AddNodeAL
        implements ActionListener {
            private final byte lusage;

            public AddNodeAL(byte usage_in) {
                this.lusage = usage_in;
            }

            @Override
            public final void actionPerformed(ActionEvent e) {
                AddNodeMenu.this.treeman.dialogs.addNode.open(AddNodeMenu.this.treeman.getCurrentNode(), this.lusage);
            }
        }

        private final class AddDevice
        implements ActionListener {
            private AddDevice() {
            }

            @Override
            public final void actionPerformed(ActionEvent e) {
                Node currnode = AddNodeMenu.this.treeman.getCurrentNode();
                if (currnode == null) {
                    return;
                }
                JTextField device_type = new JTextField(12);
                JTextField device_name = new JTextField(12);
                Object[] content = new Object[]{"Device:", device_type, "Name:", device_name};
                String title = new StringBuilder(256).append("Add device to: ").append(currnode.getFullPath()).toString();
                int result = JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), content, title, 2, -1);
                if (result == 0) {
                    try {
                        currnode.addDevice(device_name.getText().toUpperCase(), device_type.getText());
                    }
                    catch (MdsException me) {
                        MdsException.stderr((String)"AddDevice", (Exception)((Object)me));
                    }
                }
            }
        }
    }
}

