/*
 * Decompiled with CFR 0.152.
 */
package mds.jtraverser.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import mds.MdsException;
import mds.data.CTX;
import mds.data.TREE;
import mds.data.descriptor.Descriptor;
import mds.data.descriptor_s.NODE;
import mds.jtraverser.dialogs.Dialogs;
import mds.jtraverser.editor.Editor;
import mds.jtraverser.editor.SegmentEditor;
import mds.jtraverser.editor.usage.ActionEditor;
import mds.jtraverser.editor.usage.AnyEditor;
import mds.jtraverser.editor.usage.AxisEditor;
import mds.jtraverser.editor.usage.DispatchEditor;
import mds.jtraverser.editor.usage.NumericEditor;
import mds.jtraverser.editor.usage.SignalEditor;
import mds.jtraverser.editor.usage.TaskEditor;
import mds.jtraverser.editor.usage.TextEditor;
import mds.jtraverser.editor.usage.WindowEditor;

public class DataDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private Vector<UpdateListener> listener = null;
    private final NODE<?> node;
    private final Editor edit;
    private final boolean editable;
    private final JButton ok_b;
    private final JButton apply_b;
    private final JButton reset_b;
    private final JButton cancel_b;
    private final JLabel onoff;
    private final JLabel tags;

    public static final DataDialog open(NODE<?> node, boolean editable) throws MdsException {
        DataDialog dialog = new DataDialog(node, editable);
        Dialogs.setLocation(dialog);
        dialog.setVisible(true);
        return dialog;
    }

    private static final String tagList(String[] tags) {
        if (tags == null || tags.length == 0) {
            return "<no tags>";
        }
        return String.join((CharSequence)", ", tags);
    }

    private DataDialog(NODE<?> node, boolean editable) throws MdsException {
        super(JOptionPane.getRootFrame());
        this.node = node;
        this.editable = editable;
        this.setLayout(new BorderLayout());
        JPanel ip = new JPanel();
        this.onoff = new JLabel("");
        ip.add(this.onoff);
        ip.add(new JLabel("Tags: "));
        this.tags = new JLabel("");
        ip.add(this.tags);
        this.add((Component)ip, "First");
        TREE.RecordInfo ri = node.getRecordInfoC();
        if (ri.num_segments > 0) {
            this.edit = new SegmentEditor(node, this.editable, this);
        } else {
            Descriptor data = null;
            try {
                data = this.node.getRecord();
            }
            catch (MdsException e) {
                MdsException.stderr((String)"DataDialog.getData", (Exception)((Object)e));
                e.printStackTrace();
            }
            TREE ctx = node.getTree();
            switch (node.getNciUsage()) {
                case 6: {
                    this.edit = new SignalEditor(data, this.editable, (CTX)ctx, this);
                    break;
                }
                case 2: {
                    this.edit = new ActionEditor(data, this.editable, (CTX)ctx, (Window)this, ri.status, node.getTree().shot == -1);
                    break;
                }
                case 4: {
                    this.edit = new DispatchEditor(data, this.editable, (CTX)ctx, this);
                    break;
                }
                case 7: {
                    this.edit = new TaskEditor(data, this.editable, (CTX)ctx, this);
                    break;
                }
                case 9: {
                    this.edit = new WindowEditor(data, this.editable, (CTX)ctx, this);
                    break;
                }
                case 5: {
                    this.edit = new NumericEditor(data, this.editable, (CTX)ctx, this);
                    break;
                }
                case 10: {
                    this.edit = new AxisEditor(data, this.editable, (CTX)ctx, this);
                    break;
                }
                case 8: {
                    this.edit = new TextEditor(data, this.editable, (CTX)ctx, this);
                    break;
                }
                default: {
                    this.edit = new AnyEditor(data, this.editable, (CTX)ctx, this);
                }
            }
        }
        this.add((Component)this.edit, "Center");
        JPanel jp = new JPanel();
        this.add((Component)jp, "Last");
        if (this.editable) {
            if (this.edit instanceof SegmentEditor) {
                this.ok_b = new JButton("Update Data");
                jp.add(this.ok_b);
                this.ok_b.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DataDialog.this.updateData();
                    }
                });
                this.apply_b = new JButton("Update Dim");
                jp.add(this.apply_b);
                this.apply_b.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DataDialog.this.updateDim();
                    }
                });
            } else {
                this.ok_b = new JButton("Ok");
                jp.add(this.ok_b);
                this.ok_b.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DataDialog.this.ok();
                    }
                });
                this.apply_b = new JButton("Apply");
                jp.add(this.apply_b);
                this.apply_b.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DataDialog.this.apply();
                    }
                });
            }
            this.reset_b = new JButton("Reset");
            jp.add(this.reset_b);
            this.reset_b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DataDialog.this.reset();
                }
            });
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        DataDialog.this.ok();
                    }
                }
            });
        } else {
            this.reset_b = null;
            this.apply_b = null;
            this.ok_b = null;
        }
        this.cancel_b = new JButton("Cancel");
        this.cancel_b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataDialog.this.cancel();
            }
        });
        this.cancel_b.setSelected(true);
        jp.add(this.cancel_b);
        if (node.isOn()) {
            this.onoff.setText("Node is On   ");
        } else {
            this.onoff.setText("Node is Off  ");
        }
        if (this.editable) {
            this.setTitle("Modify data of " + node.getNciFullPath());
        } else {
            this.setTitle("Display data of " + node.getNciFullPath());
        }
        this.tags.setText(DataDialog.tagList(node.getTags()));
        this.setDefaultCloseOperation(2);
        this.pack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUpdateListener(UpdateListener l) {
        if (this.listener == null) {
            this.listener = new Vector(1);
        }
        Vector<UpdateListener> vector = this.listener;
        synchronized (vector) {
            this.listener.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean apply() {
        block8: {
            if (this.edit instanceof SegmentEditor) {
                return false;
            }
            try {
                Descriptor<?> data = this.edit.getData();
                if (data == null && !this.edit.isNull()) {
                    throw new Exception("Could not compile expression.");
                }
                this.node.putRecord(data);
                if (this.listener == null) break block8;
                Vector<UpdateListener> vector = this.listener;
                synchronized (vector) {
                    for (UpdateListener l : this.listener) {
                        l.update(data);
                    }
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), e.getMessage(), "Error writing datafile", 0);
                return false;
            }
        }
        return true;
    }

    private final void cancel() {
        this.dispose();
    }

    private final void ok() {
        if (this.edit instanceof SegmentEditor) {
            this.dispose();
        }
        if (this.apply()) {
            this.dispose();
        }
    }

    private final void reset() {
        this.edit.reset(true);
        this.validate();
        this.repaint();
    }

    private final void updateData() {
        SegmentEditor segedit = (SegmentEditor)this.edit;
        try {
            this.node.putSegment(segedit.getSegmentIdx(), segedit.getSegmentData());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), e.getMessage(), "Error updating segment", 0);
        }
    }

    private final void updateDim() {
        SegmentEditor segedit = (SegmentEditor)this.edit;
        try {
            Descriptor<?> dim = segedit.getSegmentDim();
            if (dim == null) {
                throw new Exception("Could not compile dimension expression.");
            }
            this.node.updateSegment(segedit.getSegmentStart(), segedit.getSegmentEnd(), dim, segedit.getSegmentIdx());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), e.getMessage(), "Error updating segment", 0);
        }
    }

    public static interface UpdateListener {
        public void update(Descriptor<?> var1);
    }
}

