/*
 * Decompiled with CFR 0.152.
 */
package mds.jtraverser.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import mds.MdsException;
import mds.data.TREE;
import mds.data.descriptor.Descriptor;
import mds.data.descriptor_s.StringDsc;
import mds.jtraverser.MdsView;
import mds.jtraverser.TreeManager;
import mds.jtraverser.TreeView;
import mds.jtraverser.dialogs.Dialogs;

public class OpenTreeDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final JRadioButton readonly;
    private final JRadioButton edit;
    private final JRadioButton normal;
    private final JTextField expt_path = new JTextField(16);
    private final JTextField expt = new JTextField(16);
    JComboBox<String> shot_list = new JComboBox();
    private final TreeManager treeman;

    public OpenTreeDialog(TreeManager treeman) {
        super(JOptionPane.getRootFrame());
        this.setModal(true);
        this.treeman = treeman;
        KeyAdapter keyadapter = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    OpenTreeDialog.this.ok();
                }
            }
        };
        this.setTitle("Open new tree");
        JPanel mjp = new JPanel();
        mjp.setLayout(new BorderLayout());
        JPanel grid = new JPanel();
        grid.setBorder(new EmptyBorder(5, 5, 5, 5));
        grid.setLayout(new GridLayout(3, 2){
            private static final long serialVersionUID = 1L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void layoutContainer(Container parent) {
                Object object = parent.getTreeLock();
                synchronized (object) {
                    Insets insets = parent.getInsets();
                    int ncomponents = parent.getComponentCount();
                    int nrows = this.getRows();
                    int ncols = this.getColumns();
                    if (ncomponents == 0) {
                        return;
                    }
                    if (nrows > 0) {
                        ncols = (ncomponents + nrows - 1) / nrows;
                    } else {
                        nrows = (ncomponents + ncols - 1) / ncols;
                    }
                    int hgap = this.getHgap();
                    int vgap = this.getVgap();
                    Dimension pd = this.preferredLayoutSize(parent);
                    double sw = 1.0 * (double)parent.getWidth() / (double)pd.width;
                    double sh = 1.0 * (double)parent.getHeight() / (double)pd.height;
                    int[] w = new int[ncols];
                    int[] h = new int[nrows];
                    for (int i = 0; i < ncomponents; ++i) {
                        int r = i / ncols;
                        int c = i % ncols;
                        Component comp = parent.getComponent(i);
                        Dimension d = comp.getPreferredSize();
                        d.width = (int)(sw * (double)d.width);
                        d.height = (int)(sh * (double)d.height);
                        if (w[c] < d.width) {
                            w[c] = d.width;
                        }
                        if (h[r] >= d.height) continue;
                        h[r] = d.height;
                    }
                    int x = insets.left;
                    for (int c = 0; c < ncols; ++c) {
                        int y = insets.top;
                        for (int r = 0; r < nrows; ++r) {
                            int i = r * ncols + c;
                            if (i < ncomponents) {
                                parent.getComponent(i).setBounds(x, y, w[c], h[r]);
                            }
                            y += h[r] + vgap;
                        }
                        x += w[c] + hgap;
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Dimension preferredLayoutSize(Container parent) {
                Object object = parent.getTreeLock();
                synchronized (object) {
                    Insets insets = parent.getInsets();
                    int ncomponents = parent.getComponentCount();
                    int nrows = this.getRows();
                    int ncols = this.getColumns();
                    if (nrows > 0) {
                        ncols = (ncomponents + nrows - 1) / nrows;
                    } else {
                        nrows = (ncomponents + ncols - 1) / ncols;
                    }
                    int[] w = new int[ncols];
                    int[] h = new int[nrows];
                    for (int i = 0; i < ncomponents; ++i) {
                        int r = i / ncols;
                        int c = i % ncols;
                        Component comp = parent.getComponent(i);
                        Dimension d = comp.getPreferredSize();
                        if (w[c] < d.width) {
                            w[c] = d.width;
                        }
                        if (h[r] >= d.height) continue;
                        h[r] = d.height;
                    }
                    int nw = 0;
                    for (int j = 0; j < ncols; ++j) {
                        nw += w[j];
                    }
                    int nh = 0;
                    for (int i = 0; i < nrows; ++i) {
                        nh += h[i];
                    }
                    return new Dimension(insets.left + insets.right + nw + (ncols - 1) * this.getHgap(), insets.top + insets.bottom + nh + (nrows - 1) * this.getVgap());
                }
            }
        });
        grid.add(new JLabel("path: "));
        grid.add(this.expt_path);
        this.expt_path.addKeyListener(keyadapter);
        grid.add(new JLabel("expt: "));
        grid.add(this.expt);
        this.expt.addKeyListener(keyadapter);
        grid.add(new JLabel("shot: "));
        grid.add(this.shot_list);
        this.shot_list.setEditable(true);
        this.shot_list.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                int[] shots;
                OpenTreeDialog.this.shot_list.removeAllItems();
                OpenTreeDialog.this.shot_list.addItem("model");
                String exp = OpenTreeDialog.this.expt.getText().trim();
                OpenTreeDialog.this.setTreePath(exp);
                if (OpenTreeDialog.this.treeman == null) {
                    shots = new int[]{};
                } else {
                    try {
                        shots = OpenTreeDialog.this.treeman.getMds().getIntegerArray("getShotDB($)", new Descriptor[]{new StringDsc(exp)});
                    }
                    catch (MdsException exc) {
                        MdsException.stderr((String)"getShotDB", (Exception)((Object)exc));
                        shots = new int[]{};
                    }
                }
                for (int shot : shots) {
                    OpenTreeDialog.this.shot_list.addItem(Integer.toString(shot));
                }
            }
        });
        mjp.add((Component)grid, "North");
        JPanel access = new JPanel(new GridLayout(1, 3));
        this.readonly = new JRadioButton("readonly");
        access.add(this.readonly);
        this.normal = new JRadioButton("normal");
        access.add(this.normal);
        this.edit = new JRadioButton("edit/new");
        access.add(this.edit);
        ButtonGroup bgMode = new ButtonGroup();
        bgMode.add(this.readonly);
        bgMode.add(this.normal);
        bgMode.add(this.edit);
        this.readonly.addKeyListener(keyadapter);
        this.normal.addKeyListener(keyadapter);
        this.edit.addKeyListener(keyadapter);
        this.readonly.setSelected(true);
        mjp.add((Component)access, "Center");
        JPanel buttons = new JPanel();
        JButton but = new JButton("Ok");
        buttons.add(but);
        this.getRootPane().setDefaultButton(but);
        but.setSelected(true);
        but.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpenTreeDialog.this.ok();
            }
        });
        but = new JButton("Cancel");
        buttons.add(but);
        but.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpenTreeDialog.this.setVisible(false);
            }
        });
        mjp.add((Component)buttons, "South");
        this.getContentPane().add(mjp);
        this.pack();
        this.setResizable(false);
    }

    void ok() {
        int shot;
        String shot_str;
        String exp = this.expt.getText().trim();
        if (exp == null || exp.length() == 0) {
            JOptionPane.showMessageDialog(this, "Missing experiment name", "Error opening tree", 2);
            return;
        }
        String string = shot_str = this.shot_list.getSelectedItem() instanceof String ? ((String)this.shot_list.getSelectedItem()).trim() : "";
        if (shot_str.length() == 0 || shot_str.trim().equalsIgnoreCase("model")) {
            shot = -1;
        } else {
            try {
                shot = Integer.parseInt(shot_str);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "Wrong shot number", "Error opening tree", 2);
                return;
            }
        }
        this.setVisible(false);
        TREE.MODE mode = this.edit.isSelected() ? TREE.EDITABLE : (this.readonly.isSelected() ? TREE.READONLY : TREE.NORMAL);
        if (this.treeman != null) {
            this.setTreePath(exp);
            this.treeman.openTree(exp, shot, mode);
        }
    }

    public final void open() {
        this.readonly.setSelected(true);
        TreeView treeview = null;
        if (this.treeman != null) {
            Dialogs.setLocation(this);
            MdsView mdsview = this.treeman.getCurrentMdsView();
            if (mdsview != null) {
                treeview = this.treeman.getCurrentTreeView();
            }
        }
        if (treeview != null) {
            this.setFields(treeview.getExpt(), treeview.getShot());
        } else {
            TREE tree = TREE.getActiveTree();
            if (tree != null) {
                this.setFields(tree.expt, tree.shot);
            }
        }
        if (this.expt.getText().length() > 0) {
            this.shot_list.grabFocus();
        } else {
            this.expt.grabFocus();
        }
        this.setVisible(true);
    }

    public final void setFields(String expt, int shot) {
        this.expt.setText(expt);
        this.shot_list.setSelectedItem(shot == -1 ? "model" : Integer.toString(shot));
    }

    private final void setTreePath(String exp) {
        String path = this.expt_path.getText().trim();
        if (this.treeman != null) {
            this.treeman.setTreePathEnv(exp, path);
        }
    }
}

