/*
 * Decompiled with CFR 0.152.
 */
package mds.jtraverser.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import mds.MdsException;
import mds.data.CTX;
import mds.data.descriptor.Descriptor;
import mds.jtraverser.editor.Editor;
import mds.jtraverser.editor.ExprEditor;

public class ArgEditor
extends JScrollPane {
    private static final long serialVersionUID = 1L;
    private final ExprEditor[] args;
    private final int num_args;
    protected final Dimension preferred;

    public ArgEditor(boolean editable, CTX ctx, Descriptor<?> ... descriptors) {
        this(descriptors, editable, ctx, 9, new Dimension(220, 89));
    }

    public ArgEditor(CTX ctx) {
        this(null, true, ctx, 9, new Dimension(220, 89));
    }

    public ArgEditor(Descriptor<?>[] data, boolean editable, CTX ctx, int num_args, Dimension preferred) {
        this.preferred = preferred;
        this.num_args = num_args;
        JPanel jp = new JPanel();
        jp.setLayout(new GridLayout(num_args, 1));
        this.args = new ExprEditor[num_args];
        for (int i = 0; i < num_args; ++i) {
            this.args[i] = Editor.addLabel("Argument " + (i + 1), new ExprEditor(editable, ctx, true, false));
            jp.add(this.args[i]);
        }
        JPanel jp2 = new JPanel();
        jp2.setLayout(new BorderLayout());
        jp2.add((Component)jp, "North");
        this.setViewportView(jp2);
        this.setPreferredSize(preferred);
        this.getVerticalScrollBar().setUnitIncrement(43);
        if (data != null) {
            this.setData(data);
        }
    }

    public final Descriptor<?> getData(int i) throws MdsException {
        return this.args[i].getData();
    }

    public Descriptor<?>[] getDataArray() throws MdsException {
        Descriptor[] data = new Descriptor[this.num_args];
        int len = 0;
        for (int i = 0; i < this.num_args; ++i) {
            data[i] = this.args[i].getData();
            if (data[i] == null) continue;
            len = i + 1;
        }
        Descriptor[] out = new Descriptor[len];
        System.arraycopy(data, 0, out, 0, len);
        return out;
    }

    public boolean isNull() {
        for (ExprEditor arg : this.args) {
            if (arg.isNull()) continue;
            return false;
        }
        return true;
    }

    public final void reset(boolean hard) {
        for (ExprEditor arg : this.args) {
            arg.reset(hard);
        }
    }

    public final void setData(Descriptor<?> ... data) {
        int i;
        int min_len = 0;
        if (data != null) {
            min_len = data.length < this.num_args ? data.length : this.num_args;
            for (i = 0; i < min_len; ++i) {
                this.args[i].setData(data[i]);
            }
        }
        while (i < this.num_args) {
            this.args[i].setData(null);
            ++i;
        }
    }
}

