/*
 * Decompiled with CFR 0.152.
 */
package mds.jtraverser.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import mds.MdsException;
import mds.data.CTX;
import mds.data.descriptor.Descriptor;
import mds.data.descriptor_s.Int32;
import mds.data.descriptor_s.StringDsc;
import mds.jtraverser.editor.Editor;

public class EnumEditor
extends Editor {
    private static final long serialVersionUID = 1L;
    private final JComboBox<String> combo;
    private String expr;
    private final JButton left;
    private final JButton right;
    private final MODE mode;
    private boolean quotes_added;
    private final String[] items;
    private final Color defaultbg;
    private final Color defaultfg;

    public EnumEditor(Descriptor<?> data, boolean editable, CTX ctx, String tooltip, MODE mode, String ... items) {
        super(data, editable, ctx, 0);
        this.mode = mode;
        this.items = items;
        this.setLayout(new BorderLayout());
        this.combo = new JComboBox();
        this.combo.setEditable(editable);
        this.defaultbg = this.combo.getBackground();
        this.defaultfg = this.combo.getForeground();
        for (String item : items) {
            this.combo.addItem(item);
        }
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(this.combo, "Center");
        JButton menu = new JButton("-");
        menu.setMargin(new Insets(0, 3, 0, 3));
        menu.addMouseListener(new Editor.EvalPopupMenu(this, Editor.POPUP_MODE.CLICK));
        panel.add((Component)menu, "East");
        this.add((Component)panel, "Center");
        this.left = new JButton("\"");
        this.right = new JButton("\"");
        Insets insets = new Insets(0, 0, 0, 0);
        this.left.setMargin(insets);
        this.right.setMargin(insets);
        if (this.editable) {
            ActionListener leftright = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EnumEditor.this.quotes_added = false;
                    EnumEditor.this.remove(EnumEditor.this.left);
                    EnumEditor.this.remove(EnumEditor.this.right);
                    EnumEditor.this.expr = (String)EnumEditor.this.combo.getSelectedItem();
                    EnumEditor.this.expr = StringDsc.addQuotes((String)EnumEditor.this.expr);
                    String[] itms = new String[EnumEditor.this.combo.getItemCount()];
                    for (int i = 0; i < itms.length; ++i) {
                        itms[i] = StringDsc.addQuotes((String)((String)EnumEditor.this.combo.getItemAt(i)));
                    }
                    EnumEditor.this.combo.removeAllItems();
                    for (String item : itms) {
                        EnumEditor.this.combo.addItem(item);
                    }
                    EnumEditor.this.combo.setSelectedItem(EnumEditor.this.expr);
                    EnumEditor.this.validate();
                    EnumEditor.this.repaint();
                }
            };
            this.left.addActionListener(leftright);
            this.right.addActionListener(leftright);
        }
        if (tooltip != null) {
            this.setToolTipText(tooltip);
            this.combo.setToolTipText(tooltip);
        }
        this.setData(data);
    }

    @Override
    public final Descriptor<?> getData() throws MdsException {
        int index;
        if (this.mode == MODE.INDEX && (index = this.combo.getSelectedIndex()) >= 0) {
            return new Int32(index);
        }
        this.expr = ((String)this.combo.getSelectedItem()).trim();
        if (this.expr.isEmpty()) {
            return null;
        }
        if (this.quotes_added) {
            return new StringDsc(this.expr);
        }
        return this.getMds().getAPI().tdiCompile(this.ctx, this.expr, new Descriptor[0]).getData();
    }

    @Override
    public final void reset(boolean hard) {
        if (this.mode == MODE.INDEX && this.data instanceof Int32) {
            int index = this.data.toInt();
            this.expr = this.combo.getItemAt(index);
            if (this.expr == null) {
                this.expr = Integer.toString(index);
                this.combo.setSelectedItem(this.expr);
            } else {
                this.combo.setSelectedIndex(index);
            }
            this.quotes_added = false;
        } else if (this.mode == MODE.STRING && this.data instanceof StringDsc) {
            this.expr = this.data.toString();
            boolean bl = this.quotes_added = this.expr.trim().length() == this.expr.length();
            if (!this.quotes_added) {
                this.expr = this.data.decompile();
            }
            this.updateItems();
        } else if (Editor.isNoData(this.data)) {
            this.expr = null;
            this.quotes_added = this.mode == MODE.STRING;
            this.updateItems();
        } else {
            this.quotes_added = false;
            this.expr = this.data.decompile();
            this.updateItems();
        }
        if (this.expr != null && this.expr.contains(" /*** etc. ***/)")) {
            this.combo.setBackground(Color.PINK);
            this.combo.setForeground(Color.RED);
        } else {
            this.combo.setBackground(this.defaultbg);
            this.combo.setForeground(this.defaultfg);
        }
        this.validate();
        this.repaint();
    }

    @Override
    public final void setData(Descriptor<?> data) {
        this.data = data;
        this.reset(false);
    }

    private void updateItems() {
        if (this.mode == MODE.STRING) {
            this.combo.removeAllItems();
            if (this.quotes_added) {
                this.add((Component)this.left, "Before");
                this.add((Component)this.right, "After");
                for (String item : this.items) {
                    this.combo.addItem(item);
                }
            } else {
                this.remove(this.left);
                this.remove(this.right);
                for (String item : this.items) {
                    this.combo.addItem(StringDsc.addQuotes((String)item));
                }
            }
        }
        this.combo.setSelectedItem(this.expr);
    }

    public static enum MODE {
        INDEX,
        STRING,
        ASIS;

    }
}

