/*
 * Decompiled with CFR 0.152.
 */
package mds.jtraverser.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import mds.MdsException;
import mds.data.CTX;
import mds.data.OPC;
import mds.data.descriptor.Descriptor;
import mds.data.descriptor_a.StringArray;
import mds.data.descriptor_r.Function;
import mds.data.descriptor_r.function.Fun;
import mds.data.descriptor_s.StringDsc;
import mds.jtraverser.editor.Editor;

public final class PythonEditor
extends Editor {
    private static final long serialVersionUID = 1L;
    static final short OPC_FUN = 162;
    boolean default_scroll = true;
    String program;
    String retVar;
    int rows = 7;
    int columns = 20;
    JTextArea text_area;
    JTextField text_field;

    public static final boolean checkData(Descriptor<?> data) {
        if (data instanceof Function && ((Function)data).getOpCode() == OPC.OpcFun) {
            Descriptor[] args = ((Function)data).getArguments();
            try {
                if (args != null && args.length > 2 && args[1] != null && args[1] instanceof StringDsc && ((StringDsc)args[1]).toString() != null && ((StringDsc)args[1]).toString().toUpperCase().equals("PY")) {
                    return true;
                }
            }
            catch (Exception exc) {
                MdsException.stderr((String)"DataEditor.checkUsrData", (Exception)exc);
            }
        }
        return false;
    }

    public PythonEditor(boolean editable, CTX ctx) {
        this(null, editable, ctx);
    }

    public PythonEditor(Function function, boolean editable, CTX ctx) {
        super((Descriptor<?>)function, editable, ctx, 0);
        if (function != null) {
            this.getProgram(function);
        } else {
            this.program = "";
            this.retVar = "";
        }
        this.text_area = new JTextArea(this.rows, this.columns);
        this.text_area.setEditable(editable);
        this.text_area.setText(this.program);
        this.text_field = new JTextField(10);
        this.text_field.setEditable(editable);
        this.text_field.setText(this.retVar);
        Dimension d = this.text_area.getPreferredSize();
        d.height += 20;
        d.width += 20;
        JPanel jp = new JPanel();
        jp.setLayout(new BorderLayout());
        JPanel jp1 = new JPanel();
        jp1.setLayout(new BorderLayout());
        jp1.setBorder(BorderFactory.createTitledBorder("Return Variable"));
        jp1.add(this.text_field);
        jp.add((Component)jp1, "North");
        JPanel jp2 = new JPanel();
        jp2.setLayout(new BorderLayout());
        jp2.setBorder(BorderFactory.createTitledBorder("Program"));
        JScrollPane scroll_pane = new JScrollPane(this.text_area);
        scroll_pane.setPreferredSize(d);
        jp2.add(scroll_pane);
        jp.add((Component)jp2, "Center");
        this.setLayout(new BorderLayout());
        this.add((Component)jp, "Center");
    }

    @Override
    public final Descriptor<?> getData() {
        String programTxt = this.text_area.getText();
        if (programTxt == null || programTxt.equals("")) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(programTxt, "\n");
        String[] lines = new String[st.countTokens()];
        int idx = 0;
        int maxLen = 0;
        while (st.hasMoreTokens()) {
            lines[idx] = st.nextToken();
            if (maxLen < lines[idx].length()) {
                maxLen = lines[idx].length();
            }
            ++idx;
        }
        for (int i = 0; i < lines.length; ++i) {
            int len = lines[i].length();
            for (int j = 0; j < maxLen - len; ++j) {
                int n = i;
                lines[n] = lines[n] + " ";
            }
        }
        StringArray stArr = new StringArray(lines);
        String retVarTxt = this.text_field.getText();
        Descriptor[] Args = retVarTxt == null || retVarTxt.equals("") ? new Descriptor[]{null, new StringDsc("Py"), stArr} : new Descriptor[]{null, new StringDsc("Py"), stArr, new StringDsc(retVarTxt)};
        return new Fun(Args);
    }

    private final void getProgram(Function function) {
        Descriptor[] args = function.getArguments();
        this.retVar = args.length <= 2 || args[2] == null ? "" : args[2].toString();
        this.program = args.length <= 1 || args[1] == null ? "" : (args[1] instanceof StringArray ? ((StringArray)args[2]).join_by("\n") : args[1].toString());
    }

    @Override
    public final void reset(boolean hard) {
        this.text_area.setText(this.program);
        this.text_field = new JTextField(this.retVar);
    }
}

