/*
 * Decompiled with CFR 0.152.
 */
package mds.jtraverser.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mds.MdsException;
import mds.data.CTX;
import mds.data.descriptor.Descriptor;
import mds.data.descriptor.Descriptor_A;
import mds.data.descriptor_apd.List;
import mds.data.descriptor_s.NODE;
import mds.data.descriptor_s.NUMBER;
import mds.jtraverser.Node;
import mds.jtraverser.editor.Editor;
import mds.jtraverser.editor.ExprEditor;
import mds.jtraverser.editor.usage.NumericEditor;

public class SegmentEditor
extends Editor {
    private static final long serialVersionUID = 1L;
    private final NODE<?> node;
    private int segment = 0;

    public static final boolean checkData(Node node) {
        return node != null && node.getNumSegments() > 0;
    }

    public SegmentEditor(NODE<?> node, boolean editable, Window window) {
        super(null, editable, (CTX)node.getTree(), 5);
        int num_segments;
        this.node = node;
        try {
            num_segments = this.node.getRecordInfoC().num_segments;
        }
        catch (MdsException e) {
            MdsException.stderr((String)"SegmentEditor.getNumSegments", (Exception)((Object)e));
            num_segments = 0;
        }
        this.setLayout(new BorderLayout());
        JPanel columns = new JPanel(new GridLayout(1, 2));
        this.edit[0] = new NumericEditor(this.editable, this.ctx, window, "Data");
        columns.add(this.edit[0]);
        JPanel dimension = new JPanel(new BorderLayout());
        this.edit[1] = new NumericEditor(this.editable, this.ctx, window, "Dimension");
        dimension.add(this.edit[1]);
        columns.add(dimension);
        JPanel limits = new JPanel(new GridLayout(2, 1));
        this.edit[3] = Editor.addLabel("start", new ExprEditor(this.editable, this.ctx, false, false));
        limits.add((Component)this.edit[3], 0);
        this.edit[4] = Editor.addLabel("end", new ExprEditor(this.editable, this.ctx, false, false));
        limits.add((Component)this.edit[4], 1);
        if (this.editable) {
            JPanel limitsedit = new JPanel(new BorderLayout());
            JButton setlimits = new JButton("Update Limits");
            setlimits.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    try {
                        SegmentEditor.this.node.updateSegment(SegmentEditor.this.edit[3].getData(), SegmentEditor.this.edit[4].getData(), null, SegmentEditor.this.segment);
                    }
                    catch (MdsException e) {
                        MdsException.stderr((String)"SignalEditor", (Exception)((Object)e));
                    }
                }
            });
            limitsedit.add(limits);
            limitsedit.add((Component)setlimits, "South");
            dimension.add((Component)limitsedit, "South");
        } else {
            dimension.add((Component)limits, "South");
        }
        this.add(columns);
        JPanel segpane = new JPanel(new BorderLayout());
        JSlider segments = new JSlider(0, num_segments - 1, this.segment);
        JPanel scale = new JPanel(new BorderLayout());
        this.edit[2] = new ExprEditor(this.editable, this.ctx, false, false);
        scale.add(this.edit[2]);
        if (this.editable) {
            JButton setscale = new JButton("Set Scale");
            setscale.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    try {
                        SegmentEditor.this.node.setSegmentScale(SegmentEditor.this.edit[2].getData());
                    }
                    catch (MdsException e) {
                        MdsException.stderr((String)"SignalEditor", (Exception)((Object)e));
                    }
                }
            });
            scale.add((Component)setscale, "East");
        }
        segpane.add((Component)Editor.addLabel("Segment Scale", scale), "North");
        segpane.add((Component)segments, "Center");
        final JTextField text = new JTextField(9);
        text.setHorizontalAlignment(0);
        text.setText(Integer.toString(this.segment));
        text.setEditable(false);
        segpane.add((Component)text, "West");
        JLabel label = new JLabel(new StringBuilder(21).append("Segments: ").append((long)num_segments & 0xFFFFFFFFL).toString(), 0);
        label.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        segpane.add((Component)label, "East");
        segments.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent ce) {
                int newsegment = ((JSlider)ce.getSource()).getValue();
                if (SegmentEditor.this.segment == newsegment) {
                    return;
                }
                SegmentEditor.this.setSegment(newsegment);
            }
        });
        segments.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ce) {
                text.setText(Integer.toString(((JSlider)ce.getSource()).getValue()));
            }
        });
        this.add((Component)segpane, "North");
        this.setSegment(0);
    }

    @Override
    public final Descriptor<?> getData() throws MdsException {
        MdsException.handleStatus((int)265388354);
        return null;
    }

    public final Descriptor_A<?> getSegmentData() throws MdsException {
        return this.edit[0].getData().getDataA();
    }

    public final Descriptor<?> getSegmentDim() throws MdsException {
        return this.edit[1].getData();
    }

    public final NUMBER<?> getSegmentEnd() throws MdsException {
        return this.edit[4].getNumber();
    }

    public final int getSegmentIdx() {
        return this.segment;
    }

    public final Descriptor<?> getSegmentScale() throws MdsException {
        return this.edit[2].getData();
    }

    public final NUMBER<?> getSegmentStart() throws MdsException {
        return this.edit[3].getNumber();
    }

    @Override
    public final void reset(boolean hard) {
        this.setSegment(this.segment);
    }

    @Override
    public final void setData(Descriptor<?> data) {
    }

    public final void setSegment(int segment) {
        try {
            this.segment = segment;
            this.edit[0].setData((Descriptor<?>)this.node.getSegmentData(segment));
            this.edit[1].setData(this.node.getSegmentDim(segment));
            this.edit[2].setData(this.node.getSegmentScale());
            ((ExprEditor)this.edit[2]).setValue(this.edit[0].data);
            List limits = this.node.getSegmentLimits(segment);
            this.edit[3].setData(limits.get(0));
            this.edit[4].setData(limits.get(1));
        }
        catch (MdsException e) {
            MdsException.stderr((String)"SignalEditor", (Exception)((Object)e));
            this.data = null;
            this.segment = -1;
        }
    }
}

