/*
 * Decompiled with CFR 0.152.
 */
package mds.jtraverser.editor.usage;

import java.awt.Window;
import mds.data.CTX;
import mds.data.descriptor.Descriptor;
import mds.jtraverser.editor.ActionEditor;
import mds.jtraverser.editor.MethodEditor;
import mds.jtraverser.editor.ProcedureEditor;
import mds.jtraverser.editor.ProgramEditor;
import mds.jtraverser.editor.PythonEditor;
import mds.jtraverser.editor.RoutineEditor;
import mds.jtraverser.editor.SignalEditor;
import mds.jtraverser.editor.WindowEditor;
import mds.jtraverser.editor.usage.TextEditor;

public final class AnyEditor
extends TextEditor {
    private static final long serialVersionUID = 1L;

    public AnyEditor(boolean editable, CTX ctx, Window window) {
        this(null, editable, ctx, window);
    }

    public AnyEditor(Descriptor<?> data, boolean editable, CTX ctx, Window window) {
        super(data, editable, ctx, window, "Data", "Action", "Python Expression", "Signal", "Window", "Method", "Routine", "Program (depreciated)", "Procedure (depreciated)");
    }

    @Override
    protected final boolean addExtraEditor() {
        if (this.curr_mode_idx < this.mode_idx_usr) {
            return false;
        }
        switch (this.curr_mode_idx - this.mode_idx_usr) {
            case 0: {
                this.data_edit = new ActionEditor(this.editable, this.ctx, this.window);
                this.editor.add(this.data_edit);
                return true;
            }
            case 1: {
                this.data_edit = new PythonEditor(this.editable, this.ctx);
                this.editor.add(this.data_edit);
                return true;
            }
            case 2: {
                this.data_edit = new SignalEditor(this.data, this.editable, this.ctx, this.window);
                this.editor.add(this.data_edit);
                return true;
            }
            case 3: {
                this.data_edit = new WindowEditor(this.editable, this.ctx);
                this.editor.add(this.data_edit);
                return true;
            }
            case 4: {
                this.data_edit = new MethodEditor(this.editable, this.ctx);
                this.editor.add(this.data_edit);
                return true;
            }
            case 5: {
                this.data_edit = new RoutineEditor(this.editable, this.ctx);
                this.editor.add(this.data_edit);
                return true;
            }
            case 6: {
                this.data_edit = new ProgramEditor(this.editable, this.ctx);
                this.editor.add(this.data_edit);
                return true;
            }
            case 7: {
                this.data_edit = new ProcedureEditor(this.editable, this.ctx);
                this.editor.add(this.data_edit);
                return true;
            }
        }
        return false;
    }

    @Override
    protected final boolean checkUsrData() {
        int usrmde = this.getUsrMode();
        if (usrmde < 0) {
            return false;
        }
        this.mode_idx = this.mode_idx_usr + usrmde;
        return true;
    }

    private final int getUsrMode() {
        if (ActionEditor.checkData(this.data)) {
            return 0;
        }
        if (PythonEditor.checkData(this.data)) {
            return 1;
        }
        if (SignalEditor.checkData(this.data)) {
            return 2;
        }
        if (WindowEditor.checkData(this.data)) {
            return 3;
        }
        if (MethodEditor.checkData(this.data)) {
            return 4;
        }
        if (RoutineEditor.checkData(this.data)) {
            return 5;
        }
        if (ProgramEditor.checkData(this.data)) {
            return 6;
        }
        if (ProcedureEditor.checkData(this.data)) {
            return 7;
        }
        return -1;
    }
}

