/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver;

import java.util.HashMap;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.junit.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.Query;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;

class QueryTest {
    QueryTest() {
    }

    @Test
    void shouldConstructQueryWithParameters() {
        String text = "MATCH (n) RETURN n";
        Query query = new Query(text, Values.EmptyMap);
        MatcherAssert.assertThat((Object)query.text(), (Matcher)Matchers.equalTo((Object)text));
        MatcherAssert.assertThat((Object)query.parameters(), (Matcher)Matchers.equalTo((Object)Values.EmptyMap));
    }

    @Test
    void shouldConstructQueryWithNoParameters() {
        String text = "MATCH (n) RETURN n";
        Query query = new Query(text);
        MatcherAssert.assertThat((Object)query.text(), (Matcher)Matchers.equalTo((Object)text));
        MatcherAssert.assertThat((Object)query.parameters(), (Matcher)Matchers.equalTo((Object)Values.EmptyMap));
    }

    @Test
    void shouldUpdateQueryText() {
        Query query = new Query("MATCH (n) RETURN n").withText("BOO");
        MatcherAssert.assertThat((Object)query.text(), (Matcher)Matchers.equalTo((Object)"BOO"));
        MatcherAssert.assertThat((Object)query.parameters(), (Matcher)Matchers.equalTo((Object)Values.EmptyMap));
    }

    @Test
    void shouldReplaceQueryParameters() {
        String text = "MATCH (n) RETURN n";
        Value initialParameters = Values.parameters((Object[])new Object[]{"a", 1, "b", 2});
        Query query = new Query("MATCH (n) RETURN n").withParameters(initialParameters);
        MatcherAssert.assertThat((Object)query.text(), (Matcher)Matchers.equalTo((Object)text));
        MatcherAssert.assertThat((Object)query.parameters(), (Matcher)Matchers.equalTo((Object)initialParameters));
    }

    @Test
    void shouldReplaceMapParameters() {
        String text = "MATCH (n) RETURN n";
        HashMap<String, Integer> parameters = new HashMap<String, Integer>();
        parameters.put("a", 1);
        Query query = new Query("MATCH (n) RETURN n").withParameters(parameters);
        MatcherAssert.assertThat((Object)query.text(), (Matcher)Matchers.equalTo((Object)text));
        MatcherAssert.assertThat((Object)query.parameters(), (Matcher)Matchers.equalTo((Object)Values.value(parameters)));
    }

    @Test
    void shouldUpdateQueryParameters() {
        String text = "MATCH (n) RETURN n";
        Value initialParameters = Values.parameters((Object[])new Object[]{"a", 1, "b", 2, "c", 3});
        Query query = new Query("MATCH (n) RETURN n", initialParameters).withUpdatedParameters(Values.parameters((Object[])new Object[]{"a", 0, "b", Values.NULL}));
        MatcherAssert.assertThat((Object)query.text(), (Matcher)Matchers.equalTo((Object)text));
        MatcherAssert.assertThat((Object)query.parameters(), (Matcher)Matchers.equalTo((Object)Values.parameters((Object[])new Object[]{"a", 0, "c", 3})));
    }

    @Test
    void shouldProhibitNullQuery() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Query(null));
    }

    @Test
    void shouldProhibitEmptyQuery() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Query(""));
    }
}

