/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.SessionConfig;
import org.neo4j.driver.internal.InternalBookmark;
import org.neo4j.driver.util.TestUtil;

class SessionConfigTest {
    SessionConfigTest() {
    }

    @Test
    void shouldReturnDefaultValues() {
        SessionConfig config = SessionConfig.defaultConfig();
        Assertions.assertEquals((Object)AccessMode.WRITE, (Object)config.defaultAccessMode());
        Assertions.assertFalse((boolean)config.database().isPresent());
        Assertions.assertNull((Object)config.bookmarks());
        Assertions.assertFalse((boolean)config.fetchSize().isPresent());
    }

    @ParameterizedTest
    @EnumSource(value=AccessMode.class)
    void shouldChangeAccessMode(AccessMode mode) {
        SessionConfig config = SessionConfig.builder().withDefaultAccessMode(mode).build();
        Assertions.assertEquals((Object)mode, (Object)config.defaultAccessMode());
    }

    @ParameterizedTest
    @ValueSource(strings={"foo", "data", "my awesome database", "    "})
    void shouldChangeDatabaseName(String databaseName) {
        SessionConfig config = SessionConfig.builder().withDatabase(databaseName).build();
        Assertions.assertTrue((boolean)config.database().isPresent());
        Assertions.assertEquals((Object)databaseName, config.database().get());
    }

    @Test
    void shouldNotAllowNullDatabaseName() {
        Assertions.assertThrows(NullPointerException.class, () -> SessionConfig.builder().withDatabase(null));
    }

    @ParameterizedTest
    @MethodSource(value={"someConfigs"})
    void nullDatabaseNameMustNotBreakEquals(SessionConfig config1, SessionConfig config2, boolean expectedEquals) {
        Assertions.assertEquals((Object)config1.equals((Object)config2), (Object)expectedEquals);
    }

    static Stream<Arguments> someConfigs() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{SessionConfig.builder().build(), SessionConfig.builder().build(), true}), Arguments.arguments((Object[])new Object[]{SessionConfig.builder().withDatabase("a").build(), SessionConfig.builder().build(), false}), Arguments.arguments((Object[])new Object[]{SessionConfig.builder().build(), SessionConfig.builder().withDatabase("a").build(), false}), Arguments.arguments((Object[])new Object[]{SessionConfig.builder().withDatabase("a").build(), SessionConfig.builder().withDatabase("a").build(), true}));
    }

    @ParameterizedTest
    @ValueSource(strings={""})
    void shouldForbiddenEmptyStringDatabaseName(String databaseName) {
        IllegalArgumentException error = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> SessionConfig.builder().withDatabase(databaseName));
        Assertions.assertTrue((boolean)error.getMessage().startsWith("Illegal database name "));
    }

    @Test
    void shouldAcceptNullBookmarks() {
        SessionConfig config = SessionConfig.builder().withBookmarks((Bookmark[])null).build();
        Assertions.assertNull((Object)config.bookmarks());
        SessionConfig config2 = SessionConfig.builder().withBookmarks((Iterable)null).build();
        Assertions.assertNull((Object)config2.bookmarks());
    }

    @Test
    void shouldAcceptEmptyBookmarks() {
        SessionConfig config = SessionConfig.builder().withBookmarks(new Bookmark[0]).build();
        Assertions.assertEquals(Collections.emptyList(), (Object)config.bookmarks());
        SessionConfig config2 = SessionConfig.builder().withBookmarks(Collections.emptyList()).build();
        Assertions.assertEquals(Collections.emptyList(), (Object)config2.bookmarks());
    }

    @Test
    void shouldAcceptBookmarks() {
        Bookmark one = InternalBookmark.parse((String)"one");
        Bookmark two = InternalBookmark.parse((String)"two");
        SessionConfig config = SessionConfig.builder().withBookmarks(new Bookmark[]{one, two}).build();
        Assertions.assertEquals(Arrays.asList(one, two), (Object)config.bookmarks());
        SessionConfig config2 = SessionConfig.builder().withBookmarks(Arrays.asList(one, two)).build();
        Assertions.assertEquals(Arrays.asList(one, two), (Object)config2.bookmarks());
    }

    @Test
    void shouldAcceptNullInBookmarks() {
        Bookmark one = InternalBookmark.parse((String)"one");
        Bookmark two = InternalBookmark.parse((String)"two");
        SessionConfig config = SessionConfig.builder().withBookmarks(new Bookmark[]{one, two, null}).build();
        Assertions.assertEquals(Arrays.asList(one, two, null), (Object)config.bookmarks());
        SessionConfig config2 = SessionConfig.builder().withBookmarks(Arrays.asList(one, two, null)).build();
        Assertions.assertEquals(Arrays.asList(one, two, null), (Object)config2.bookmarks());
    }

    @ParameterizedTest
    @ValueSource(longs={100L, 1L, 1000L, 0x7FFFFFFFFFFFFFFFL, -1L})
    void shouldChangeFetchSize(long value) {
        SessionConfig config = SessionConfig.builder().withFetchSize(value).build();
        Assertions.assertEquals(Optional.of(value), (Object)config.fetchSize());
    }

    @ParameterizedTest
    @ValueSource(longs={0L, -100L, -2L})
    void shouldErrorWithIllegalFetchSize(long value) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> SessionConfig.builder().withFetchSize(value).build());
    }

    @Test
    void shouldTwoConfigBeEqual() {
        SessionConfig config1 = SessionConfig.builder().withFetchSize(100L).build();
        SessionConfig config2 = SessionConfig.builder().withFetchSize(100L).build();
        Assertions.assertEquals((Object)config1, (Object)config2);
    }

    @Test
    void shouldSerialize() throws Exception {
        SessionConfig config = SessionConfig.builder().withBookmarks(new Bookmark[]{Bookmark.from(new HashSet<String>(Arrays.asList("bookmarkA", "bookmarkB"))), Bookmark.from(new HashSet<String>(Arrays.asList("bookmarkC", "bookmarkD")))}).withDefaultAccessMode(AccessMode.WRITE).withFetchSize(54321L).withDatabase("testing").withImpersonatedUser("impersonator").build();
        SessionConfig verify = TestUtil.serializeAndReadBack(config, SessionConfig.class);
        Assertions.assertNotNull((Object)verify.bookmarks());
        ArrayList bookmarks = new ArrayList();
        verify.bookmarks().forEach(b -> bookmarks.add(b.values()));
        Assertions.assertEquals((int)2, (int)bookmarks.size());
        Assertions.assertTrue((boolean)((Set)bookmarks.get(0)).containsAll(Arrays.asList("bookmarkA", "bookmarkB")));
        Assertions.assertTrue((boolean)((Set)bookmarks.get(1)).containsAll(Arrays.asList("bookmarkC", "bookmarkD")));
        Assertions.assertEquals((Object)config.defaultAccessMode(), (Object)verify.defaultAccessMode());
        Assertions.assertEquals((Object)config.fetchSize(), (Object)verify.fetchSize());
        Assertions.assertEquals((Object)config.database(), (Object)verify.database());
        Assertions.assertEquals((Object)config.impersonatedUser(), (Object)verify.impersonatedUser());
    }
}

