/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.integration;

import java.net.URI;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;
import org.neo4j.driver.Session;
import org.neo4j.driver.SessionConfig;
import org.neo4j.driver.util.DatabaseExtension;
import org.neo4j.driver.util.ParallelizableIT;

@ParallelizableIT
class DriverCloseIT {
    @RegisterExtension
    static final DatabaseExtension neo4j = new DatabaseExtension();

    DriverCloseIT() {
    }

    @Test
    void isEncryptedThrowsForClosedDriver() {
        Driver driver = DriverCloseIT.createDriver();
        driver.close();
        Assertions.assertThrows(IllegalStateException.class, () -> ((Driver)driver).isEncrypted());
    }

    @Test
    void sessionThrowsForClosedDriver() {
        Driver driver = DriverCloseIT.createDriver();
        driver.close();
        Assertions.assertThrows(IllegalStateException.class, () -> ((Driver)driver).session());
    }

    @Test
    void sessionWithModeThrowsForClosedDriver() {
        Driver driver = DriverCloseIT.createDriver();
        driver.close();
        Assertions.assertThrows(IllegalStateException.class, () -> driver.session(SessionConfig.builder().withDefaultAccessMode(AccessMode.WRITE).build()));
    }

    @Test
    void closeClosedDriver() {
        Driver driver = DriverCloseIT.createDriver();
        driver.close();
        driver.close();
        driver.close();
    }

    @Test
    void useSessionAfterDriverIsClosed() {
        Driver driver = DriverCloseIT.createDriver();
        Session session = driver.session();
        driver.close();
        Assertions.assertThrows(IllegalStateException.class, () -> session.run("CREATE ()"));
    }

    private static Driver createDriver() {
        return GraphDatabase.driver((URI)neo4j.uri(), (AuthToken)neo4j.authToken());
    }
}

