/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.integration;

import java.net.URI;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.Config;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;
import org.neo4j.driver.Logger;
import org.neo4j.driver.Logging;
import org.neo4j.driver.Session;
import org.neo4j.driver.util.DatabaseExtension;
import org.neo4j.driver.util.ParallelizableIT;

@ParallelizableIT
class LoggingIT {
    @RegisterExtension
    static final DatabaseExtension neo4j = new DatabaseExtension();

    LoggingIT() {
    }

    @Test
    void logShouldRecordDebugAndTraceInfo() {
        Logging logging = (Logging)Mockito.mock(Logging.class);
        Logger logger = (Logger)Mockito.mock(Logger.class);
        Mockito.when((Object)logging.getLog((Class)ArgumentMatchers.any(Class.class))).thenReturn((Object)logger);
        Mockito.when((Object)logger.isDebugEnabled()).thenReturn((Object)true);
        Mockito.when((Object)logger.isTraceEnabled()).thenReturn((Object)true);
        Config config = Config.builder().withLogging(logging).build();
        try (Driver driver = GraphDatabase.driver((URI)neo4j.uri(), (AuthToken)neo4j.authToken(), (Config)config);
             Session session = driver.session();){
            session.run("CREATE (a {name:'Cat'})");
        }
        ((Logger)Mockito.verify((Object)logger, (VerificationMode)Mockito.atLeastOnce())).debug(ArgumentMatchers.anyString(), (Object[])ArgumentMatchers.any(Object[].class));
        ((Logger)Mockito.verify((Object)logger, (VerificationMode)Mockito.atLeastOnce())).trace(ArgumentMatchers.anyString(), (Object[])ArgumentMatchers.any());
    }
}

