/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.integration;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.net.URI;
import org.junit.Test;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.Config;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;
import org.neo4j.driver.MetricsAdapter;
import org.neo4j.driver.QueryRunner;
import org.neo4j.driver.Result;
import org.neo4j.driver.Values;
import org.neo4j.driver.util.DatabaseExtension;
import org.neo4j.driver.util.ParallelizableIT;

@ParallelizableIT
class MetricsIT {
    @RegisterExtension
    static final DatabaseExtension neo4j = new DatabaseExtension();
    private Driver driver;
    private MeterRegistry meterRegistry = new SimpleMeterRegistry();

    MetricsIT() {
    }

    @BeforeEach
    void createDriver() {
        this.driver = GraphDatabase.driver((URI)neo4j.uri(), (AuthToken)neo4j.authToken(), (Config)Config.builder().withMetricsAdapter(MetricsAdapter.MICROMETER).build());
    }

    @AfterEach
    void closeDriver() {
        this.driver.close();
    }

    @Test
    void driverMetricsUpdatedWithDriverUse() {
        Result result = this.createNodesInNewSession(12);
        Timer acquisitionTimer = this.meterRegistry.get("neo4j.driver.connections.acquisition").timer();
        Timer creationTimer = this.meterRegistry.get("neo4j.driver.connections.creation").timer();
        Timer usageTimer = this.meterRegistry.get("neo4j.driver.connections.usage").timer();
        Assertions.assertEquals((long)1L, (long)acquisitionTimer.count());
        Assertions.assertEquals((long)1L, (long)creationTimer.count());
        Assertions.assertEquals((long)0L, (long)usageTimer.count());
        result.consume();
        Assertions.assertEquals((long)1L, (long)acquisitionTimer.count());
        Assertions.assertEquals((long)1L, (long)creationTimer.count());
        Assertions.assertEquals((long)1L, (long)usageTimer.count());
    }

    private Result createNodesInNewSession(int nodesToCreate) {
        return this.createNodes(nodesToCreate, (QueryRunner)this.driver.session());
    }

    private Result createNodes(int nodesToCreate, QueryRunner queryRunner) {
        return queryRunner.run("UNWIND range(1, $nodesToCreate) AS i CREATE (n {index: i}) RETURN n", Values.parameters((Object[])new Object[]{"nodesToCreate", nodesToCreate}));
    }
}

