/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.integration;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.driver.Result;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.internal.value.ListValue;
import org.neo4j.driver.internal.value.MapValue;
import org.neo4j.driver.internal.value.NullValue;
import org.neo4j.driver.internal.value.StringValue;
import org.neo4j.driver.util.ParallelizableIT;
import org.neo4j.driver.util.SessionExtension;

@ParallelizableIT
class ScalarTypeIT {
    @RegisterExtension
    static final SessionExtension session = new SessionExtension();

    ScalarTypeIT() {
    }

    static Stream<Arguments> typesToTest() {
        return Stream.of(Arguments.of((Object[])new Object[]{"RETURN 1 as v", Values.value((long)1L)}), Arguments.of((Object[])new Object[]{"RETURN 1.1 as v", Values.value((double)1.1)}), Arguments.of((Object[])new Object[]{"RETURN 'hello' as v", Values.value((String)"hello")}), Arguments.of((Object[])new Object[]{"RETURN true as v", Values.value((boolean)true)}), Arguments.of((Object[])new Object[]{"RETURN false as v", Values.value((boolean)false)}), Arguments.of((Object[])new Object[]{"RETURN [1,2,3] as v", new ListValue(new Value[]{Values.value((int)1), Values.value((int)2), Values.value((int)3)})}), Arguments.of((Object[])new Object[]{"RETURN ['hello'] as v", new ListValue(new Value[]{Values.value((String)"hello")})}), Arguments.of((Object[])new Object[]{"RETURN [] as v", new ListValue(new Value[0])}), Arguments.of((Object[])new Object[]{"RETURN {k:'hello'} as v", Values.parameters((Object[])new Object[]{"k", Values.value((String)"hello")})}), Arguments.of((Object[])new Object[]{"RETURN {} as v", new MapValue(Collections.emptyMap())}));
    }

    @ParameterizedTest
    @MethodSource(value={"typesToTest"})
    void shouldHandleType(String query, Value expectedValue) {
        Result cursor = session.run(query);
        MatcherAssert.assertThat((Object)cursor.single().get("v"), (Matcher)CoreMatchers.equalTo((Object)expectedValue));
    }

    static Stream<Arguments> collectionItems() {
        return Stream.of(Arguments.of((Object[])new Object[]{Values.value(null)}), Arguments.of((Object[])new Object[]{Values.value((long)1L)}), Arguments.of((Object[])new Object[]{Values.value((double)1.1)}), Arguments.of((Object[])new Object[]{Values.value((String)"hello")}), Arguments.of((Object[])new Object[]{Values.value((boolean)true)}));
    }

    @ParameterizedTest
    @MethodSource(value={"collectionItems"})
    void shouldEchoVeryLongMap(Value collectionItem) {
        HashMap<String, Value> input = new HashMap<String, Value>();
        for (int i = 0; i < 1000; ++i) {
            input.put(String.valueOf(i), collectionItem);
        }
        MapValue mapValue = new MapValue(input);
        this.verifyCanEncodeAndDecode((Value)mapValue);
    }

    @ParameterizedTest
    @MethodSource(value={"collectionItems"})
    void shouldEchoVeryLongList(Value collectionItem) {
        Value[] input = new Value[1000];
        for (int i = 0; i < 1000; ++i) {
            input[i] = collectionItem;
        }
        ListValue listValue = new ListValue(input);
        this.verifyCanEncodeAndDecode((Value)listValue);
    }

    @Test
    void shouldEchoVeryLongString() {
        char[] chars = new char[10000];
        Arrays.fill(chars, '*');
        String longText = new String(chars);
        StringValue input = new StringValue(longText);
        this.verifyCanEncodeAndDecode((Value)input);
    }

    static Stream<Arguments> scalarTypes() {
        return Stream.of(Arguments.of((Object[])new Object[]{Values.value(null)}), Arguments.of((Object[])new Object[]{Values.value((boolean)true)}), Arguments.of((Object[])new Object[]{Values.value((boolean)false)}), Arguments.of((Object[])new Object[]{Values.value((long)1L)}), Arguments.of((Object[])new Object[]{Values.value((long)-17L)}), Arguments.of((Object[])new Object[]{Values.value((long)-129L)}), Arguments.of((Object[])new Object[]{Values.value((long)129L)}), Arguments.of((Object[])new Object[]{Values.value((long)Integer.MAX_VALUE)}), Arguments.of((Object[])new Object[]{Values.value((long)Integer.MIN_VALUE)}), Arguments.of((Object[])new Object[]{Values.value((long)Integer.MIN_VALUE)}), Arguments.of((Object[])new Object[]{Values.value((long)Long.MAX_VALUE)}), Arguments.of((Object[])new Object[]{Values.value((long)Long.MIN_VALUE)}), Arguments.of((Object[])new Object[]{Values.value((double)Double.MAX_VALUE)}), Arguments.of((Object[])new Object[]{Values.value((double)Double.MIN_NORMAL)}), Arguments.of((Object[])new Object[]{Values.value((double)0.0)}), Arguments.of((Object[])new Object[]{Values.value((double)1.1)}), Arguments.of((Object[])new Object[]{Values.value((String)"1")}), Arguments.of((Object[])new Object[]{Values.value((String)"-17\u2202\u00df\u00e5\u00ae")}), Arguments.of((Object[])new Object[]{Values.value((String)"String")}), Arguments.of((Object[])new Object[]{Values.value((String)"")}));
    }

    @ParameterizedTest
    @MethodSource(value={"scalarTypes"})
    void shouldEchoScalarTypes(Value input) {
        this.verifyCanEncodeAndDecode(input);
    }

    static Stream<Arguments> listToTest() {
        return Stream.of(Arguments.of((Object[])new Object[]{Values.value((int[])new int[]{1, 2, 3, 4})}), Arguments.of((Object[])new Object[]{Values.value((boolean[])new boolean[]{true, false})}), Arguments.of((Object[])new Object[]{Values.value((double[])new double[]{1.1, 2.2, 3.3})}), Arguments.of((Object[])new Object[]{Values.value((String[])new String[]{"a", "b", "c", "\u02daC"})}), Arguments.of((Object[])new Object[]{Values.value((Value[])new Value[]{NullValue.NULL, NullValue.NULL})}), Arguments.of((Object[])new Object[]{Values.value((Value[])Values.values((Object[])new Object[]{NullValue.NULL, true, "-17\u2202\u00df\u00e5\u00ae", Double.MAX_VALUE, -9.223372036854776E18}))}), Arguments.of((Object[])new Object[]{new ListValue(new Value[]{Values.parameters((Object[])new Object[]{"a", 1, "b", true, "c", 1.1, "d", "\u02daC", "e", null})})}));
    }

    @ParameterizedTest
    @MethodSource(value={"listToTest"})
    void shouldEchoList(Value input) {
        Assertions.assertTrue((boolean)(input instanceof ListValue));
        this.verifyCanEncodeAndDecode(input);
    }

    @Test
    void shouldEchoNestedList() throws Throwable {
        Value input = Values.value(this.toValueStream(ScalarTypeIT.listToTest()));
        Assertions.assertTrue((boolean)(input instanceof ListValue));
        this.verifyCanEncodeAndDecode(input);
    }

    static Stream<Arguments> mapToTest() {
        return Stream.of(Arguments.of((Object[])new Object[]{Values.parameters((Object[])new Object[]{"a", 1, "b", 2, "c", 3, "d", 4})}), Arguments.of((Object[])new Object[]{Values.parameters((Object[])new Object[]{"a", true, "b", false})}), Arguments.of((Object[])new Object[]{Values.parameters((Object[])new Object[]{"a", 1.1, "b", 2.2, "c", 3.3})}), Arguments.of((Object[])new Object[]{Values.parameters((Object[])new Object[]{"b", "a", "c", "b", "d", "c", "e", "\u02daC"})}), Arguments.of((Object[])new Object[]{Values.parameters((Object[])new Object[]{"a", null})}), Arguments.of((Object[])new Object[]{Values.parameters((Object[])new Object[]{"a", 1, "b", true, "c", 1.1, "d", "\u02daC", "e", null})}));
    }

    @ParameterizedTest
    @MethodSource(value={"mapToTest"})
    void shouldEchoMap(Value input) {
        Assertions.assertTrue((boolean)(input instanceof MapValue));
        this.verifyCanEncodeAndDecode(input);
    }

    @Test
    void shouldEchoNestedMap() throws Throwable {
        MapValue input = new MapValue(this.toValueStream(ScalarTypeIT.mapToTest()).collect(Collectors.toMap(Object::toString, Function.identity())));
        this.verifyCanEncodeAndDecode((Value)input);
    }

    private Stream<Value> toValueStream(Stream<Arguments> arguments) {
        return arguments.map(arg -> {
            Object obj = arg.get()[0];
            Assertions.assertTrue((boolean)(obj instanceof Value));
            return (Value)obj;
        });
    }

    private void verifyCanEncodeAndDecode(Value input) {
        Result cursor = session.run("RETURN $x as y", Values.parameters((Object[])new Object[]{"x", input}));
        MatcherAssert.assertThat((Object)cursor.single().get("y"), (Matcher)CoreMatchers.equalTo((Object)input));
    }
}

