/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.integration;

import io.netty.channel.Channel;
import java.time.Duration;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Config;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Record;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.neo4j.driver.Transaction;
import org.neo4j.driver.TransactionConfig;
import org.neo4j.driver.async.AsyncSession;
import org.neo4j.driver.async.ResultCursor;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.exceptions.TransientException;
import org.neo4j.driver.internal.cluster.RoutingSettings;
import org.neo4j.driver.internal.messaging.Message;
import org.neo4j.driver.internal.messaging.request.GoodbyeMessage;
import org.neo4j.driver.internal.messaging.request.HelloMessage;
import org.neo4j.driver.internal.retry.RetrySettings;
import org.neo4j.driver.internal.security.SecurityPlanImpl;
import org.neo4j.driver.internal.util.EnabledOnNeo4jWith;
import org.neo4j.driver.internal.util.MessageRecordingDriverFactory;
import org.neo4j.driver.internal.util.Neo4jFeature;
import org.neo4j.driver.util.DriverExtension;
import org.neo4j.driver.util.ParallelizableIT;
import org.neo4j.driver.util.TestUtil;

@EnabledOnNeo4jWith(value=Neo4jFeature.BOLT_V3)
@ParallelizableIT
class SessionBoltV3IT {
    @RegisterExtension
    static final DriverExtension driver = new DriverExtension();

    SessionBoltV3IT() {
    }

    @Test
    void shouldSetTransactionMetadata() {
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put("a", "hello world");
        metadata.put("b", LocalDate.now());
        metadata.put("c", Arrays.asList(true, false, true));
        TransactionConfig config = TransactionConfig.builder().withMetadata(metadata).build();
        Result result = driver.session().run("CALL dbms.listTransactions()", config);
        Map receivedMetadata = result.single().get("metaData").asMap();
        Assertions.assertEquals(metadata, (Object)receivedMetadata);
    }

    @Test
    void shouldSetTransactionMetadataAsync() {
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put("key1", "value1");
        metadata.put("key2", 42L);
        TransactionConfig config = TransactionConfig.builder().withMetadata(metadata).build();
        CompletionStage<Map> metadataFuture = driver.asyncSession().runAsync("CALL dbms.listTransactions()", config).thenCompose(ResultCursor::singleAsync).thenApply(record -> record.get("metaData").asMap());
        Assertions.assertEquals(metadata, TestUtil.await(metadataFuture));
    }

    @Test
    void shouldSetTransactionTimeout() {
        Session session = driver.session();
        session.run("CREATE (:Node)").consume();
        try (Session otherSession = driver.driver().session();
             Transaction otherTx = otherSession.beginTransaction();){
            otherTx.run("MATCH (n:Node) SET n.prop = 1").consume();
            Assertions.assertTimeoutPreemptively((Duration)TestUtil.TX_TIMEOUT_TEST_TIMEOUT, () -> {
                TransactionConfig config = TransactionConfig.builder().withTimeout(Duration.ofMillis(1L)).build();
                Exception error = (Exception)Assertions.assertThrows(Exception.class, () -> session.run("MATCH (n:Node) SET n.prop = 2", config).consume());
                SessionBoltV3IT.verifyValidException(error);
            });
        }
    }

    @Test
    void shouldSetTransactionTimeoutAsync() {
        AsyncSession asyncSession = driver.asyncSession();
        TestUtil.await(((ResultCursor)TestUtil.await(asyncSession.runAsync("CREATE (:Node)"))).consumeAsync());
        try (Session otherSession = driver.driver().session();
             Transaction otherTx = otherSession.beginTransaction();){
            otherTx.run("MATCH (n:Node) SET n.prop = 1").consume();
            Assertions.assertTimeoutPreemptively((Duration)TestUtil.TX_TIMEOUT_TEST_TIMEOUT, () -> {
                TransactionConfig config = TransactionConfig.builder().withTimeout(Duration.ofMillis(1L)).build();
                CompletionStage resultFuture = asyncSession.runAsync("MATCH (n:Node) SET n.prop = 2", config).thenCompose(ResultCursor::consumeAsync);
                Exception error = (Exception)Assertions.assertThrows(Exception.class, () -> TestUtil.await(resultFuture));
                SessionBoltV3IT.verifyValidException(error);
            });
        }
    }

    @Test
    void shouldSetTransactionMetadataWithAsyncReadTransactionFunction() {
        SessionBoltV3IT.testTransactionMetadataWithAsyncTransactionFunctions(true);
    }

    @Test
    void shouldSetTransactionMetadataWithAsyncWriteTransactionFunction() {
        SessionBoltV3IT.testTransactionMetadataWithAsyncTransactionFunctions(false);
    }

    @Test
    void shouldSetTransactionMetadataWithReadTransactionFunction() {
        SessionBoltV3IT.testTransactionMetadataWithTransactionFunctions(true);
    }

    @Test
    void shouldSetTransactionMetadataWithWriteTransactionFunction() {
        SessionBoltV3IT.testTransactionMetadataWithTransactionFunctions(false);
    }

    @Test
    void shouldUseBookmarksForAutoCommitTransactions() {
        Session session = driver.session();
        Bookmark initialBookmark = session.lastBookmark();
        session.run("CREATE ()").consume();
        Bookmark bookmark1 = session.lastBookmark();
        Assertions.assertNotNull((Object)bookmark1);
        Assertions.assertNotEquals((Object)initialBookmark, (Object)bookmark1);
        session.run("CREATE ()").consume();
        Bookmark bookmark2 = session.lastBookmark();
        Assertions.assertNotNull((Object)bookmark2);
        Assertions.assertNotEquals((Object)initialBookmark, (Object)bookmark2);
        Assertions.assertNotEquals((Object)bookmark1, (Object)bookmark2);
        session.run("CREATE ()").consume();
        Bookmark bookmark3 = session.lastBookmark();
        Assertions.assertNotNull((Object)bookmark3);
        Assertions.assertNotEquals((Object)initialBookmark, (Object)bookmark3);
        Assertions.assertNotEquals((Object)bookmark1, (Object)bookmark3);
        Assertions.assertNotEquals((Object)bookmark2, (Object)bookmark3);
    }

    @Test
    void shouldUseBookmarksForAutoCommitAndUnmanagedTransactions() {
        Session session = driver.session();
        Bookmark initialBookmark = session.lastBookmark();
        try (Transaction tx = session.beginTransaction();){
            tx.run("CREATE ()");
            tx.commit();
        }
        Bookmark bookmark1 = session.lastBookmark();
        Assertions.assertNotNull((Object)bookmark1);
        Assertions.assertNotEquals((Object)initialBookmark, (Object)bookmark1);
        session.run("CREATE ()").consume();
        Bookmark bookmark2 = session.lastBookmark();
        Assertions.assertNotNull((Object)bookmark2);
        Assertions.assertNotEquals((Object)initialBookmark, (Object)bookmark2);
        Assertions.assertNotEquals((Object)bookmark1, (Object)bookmark2);
        try (Transaction tx = session.beginTransaction();){
            tx.run("CREATE ()");
            tx.commit();
        }
        Bookmark bookmark3 = session.lastBookmark();
        Assertions.assertNotNull((Object)bookmark3);
        Assertions.assertNotEquals((Object)initialBookmark, (Object)bookmark3);
        Assertions.assertNotEquals((Object)bookmark1, (Object)bookmark3);
        Assertions.assertNotEquals((Object)bookmark2, (Object)bookmark3);
    }

    @Test
    void shouldUseBookmarksForAutoCommitTransactionsAndTransactionFunctions() {
        Session session = driver.session();
        Bookmark initialBookmark = session.lastBookmark();
        session.writeTransaction(tx -> tx.run("CREATE ()"));
        Bookmark bookmark1 = session.lastBookmark();
        Assertions.assertNotNull((Object)bookmark1);
        Assertions.assertNotEquals((Object)initialBookmark, (Object)bookmark1);
        session.run("CREATE ()").consume();
        Bookmark bookmark2 = session.lastBookmark();
        Assertions.assertNotNull((Object)bookmark2);
        Assertions.assertNotEquals((Object)initialBookmark, (Object)bookmark2);
        Assertions.assertNotEquals((Object)bookmark1, (Object)bookmark2);
        session.writeTransaction(tx -> tx.run("CREATE ()"));
        Bookmark bookmark3 = session.lastBookmark();
        Assertions.assertNotNull((Object)bookmark3);
        Assertions.assertNotEquals((Object)initialBookmark, (Object)bookmark3);
        Assertions.assertNotEquals((Object)bookmark1, (Object)bookmark3);
        Assertions.assertNotEquals((Object)bookmark2, (Object)bookmark3);
    }

    @Test
    void shouldSendGoodbyeWhenClosingDriver() {
        int txCount = 13;
        MessageRecordingDriverFactory driverFactory = new MessageRecordingDriverFactory();
        try (Driver otherDriver = driverFactory.newInstance(driver.uri(), driver.authToken(), RoutingSettings.DEFAULT, RetrySettings.DEFAULT, Config.defaultConfig(), SecurityPlanImpl.insecure());){
            Transaction tx;
            Session session;
            int i;
            ArrayList<Session> sessions = new ArrayList<Session>();
            ArrayList<Transaction> txs = new ArrayList<Transaction>();
            for (i = 0; i < txCount; ++i) {
                session = otherDriver.session();
                sessions.add(session);
                tx = session.beginTransaction();
                txs.add(tx);
            }
            for (i = 0; i < txCount; ++i) {
                session = (Session)sessions.get(i);
                tx = (Transaction)txs.get(i);
                tx.run("CREATE ()");
                tx.commit();
                session.close();
            }
        }
        Map<Channel, List<Message>> messagesByChannel = driverFactory.getMessagesByChannel();
        Assertions.assertEquals((int)txCount, (int)messagesByChannel.size());
        for (List<Message> messages : messagesByChannel.values()) {
            MatcherAssert.assertThat((Object)messages.size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(2)));
            MatcherAssert.assertThat((Object)messages.get(0), (Matcher)Matchers.instanceOf(HelloMessage.class));
            MatcherAssert.assertThat((Object)messages.get(messages.size() - 1), (Matcher)Matchers.instanceOf(GoodbyeMessage.class));
        }
    }

    private static void testTransactionMetadataWithAsyncTransactionFunctions(boolean read) {
        AsyncSession asyncSession = driver.asyncSession();
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put("foo", "bar");
        metadata.put("baz", true);
        metadata.put("qux", 12345L);
        TransactionConfig config = TransactionConfig.builder().withMetadata(metadata).build();
        CompletionStage singleFuture = read ? asyncSession.readTransactionAsync(tx -> tx.runAsync("CALL dbms.listTransactions()").thenCompose(ResultCursor::singleAsync), config) : asyncSession.writeTransactionAsync(tx -> tx.runAsync("CALL dbms.listTransactions()").thenCompose(ResultCursor::singleAsync), config);
        CompletionStage<Map> metadataFuture = singleFuture.thenApply(record -> record.get("metaData").asMap());
        Assertions.assertEquals(metadata, TestUtil.await(metadataFuture));
    }

    private static void testTransactionMetadataWithTransactionFunctions(boolean read) {
        Session session = driver.session();
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put("foo", "bar");
        metadata.put("baz", true);
        metadata.put("qux", 12345L);
        TransactionConfig config = TransactionConfig.builder().withMetadata(metadata).build();
        Record single = read ? (Record)session.readTransaction(tx -> tx.run("CALL dbms.listTransactions()").single(), config) : (Record)session.writeTransaction(tx -> tx.run("CALL dbms.listTransactions()").single(), config);
        Map receivedMetadata = single.get("metaData").asMap();
        Assertions.assertEquals(metadata, (Object)receivedMetadata);
    }

    private static void verifyValidException(Exception error) {
        if (error instanceof TransientException || error instanceof ClientException) {
            MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)Matchers.containsString((String)"terminated"));
        } else {
            Assertions.fail((String)"Expected either a TransientException or ClientException", (Throwable)error);
        }
    }
}

