/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.integration;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.neo4j.driver.Record;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.internal.util.EnabledOnNeo4jWith;
import org.neo4j.driver.internal.util.Neo4jFeature;
import org.neo4j.driver.types.Point;
import org.neo4j.driver.util.ParallelizableIT;
import org.neo4j.driver.util.SessionExtension;

@EnabledOnNeo4jWith(value=Neo4jFeature.SPATIAL_TYPES)
@ParallelizableIT
class SpatialTypesIT {
    private static final int WGS_84_CRS_CODE = 4326;
    private static final int CARTESIAN_CRS_CODE = 7203;
    private static final double DELTA = 1.0E-5;
    @RegisterExtension
    static final SessionExtension session = new SessionExtension();

    SpatialTypesIT() {
    }

    @Test
    void shouldReceivePoint() {
        Record record = session.run("RETURN point({x: 39.111748, y:-76.775635})").single();
        Point point = record.get(0).asPoint();
        Assertions.assertEquals((int)7203, (int)point.srid());
        Assertions.assertEquals((double)39.111748, (double)point.x(), (double)1.0E-5);
        Assertions.assertEquals((double)-76.775635, (double)point.y(), (double)1.0E-5);
    }

    @Test
    void shouldSendPoint() {
        Value pointValue = Values.point((int)4326, (double)38.8719, (double)77.0563);
        Record record1 = session.run("CREATE (n:Node {location: $point}) RETURN 42", Collections.singletonMap("point", pointValue)).single();
        Assertions.assertEquals((int)42, (int)record1.get(0).asInt());
        Record record2 = session.run("MATCH (n:Node) RETURN n.location").single();
        Point point = record2.get(0).asPoint();
        Assertions.assertEquals((int)4326, (int)point.srid());
        Assertions.assertEquals((double)38.8719, (double)point.x(), (double)1.0E-5);
        Assertions.assertEquals((double)77.0563, (double)point.y(), (double)1.0E-5);
    }

    @Test
    void shouldSendAndReceivePoint() {
        this.testPointSendAndReceive(Values.point((int)7203, (double)40.7624, (double)73.9738));
    }

    @Test
    void shouldSendAndReceiveRandom2DPoints() {
        Stream<Value> randomPoints = ThreadLocalRandom.current().ints(1000L, 0, 2).mapToObj(SpatialTypesIT::createPoint);
        randomPoints.forEach(this::testPointSendAndReceive);
    }

    @Test
    void shouldSendAndReceiveRandom2DPointArrays() {
        Stream<List> randomPointLists = ThreadLocalRandom.current().ints(1000L, 0, 2).mapToObj(SpatialTypesIT::randomPointList);
        randomPointLists.forEach(this::testPointListSendAndReceive);
    }

    private void testPointSendAndReceive(Value pointValue) {
        Point originalPoint = pointValue.asPoint();
        Record record = session.run("CREATE (n {point: $point}) return n.point", Collections.singletonMap("point", pointValue)).single();
        Point receivedPoint = record.get(0).asPoint();
        SpatialTypesIT.assertPoints2DEqual(originalPoint, receivedPoint);
    }

    private void testPointListSendAndReceive(List<Value> points) {
        Record record = session.run("CREATE (n {points: $points}) return n.points", Collections.singletonMap("points", points)).single();
        List receivedPoints = record.get(0).asList(Values.ofPoint());
        Assertions.assertEquals((int)points.size(), (int)receivedPoints.size());
        for (int i = 0; i < points.size(); ++i) {
            SpatialTypesIT.assertPoints2DEqual(points.get(i).asPoint(), (Point)receivedPoints.get(i));
        }
    }

    private static List<Value> randomPointList(int index) {
        int size = ThreadLocalRandom.current().nextInt(1, 100);
        return IntStream.range(0, size).mapToObj(ignored -> SpatialTypesIT.createPoint(index)).collect(Collectors.toList());
    }

    private static Value createPoint(int idx) {
        return idx % 2 == 0 ? Values.point((int)7203, (double)SpatialTypesIT.randomDouble(), (double)SpatialTypesIT.randomDouble()) : Values.point((int)4326, (double)SpatialTypesIT.randomDouble(), (double)SpatialTypesIT.randomDoubleWGS_84_Y());
    }

    private static double randomDouble() {
        return ThreadLocalRandom.current().nextDouble(-180.0, 180.0);
    }

    private static double randomDoubleWGS_84_Y() {
        return ThreadLocalRandom.current().nextDouble(-90.0, 90.0);
    }

    private static void assertPoints2DEqual(Point expected, Point actual) {
        String message = "Expected: " + expected + " but was: " + actual;
        Assertions.assertEquals((int)expected.srid(), (int)actual.srid(), (String)message);
        Assertions.assertEquals((double)expected.x(), (double)actual.x(), (double)1.0E-5, (String)message);
        Assertions.assertEquals((double)expected.y(), (double)actual.y(), (double)1.0E-5, (String)message);
    }
}

