/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.integration;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.neo4j.driver.Record;
import org.neo4j.driver.Result;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.internal.util.EnabledOnNeo4jWith;
import org.neo4j.driver.internal.util.Neo4jFeature;
import org.neo4j.driver.types.IsoDuration;
import org.neo4j.driver.util.ParallelizableIT;
import org.neo4j.driver.util.SessionExtension;
import org.neo4j.driver.util.TemporalUtil;

@EnabledOnNeo4jWith(value=Neo4jFeature.TEMPORAL_TYPES)
@ParallelizableIT
class TemporalTypesIT {
    private static final int RANDOM_VALUES_TO_TEST = 1000;
    private static final int RANDOM_LISTS_TO_TEST = 100;
    private static final int MIN_LIST_SIZE = 100;
    private static final int MAX_LIST_SIZE = 1000;
    @RegisterExtension
    static final SessionExtension session = new SessionExtension();

    TemporalTypesIT() {
    }

    @Test
    void shouldSendDate() {
        TemporalTypesIT.testSendValue(LocalDate.now(), Value::asLocalDate);
    }

    @Test
    void shouldReceiveDate() {
        TemporalTypesIT.testReceiveValue("RETURN date({year: 1995, month: 12, day: 4})", LocalDate.of(1995, 12, 4), Value::asLocalDate);
    }

    @Test
    void shouldSendAndReceiveDate() {
        TemporalTypesIT.testSendAndReceiveValue(LocalDate.now(), Value::asLocalDate);
    }

    @Test
    void shouldSendAndReceiveRandomDate() {
        TemporalTypesIT.testSendAndReceiveRandomValues(TemporalUtil::randomLocalDate, Value::asLocalDate);
    }

    @Test
    void shouldSendAndReceiveListsWithRandomDates() {
        TemporalTypesIT.testSendAndReceiveRandomLists(TemporalUtil::randomLocalDate);
    }

    @Test
    void shouldSendTime() {
        TemporalTypesIT.testSendValue(OffsetTime.now(), Value::asOffsetTime);
    }

    @Test
    void shouldReceiveTime() {
        TemporalTypesIT.testReceiveValue("RETURN time({hour: 23, minute: 19, second: 55, timezone:'-07:00'})", OffsetTime.of(23, 19, 55, 0, ZoneOffset.ofHours(-7)), Value::asOffsetTime);
    }

    @Test
    void shouldSendAndReceiveTime() {
        TemporalTypesIT.testSendAndReceiveValue(OffsetTime.now(), Value::asOffsetTime);
    }

    @Test
    void shouldSendAndReceiveRandomTime() {
        TemporalTypesIT.testSendAndReceiveRandomValues(TemporalUtil::randomOffsetTime, Value::asOffsetTime);
    }

    @Test
    void shouldSendAndReceiveListsWithRandomTimes() {
        TemporalTypesIT.testSendAndReceiveRandomLists(TemporalUtil::randomOffsetTime);
    }

    @Test
    void shouldSendLocalTime() {
        TemporalTypesIT.testSendValue(LocalTime.now(), Value::asLocalTime);
    }

    @Test
    void shouldReceiveLocalTime() {
        TemporalTypesIT.testReceiveValue("RETURN localtime({hour: 22, minute: 59, second: 10, nanosecond: 999999})", LocalTime.of(22, 59, 10, 999999), Value::asLocalTime);
    }

    @Test
    void shouldSendAndReceiveLocalTime() {
        TemporalTypesIT.testSendAndReceiveValue(LocalTime.now(), Value::asLocalTime);
    }

    @Test
    void shouldSendAndReceiveRandomLocalTime() {
        TemporalTypesIT.testSendAndReceiveRandomValues(TemporalUtil::randomLocalTime, Value::asLocalTime);
    }

    @Test
    void shouldSendAndReceiveListsWithRandomLocalTimes() {
        TemporalTypesIT.testSendAndReceiveRandomLists(TemporalUtil::randomLocalTime);
    }

    @Test
    void shouldSendLocalDateTime() {
        TemporalTypesIT.testSendValue(LocalDateTime.now(), Value::asLocalDateTime);
    }

    @Test
    void shouldReceiveLocalDateTime() {
        TemporalTypesIT.testReceiveValue("RETURN localdatetime({year: 1899, month: 3, day: 20, hour: 12, minute: 17, second: 13, nanosecond: 999})", LocalDateTime.of(1899, Month.MARCH, 20, 12, 17, 13, 999), Value::asLocalDateTime);
    }

    @Test
    void shouldSendAndReceiveLocalDateTime() {
        TemporalTypesIT.testSendAndReceiveValue(LocalDateTime.now(), Value::asLocalDateTime);
    }

    @Test
    void shouldSendAndReceiveRandomLocalDateTime() {
        TemporalTypesIT.testSendAndReceiveRandomValues(TemporalUtil::randomLocalDateTime, Value::asLocalDateTime);
    }

    @Test
    void shouldSendAndReceiveListsWithRandomLocalDateTimes() {
        TemporalTypesIT.testSendAndReceiveRandomLists(TemporalUtil::randomLocalDateTime);
    }

    @Test
    void shouldSendDateTimeWithZoneOffset() {
        ZoneOffset offset = ZoneOffset.ofHoursMinutes(-4, -15);
        TemporalTypesIT.testSendValue(ZonedDateTime.of(1845, 3, 25, 19, 15, 45, 22, offset), Value::asZonedDateTime);
    }

    @Test
    void shouldReceiveDateTimeWithZoneOffset() {
        ZoneOffset offset = ZoneOffset.ofHoursMinutes(3, 30);
        TemporalTypesIT.testReceiveValue("RETURN datetime({year:1984, month:10, day:11, hour:21, minute:30, second:34, timezone:'+03:30'})", ZonedDateTime.of(1984, 10, 11, 21, 30, 34, 0, offset), Value::asZonedDateTime);
    }

    @Test
    void shouldSendAndReceiveDateTimeWithZoneOffset() {
        ZoneOffset offset = ZoneOffset.ofHoursMinutes(-7, -15);
        TemporalTypesIT.testSendAndReceiveValue(ZonedDateTime.of(2017, 3, 9, 11, 12, 13, 14, offset), Value::asZonedDateTime);
    }

    @Test
    void shouldSendAndReceiveRandomDateTimeWithZoneOffset() {
        TemporalTypesIT.testSendAndReceiveRandomValues(TemporalUtil::randomZonedDateTimeWithOffset, Value::asZonedDateTime);
    }

    @Test
    void shouldSendAndReceiveListsWithRandomDateTimeWithZoneOffsets() {
        TemporalTypesIT.testSendAndReceiveRandomLists(TemporalUtil::randomZonedDateTimeWithOffset);
    }

    @Test
    void shouldSendDateTimeRepresentedWithOffsetDateTime() {
        TemporalTypesIT.testSendValue(OffsetDateTime.of(1851, 9, 29, 1, 29, 42, 987, ZoneOffset.ofHours(-8)), Value::asOffsetDateTime);
    }

    @Test
    void shouldReceiveDateTimeRepresentedWithOffsetDateTime() {
        TemporalTypesIT.testReceiveValue("RETURN datetime({year:2121, month:1, day:1, hour:2, minute:2, second:2, timezone:'-07:20'})", OffsetDateTime.of(2121, 1, 1, 2, 2, 2, 0, ZoneOffset.ofHoursMinutes(-7, -20)), Value::asOffsetDateTime);
    }

    @Test
    void shouldSendAndReceiveDateTimeRepresentedWithOffsetDateTime() {
        TemporalTypesIT.testSendAndReceiveValue(OffsetDateTime.of(1998, 12, 12, 23, 54, 14, 123, ZoneOffset.ofHoursMinutes(1, 15)), Value::asOffsetDateTime);
    }

    @Test
    void shouldSendAndReceiveRandomDateTimeRepresentedWithOffsetDateTime() {
        TemporalTypesIT.testSendAndReceiveRandomValues(TemporalUtil::randomOffsetDateTime, Value::asOffsetDateTime);
    }

    @Test
    void shouldSendAndReceiveListsWithRandomDateTimeRepresentedWithOffsetDateTimes() {
        TemporalTypesIT.testSendAndReceiveRandomLists(TemporalUtil::randomOffsetDateTime, value -> value.asList(Values.ofOffsetDateTime()));
    }

    @Test
    void shouldSendDateTimeWithZoneId() {
        ZoneId zoneId = ZoneId.of("Europe/Stockholm");
        TemporalTypesIT.testSendValue(ZonedDateTime.of(2049, 9, 11, 19, 10, 40, 20, zoneId), Value::asZonedDateTime);
    }

    @Test
    void shouldReceiveDateTimeWithZoneId() {
        ZoneId zoneId = ZoneId.of("Europe/London");
        TemporalTypesIT.testReceiveValue("RETURN datetime({year:2000, month:1, day:1, hour:9, minute:5, second:1, timezone:'Europe/London'})", ZonedDateTime.of(2000, 1, 1, 9, 5, 1, 0, zoneId), Value::asZonedDateTime);
    }

    @Test
    void shouldSendAndReceiveDateTimeWithZoneId() {
        ZoneId zoneId = ZoneId.of("Europe/Stockholm");
        TemporalTypesIT.testSendAndReceiveValue(ZonedDateTime.of(2099, 12, 29, 12, 59, 59, 59, zoneId), Value::asZonedDateTime);
    }

    @Test
    void shouldSendAndReceiveRandomDateTimeWithZoneId() {
        TemporalTypesIT.testSendAndReceiveRandomValues(TemporalUtil::randomZonedDateTimeWithZoneId, Value::asZonedDateTime);
    }

    @Test
    void shouldSendAndReceiveListsWithRandomDateTimeWithZoneIds() {
        TemporalTypesIT.testSendAndReceiveRandomLists(TemporalUtil::randomZonedDateTimeWithZoneId);
    }

    @Test
    void shouldSendDuration() {
        TemporalTypesIT.testSendValue(TemporalTypesIT.newDuration(8L, 12L, 90L, 8), Value::asIsoDuration);
    }

    @Test
    void shouldReceiveDuration() {
        TemporalTypesIT.testReceiveValue("RETURN duration({months: 13, days: 40, seconds: 12, nanoseconds: 999})", TemporalTypesIT.newDuration(13L, 40L, 12L, 999), Value::asIsoDuration);
    }

    @Test
    void shouldSendAndReceiveDuration() {
        TemporalTypesIT.testSendAndReceiveValue(TemporalTypesIT.newDuration(7L, 7L, 88L, 999999), Value::asIsoDuration);
    }

    @Test
    void shouldSendAndReceiveRandomDuration() {
        TemporalTypesIT.testSendAndReceiveRandomValues(TemporalUtil::randomDuration, Value::asIsoDuration);
    }

    @Test
    void shouldSendAndReceiveListsWithRandomDurations() {
        TemporalTypesIT.testSendAndReceiveRandomLists(TemporalUtil::randomDuration);
    }

    @Test
    void shouldFormatDurationToString() {
        TemporalTypesIT.testDurationToString(1L, 0, "P0M0DT1S");
        TemporalTypesIT.testDurationToString(-1L, 0, "P0M0DT-1S");
        TemporalTypesIT.testDurationToString(0L, 5, "P0M0DT0.000000005S");
        TemporalTypesIT.testDurationToString(0L, -5, "P0M0DT-0.000000005S");
        TemporalTypesIT.testDurationToString(0L, 999999999, "P0M0DT0.999999999S");
        TemporalTypesIT.testDurationToString(0L, -999999999, "P0M0DT-0.999999999S");
        TemporalTypesIT.testDurationToString(1L, 5, "P0M0DT1.000000005S");
        TemporalTypesIT.testDurationToString(-1L, -5, "P0M0DT-1.000000005S");
        TemporalTypesIT.testDurationToString(1L, -5, "P0M0DT0.999999995S");
        TemporalTypesIT.testDurationToString(-1L, 5, "P0M0DT-0.999999995S");
        TemporalTypesIT.testDurationToString(1L, 999999999, "P0M0DT1.999999999S");
        TemporalTypesIT.testDurationToString(-1L, -999999999, "P0M0DT-1.999999999S");
        TemporalTypesIT.testDurationToString(1L, -999999999, "P0M0DT0.000000001S");
        TemporalTypesIT.testDurationToString(-1L, 999999999, "P0M0DT-0.000000001S");
        TemporalTypesIT.testDurationToString(-78036L, -143000000, "P0M0DT-78036.143000000S");
        TemporalTypesIT.testDurationToString(0L, 1000000000, "P0M0DT1S");
        TemporalTypesIT.testDurationToString(0L, -1000000000, "P0M0DT-1S");
        TemporalTypesIT.testDurationToString(0L, 1000000007, "P0M0DT1.000000007S");
        TemporalTypesIT.testDurationToString(0L, -1000000007, "P0M0DT-1.000000007S");
        TemporalTypesIT.testDurationToString(40L, 2123456789, "P0M0DT42.123456789S");
        TemporalTypesIT.testDurationToString(-40L, 2123456789, "P0M0DT-37.876543211S");
        TemporalTypesIT.testDurationToString(40L, -2123456789, "P0M0DT37.876543211S");
        TemporalTypesIT.testDurationToString(-40L, -2123456789, "P0M0DT-42.123456789S");
    }

    private static <T> void testSendAndReceiveRandomValues(Supplier<T> valueSupplier, Function<Value, T> converter) {
        for (int i = 0; i < 1000; ++i) {
            TemporalTypesIT.testSendAndReceiveValue(valueSupplier.get(), converter);
        }
    }

    private static <T> void testSendAndReceiveRandomLists(Supplier<T> valueSupplier) {
        TemporalTypesIT.testSendAndReceiveRandomLists(valueSupplier::get, Value::asList);
    }

    private static <T> void testSendAndReceiveRandomLists(Supplier<T> valueSupplier, Function<Value, List<T>> converter) {
        for (int i = 0; i < 100; ++i) {
            int listSize = ThreadLocalRandom.current().nextInt(100, 1000);
            List list = Stream.generate(valueSupplier).limit(listSize).collect(Collectors.toList());
            TemporalTypesIT.testSendAndReceiveValue(list, converter);
        }
    }

    private static <T> void testSendValue(T value, Function<Value, T> converter) {
        Record record1 = session.run("CREATE (n:Node {value: $value}) RETURN 42", Collections.singletonMap("value", value)).single();
        Assertions.assertEquals((int)42, (int)record1.get(0).asInt());
        Record record2 = session.run("MATCH (n:Node) RETURN n.value").single();
        Assertions.assertEquals(value, converter.apply(record2.get(0)));
    }

    private static <T> void testReceiveValue(String query, T expectedValue, Function<Value, T> converter) {
        Record record = session.run(query).single();
        Assertions.assertEquals(expectedValue, converter.apply(record.get(0)));
    }

    private static <T> void testSendAndReceiveValue(T value, Function<Value, T> converter) {
        Record record = session.run("CREATE (n:Node {value: $value}) RETURN n.value", Collections.singletonMap("value", value)).single();
        Assertions.assertEquals(value, converter.apply(record.get(0)));
    }

    private static void testDurationToString(long seconds, int nanoseconds, String expectedValue) {
        Result result = session.run("RETURN duration({seconds: $s, nanoseconds: $n})", Values.parameters((Object[])new Object[]{"s", seconds, "n", nanoseconds}));
        IsoDuration duration = result.single().get(0).asIsoDuration();
        Assertions.assertEquals((Object)expectedValue, (Object)duration.toString());
    }

    private static IsoDuration newDuration(long months, long days, long seconds, int nanoseconds) {
        return Values.isoDuration((long)months, (long)days, (long)seconds, (int)nanoseconds).asIsoDuration();
    }
}

