/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.integration;

import io.netty.channel.Channel;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.junit.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.neo4j.driver.Config;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Record;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.neo4j.driver.Transaction;
import org.neo4j.driver.Value;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.exceptions.ServiceUnavailableException;
import org.neo4j.driver.internal.cluster.RoutingSettings;
import org.neo4j.driver.internal.logging.DevNullLogging;
import org.neo4j.driver.internal.retry.RetrySettings;
import org.neo4j.driver.internal.security.SecurityPlanImpl;
import org.neo4j.driver.internal.util.Clock;
import org.neo4j.driver.internal.util.io.ChannelTrackingDriverFactory;
import org.neo4j.driver.util.ParallelizableIT;
import org.neo4j.driver.util.SessionExtension;
import org.neo4j.driver.util.TestUtil;

@ParallelizableIT
class TransactionIT {
    @RegisterExtension
    static final SessionExtension session = new SessionExtension();

    TransactionIT() {
    }

    @Test
    void shouldAllowRunRollbackAndClose() {
        this.shouldRunAndCloseAfterAction(Transaction::rollback, false);
    }

    @Test
    void shouldAllowRunCommitAndClose() {
        this.shouldRunAndCloseAfterAction(Transaction::commit, true);
    }

    @Test
    void shouldAllowRunCloseAndClose() {
        this.shouldRunAndCloseAfterAction(Transaction::close, false);
    }

    @Test
    void shouldRunAndRollbackByDefault() {
        try (Transaction tx = session.beginTransaction();){
            tx.run("CREATE (n:FirstNode)");
            tx.run("CREATE (n:SecondNode)");
        }
        Result cursor = session.run("MATCH (n) RETURN count(n)");
        long nodes = cursor.single().get("count(n)").asLong();
        MatcherAssert.assertThat((Object)nodes, (Matcher)CoreMatchers.equalTo((Object)0L));
    }

    @Test
    void shouldRetrieveResults() {
        session.run("CREATE (n {name:'Steve Brook'})");
        try (Transaction tx = session.beginTransaction();){
            Result res = tx.run("MATCH (n) RETURN n.name");
            MatcherAssert.assertThat((Object)res.single().get("n.name").asString(), (Matcher)CoreMatchers.equalTo((Object)"Steve Brook"));
        }
    }

    @Test
    void shouldNotAllowSessionLevelQueriesWhenThereIsATransaction() {
        session.beginTransaction();
        Assertions.assertThrows(ClientException.class, () -> session.run("anything"));
    }

    @Test
    void shouldFailToRunQueryAfterTxIsCommitted() {
        this.shouldFailToRunQueryAfterTxAction(Transaction::commit);
    }

    @Test
    void shouldFailToRunQueryAfterTxIsRolledBack() {
        this.shouldFailToRunQueryAfterTxAction(Transaction::rollback);
    }

    @Test
    void shouldFailToRunQueryAfterTxIsClosed() {
        this.shouldFailToRunQueryAfterTxAction(Transaction::close);
    }

    @Test
    void shouldFailToCommitAfterRolledBack() {
        Transaction tx = session.beginTransaction();
        tx.run("CREATE (:MyLabel)");
        tx.rollback();
        ClientException e = (ClientException)Assertions.assertThrows(ClientException.class, () -> ((Transaction)tx).commit());
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.startsWith((String)"Can't commit, transaction has been rolled back"));
    }

    @Test
    void shouldFailToRollbackAfterTxIsCommitted() {
        Transaction tx = session.beginTransaction();
        tx.run("CREATE (:MyLabel)");
        tx.commit();
        ClientException e = (ClientException)Assertions.assertThrows(ClientException.class, () -> ((Transaction)tx).rollback());
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.startsWith((String)"Can't rollback, transaction has been committed"));
    }

    @Test
    void shouldFailToCommitAfterCommit() throws Throwable {
        Transaction tx = session.beginTransaction();
        tx.run("CREATE (:MyLabel)");
        tx.commit();
        ClientException e = (ClientException)Assertions.assertThrows(ClientException.class, () -> ((Transaction)tx).commit());
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.startsWith((String)"Can't commit, transaction has been committed"));
    }

    @Test
    void shouldFailToRollbackAfterRollback() throws Throwable {
        Transaction tx = session.beginTransaction();
        tx.run("CREATE (:MyLabel)");
        tx.rollback();
        ClientException e = (ClientException)Assertions.assertThrows(ClientException.class, () -> ((Transaction)tx).rollback());
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.startsWith((String)"Can't rollback, transaction has been rolled back"));
    }

    @Test
    void shouldBeClosedAfterClose() {
        this.shouldBeClosedAfterAction(Transaction::close);
    }

    @Test
    void shouldBeClosedAfterRollback() {
        this.shouldBeClosedAfterAction(Transaction::rollback);
    }

    @Test
    void shouldBeClosedAfterCommit() {
        this.shouldBeClosedAfterAction(Transaction::commit);
    }

    @Test
    void shouldBeOpenBeforeCommit() {
        Transaction tx = session.beginTransaction();
        Assertions.assertTrue((boolean)tx.isOpen());
    }

    @Test
    void shouldHandleNullParametersGracefully() {
        session.run("match (n) return count(n)", (Value)null);
    }

    @Test
    void shouldHandleFailureAfterClosingTransaction() {
        Transaction tx = session.beginTransaction();
        Result result = tx.run("CREATE (n) RETURN n");
        result.consume();
        tx.commit();
        tx.close();
        Assertions.assertThrows(ClientException.class, () -> session.run("CREAT (n) RETURN n").consume());
    }

    @Test
    void shouldHandleNullRecordParameters() {
        try (Transaction tx = session.beginTransaction();){
            Record params = null;
            tx.run("CREATE (n:FirstNode)", params);
            tx.commit();
        }
    }

    @Test
    void shouldHandleNullValueParameters() {
        try (Transaction tx = session.beginTransaction();){
            Value params = null;
            tx.run("CREATE (n:FirstNode)", params);
            tx.commit();
        }
    }

    @Test
    void shouldHandleNullMapParameters() {
        try (Transaction tx = session.beginTransaction();){
            Map params = null;
            tx.run("CREATE (n:FirstNode)", params);
            tx.commit();
        }
    }

    @Test
    void shouldRollbackTransactionAfterFailedRunAndCommitAndSessionShouldSuccessfullyBeginNewTransaction() {
        Transaction tx = session.beginTransaction();
        Assertions.assertThrows(ClientException.class, () -> tx.run("invalid"));
        ClientException e = (ClientException)Assertions.assertThrows(ClientException.class, () -> ((Transaction)tx).commit());
        TestUtil.assertNoCircularReferences(e);
        try (Transaction anotherTx = session.beginTransaction();){
            Result cursor = anotherTx.run("RETURN 1");
            int val = cursor.single().get("1").asInt();
            MatcherAssert.assertThat((Object)val, (Matcher)CoreMatchers.equalTo((Object)1));
        }
    }

    @Test
    void shouldRollBackTxIfErrorWithConsume() {
        Assertions.assertThrows(ClientException.class, () -> {
            try (Transaction tx = session.beginTransaction();){
                Result result = tx.run("invalid");
                result.consume();
            }
        });
        try (Transaction tx = session.beginTransaction();){
            Result cursor = tx.run("RETURN 1");
            int val = cursor.single().get("1").asInt();
            MatcherAssert.assertThat((Object)val, (Matcher)CoreMatchers.equalTo((Object)1));
        }
    }

    @Test
    void shouldFailRun() {
        try (Transaction tx = session.beginTransaction();){
            ClientException e = (ClientException)Assertions.assertThrows(ClientException.class, () -> tx.run("RETURN Wrong"));
            MatcherAssert.assertThat((Object)e.code(), (Matcher)CoreMatchers.containsString((String)"SyntaxError"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldBeResponsiveToThreadInterruptWhenWaitingForResult() {
        try (Session otherSession = session.driver().session();){
            session.run("CREATE (:Person {name: 'Beta Ray Bill'})").consume();
            Transaction tx1 = session.beginTransaction();
            Transaction tx2 = otherSession.beginTransaction();
            tx1.run("MATCH (n:Person {name: 'Beta Ray Bill'}) SET n.hammer = 'Mjolnir'").consume();
            TestUtil.interruptWhenInWaitingState(Thread.currentThread());
            try {
                ServiceUnavailableException e = (ServiceUnavailableException)Assertions.assertThrows(ServiceUnavailableException.class, () -> tx2.run("MATCH (n:Person {name: 'Beta Ray Bill'}) SET n.hammer = 'Stormbreaker'").consume());
                MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Connection to the database terminated"));
                MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Thread interrupted while running query in transaction"));
            }
            finally {
                Thread.interrupted();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldBeResponsiveToThreadInterruptWhenWaitingForCommit() {
        try (Session otherSession = session.driver().session();){
            session.run("CREATE (:Person {name: 'Beta Ray Bill'})").consume();
            Transaction tx1 = session.beginTransaction();
            Transaction tx2 = otherSession.beginTransaction();
            tx1.run("MATCH (n:Person {name: 'Beta Ray Bill'}) SET n.hammer = 'Mjolnir'").consume();
            TestUtil.interruptWhenInWaitingState(Thread.currentThread());
            try {
                Assertions.assertThrows(ServiceUnavailableException.class, () -> tx2.run("MATCH (n:Person {name: 'Beta Ray Bill'}) SET n.hammer = 'Stormbreaker'"));
            }
            finally {
                Thread.interrupted();
            }
        }
    }

    @Test
    void shouldThrowWhenConnectionKilledDuringTransaction() {
        ChannelTrackingDriverFactory factory = new ChannelTrackingDriverFactory(1, Clock.SYSTEM);
        Config config = Config.builder().withLogging(DevNullLogging.DEV_NULL_LOGGING).build();
        try (Driver driver = factory.newInstance(session.uri(), session.authToken(), RoutingSettings.DEFAULT, RetrySettings.DEFAULT, config, SecurityPlanImpl.insecure());){
            ServiceUnavailableException e = (ServiceUnavailableException)Assertions.assertThrows(ServiceUnavailableException.class, () -> {
                try (Session session1 = driver.session();
                     Transaction tx = session1.beginTransaction();){
                    tx.run("CREATE (:MyNode {id: 1})").consume();
                    for (Channel channel : factory.channels()) {
                        channel.close().syncUninterruptibly();
                    }
                    tx.run("CREATE (:MyNode {id: 1})").consume();
                }
            });
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Connection to the database terminated"));
        }
        Assertions.assertEquals((int)0, (int)session.run("MATCH (n:MyNode {id: 1}) RETURN count(n)").single().get(0).asInt());
    }

    @Test
    void shouldFailToCommitAfterFailure() throws Throwable {
        try (Transaction tx = session.beginTransaction();){
            List xs = tx.run("UNWIND [1,2,3] AS x CREATE (:Node) RETURN x").list(record -> record.get(0).asInt());
            Assertions.assertEquals(Arrays.asList(1, 2, 3), (Object)xs);
            ClientException error1 = (ClientException)Assertions.assertThrows(ClientException.class, () -> tx.run("RETURN unknown").consume());
            MatcherAssert.assertThat((Object)error1.code(), (Matcher)CoreMatchers.containsString((String)"SyntaxError"));
            ClientException error2 = (ClientException)Assertions.assertThrows(ClientException.class, () -> ((Transaction)tx).commit());
            MatcherAssert.assertThat((Object)error2.getMessage(), (Matcher)Matchers.startsWith((String)"Transaction can't be committed. It has been rolled back"));
        }
    }

    @Test
    void shouldDisallowQueriesAfterFailureWhenResultsAreConsumed() {
        try (Transaction tx = session.beginTransaction();){
            List xs = tx.run("UNWIND [1,2,3] AS x CREATE (:Node) RETURN x").list(record -> record.get(0).asInt());
            Assertions.assertEquals(Arrays.asList(1, 2, 3), (Object)xs);
            ClientException error1 = (ClientException)Assertions.assertThrows(ClientException.class, () -> tx.run("RETURN unknown").consume());
            MatcherAssert.assertThat((Object)error1.code(), (Matcher)CoreMatchers.containsString((String)"SyntaxError"));
            ClientException error2 = (ClientException)Assertions.assertThrows(ClientException.class, () -> tx.run("CREATE (:OtherNode)").consume());
            MatcherAssert.assertThat((Object)error2.getMessage(), (Matcher)Matchers.startsWith((String)"Cannot run more queries in this transaction"));
            ClientException error3 = (ClientException)Assertions.assertThrows(ClientException.class, () -> tx.run("RETURN 42").consume());
            MatcherAssert.assertThat((Object)error3.getMessage(), (Matcher)Matchers.startsWith((String)"Cannot run more queries in this transaction"));
        }
        Assertions.assertEquals((int)0, (int)TransactionIT.countNodesByLabel("Node"));
        Assertions.assertEquals((int)0, (int)TransactionIT.countNodesByLabel("OtherNode"));
    }

    @Test
    void shouldRollbackWhenOneOfQueriesFails() {
        ClientException error = (ClientException)Assertions.assertThrows(ClientException.class, () -> {
            try (Transaction tx = session.beginTransaction();){
                tx.run("CREATE (:Node1)");
                tx.run("CREATE (:Node2)");
                tx.run("CREATE SmthStrange");
            }
        });
        MatcherAssert.assertThat((Object)error.code(), (Matcher)CoreMatchers.containsString((String)"SyntaxError"));
        Assertions.assertEquals((int)0, (int)TransactionIT.countNodesByLabel("Node1"));
        Assertions.assertEquals((int)0, (int)TransactionIT.countNodesByLabel("Node2"));
        Assertions.assertEquals((int)0, (int)TransactionIT.countNodesByLabel("Node3"));
        Assertions.assertEquals((int)0, (int)TransactionIT.countNodesByLabel("Node4"));
    }

    private void shouldRunAndCloseAfterAction(Consumer<Transaction> txConsumer, boolean isCommit) {
        try (Transaction tx = session.beginTransaction();){
            tx.run("CREATE (n:FirstNode)");
            tx.run("CREATE (n:SecondNode)");
            txConsumer.accept(tx);
        }
        Result result = session.run("MATCH (n) RETURN count(n)");
        long nodes = result.single().get("count(n)").asLong();
        if (isCommit) {
            MatcherAssert.assertThat((Object)nodes, (Matcher)CoreMatchers.equalTo((Object)2L));
        } else {
            MatcherAssert.assertThat((Object)nodes, (Matcher)CoreMatchers.equalTo((Object)0L));
        }
    }

    private void shouldBeClosedAfterAction(Consumer<Transaction> txConsumer) {
        Transaction tx = session.beginTransaction();
        txConsumer.accept(tx);
        Assertions.assertFalse((boolean)tx.isOpen());
    }

    private void shouldFailToRunQueryAfterTxAction(Consumer<Transaction> txConsumer) {
        Transaction tx = session.beginTransaction();
        tx.run("CREATE (:MyLabel)");
        txConsumer.accept(tx);
        ClientException e = (ClientException)Assertions.assertThrows(ClientException.class, () -> tx.run("CREATE (:MyOtherLabel)"));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.startsWith((String)"Cannot run more queries in this transaction"));
    }

    private static int countNodesByLabel(String label) {
        return session.run("MATCH (n:" + label + ") RETURN count(n)").single().get(0).asInt();
    }
}

