/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.integration.reactive;

import java.util.Collections;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.neo4j.driver.exceptions.TransactionNestingException;
import org.neo4j.driver.internal.util.EnabledOnNeo4jWith;
import org.neo4j.driver.internal.util.Neo4jFeature;
import org.neo4j.driver.reactive.RxResult;
import org.neo4j.driver.reactive.RxSession;
import org.neo4j.driver.reactive.RxTransaction;
import org.neo4j.driver.util.DatabaseExtension;
import org.neo4j.driver.util.ParallelizableIT;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.test.StepVerifier;

@EnabledOnNeo4jWith(value=Neo4jFeature.BOLT_V4)
@ParallelizableIT
class RxNestedQueriesIT {
    @RegisterExtension
    static final DatabaseExtension neo4j = new DatabaseExtension();

    RxNestedQueriesIT() {
    }

    @Test
    void shouldErrorForNestingQueriesAmongSessionRuns() {
        int size = 12555;
        Flux nodeIds = Flux.usingWhen((Publisher)Mono.fromSupplier(() -> neo4j.driver().rxSession()), session -> Flux.from((Publisher)session.run("UNWIND range(1, $size) AS x RETURN x", Collections.singletonMap("size", size)).records()).limitRate(20).flatMap(record -> {
            int x = record.get("x").asInt();
            RxResult innerResult = session.run("CREATE (n:Node {id: $x}) RETURN n.id", Collections.singletonMap("x", x));
            return innerResult.records();
        }).map(r -> r.get(0).asInt()), RxSession::close);
        StepVerifier.create((Publisher)nodeIds).expectError(TransactionNestingException.class).verify();
    }

    @Test
    void shouldErrorForNestingQueriesAmongTransactionFunctions() {
        int size = 12555;
        Flux nodeIds = Flux.usingWhen((Publisher)Mono.fromSupplier(() -> neo4j.driver().rxSession()), session -> Flux.from((Publisher)session.readTransaction(tx -> tx.run("UNWIND range(1, $size) AS x RETURN x", Collections.singletonMap("size", size)).records())).limitRate(20).flatMap(record -> {
            int x = record.get("x").asInt();
            return session.writeTransaction(tx -> tx.run("CREATE (n:Node {id: $x}) RETURN n.id", Collections.singletonMap("x", x)).records());
        }).map(r -> r.get(0).asInt()), RxSession::close);
        StepVerifier.create((Publisher)nodeIds).expectError(TransactionNestingException.class).verify();
    }

    @Test
    void shouldErrorForNestingQueriesAmongSessionRunAndTransactionFunction() {
        int size = 12555;
        Flux nodeIds = Flux.usingWhen((Publisher)Mono.fromSupplier(() -> neo4j.driver().rxSession()), session -> Flux.from((Publisher)session.run("UNWIND range(1, $size) AS x RETURN x", Collections.singletonMap("size", size)).records()).limitRate(20).flatMap(record -> {
            int x = record.get("x").asInt();
            return session.writeTransaction(tx -> tx.run("CREATE (n:Node {id: $x}) RETURN n.id", Collections.singletonMap("x", x)).records());
        }).map(r -> r.get(0).asInt()), RxSession::close);
        StepVerifier.create((Publisher)nodeIds).expectError(TransactionNestingException.class).verify();
    }

    @Test
    void shouldErrorForNestingQueriesAmongTransactionFunctionAndSessionRun() {
        int size = 12555;
        Flux nodeIds = Flux.usingWhen((Publisher)Mono.fromSupplier(() -> neo4j.driver().rxSession()), session -> Flux.from((Publisher)session.readTransaction(tx -> tx.run("UNWIND range(1, $size) AS x RETURN x", Collections.singletonMap("size", size)).records())).limitRate(20).flatMap(record -> {
            int x = record.get("x").asInt();
            return session.run("CREATE (n:Node {id: $x}) RETURN n.id", Collections.singletonMap("x", x)).records();
        }).map(r -> r.get(0).asInt()), RxSession::close);
        StepVerifier.create((Publisher)nodeIds).expectError(TransactionNestingException.class).verify();
    }

    @Test
    void shouldHandleNestedQueriesInTheSameTransaction() throws Throwable {
        int size = 12555;
        RxSession session = neo4j.driver().rxSession();
        Flux nodeIds = Flux.usingWhen((Publisher)session.beginTransaction(), tx -> {
            RxResult result = tx.run("UNWIND range(1, $size) AS x RETURN x", Collections.singletonMap("size", size));
            return Flux.from((Publisher)result.records()).limitRate(20).flatMap(record -> {
                int x = record.get("x").asInt();
                RxResult innerResult = tx.run("CREATE (n:Node {id: $x}) RETURN n.id", Collections.singletonMap("x", x));
                return innerResult.records();
            }).map(record -> record.get(0).asInt());
        }, RxTransaction::commit, (tx, error) -> tx.rollback(), null);
        StepVerifier.create((Publisher)nodeIds).expectNextCount((long)size).verifyComplete();
    }
}

