/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.internal.DefaultBookmarkHolder;
import org.neo4j.driver.internal.InternalBookmark;

class DefaultBookmarkHolderTest {
    DefaultBookmarkHolderTest() {
    }

    @Test
    void shouldAllowToGetAndSetBookmarks() {
        DefaultBookmarkHolder bookmarkHolder = new DefaultBookmarkHolder();
        Assertions.assertEquals((Object)InternalBookmark.empty(), (Object)bookmarkHolder.getBookmark());
        bookmarkHolder.setBookmark(null);
        Assertions.assertEquals((Object)InternalBookmark.empty(), (Object)bookmarkHolder.getBookmark());
        bookmarkHolder.setBookmark(InternalBookmark.empty());
        Assertions.assertEquals((Object)InternalBookmark.empty(), (Object)bookmarkHolder.getBookmark());
        Bookmark bookmark1 = InternalBookmark.parse((String)"neo4j:bookmark:v1:tx1");
        bookmarkHolder.setBookmark(bookmark1);
        Assertions.assertEquals((Object)bookmark1, (Object)bookmarkHolder.getBookmark());
        bookmarkHolder.setBookmark(null);
        Assertions.assertEquals((Object)bookmark1, (Object)bookmarkHolder.getBookmark());
        bookmarkHolder.setBookmark(InternalBookmark.empty());
        Assertions.assertEquals((Object)bookmark1, (Object)bookmarkHolder.getBookmark());
        Bookmark bookmark2 = InternalBookmark.parse((String)"neo4j:bookmark:v1:tx2");
        bookmarkHolder.setBookmark(bookmark2);
        Assertions.assertEquals((Object)bookmark2, (Object)bookmarkHolder.getBookmark());
        Bookmark bookmark3 = InternalBookmark.parse((String)"neo4j:bookmark:v1:tx42");
        bookmarkHolder.setBookmark(bookmark3);
        Assertions.assertEquals((Object)bookmark3, (Object)bookmarkHolder.getBookmark());
    }

    @Test
    void bookmarkCanBeSet() {
        DefaultBookmarkHolder bookmarkHolder = new DefaultBookmarkHolder();
        Bookmark bookmark = InternalBookmark.parse((String)"neo4j:bookmark:v1:tx100");
        bookmarkHolder.setBookmark(bookmark);
        Assertions.assertEquals((Object)bookmark, (Object)bookmarkHolder.getBookmark());
    }

    @Test
    void shouldNotOverwriteBookmarkWithNull() {
        Bookmark initBookmark = InternalBookmark.parse((String)"Cat");
        DefaultBookmarkHolder bookmarkHolder = new DefaultBookmarkHolder(initBookmark);
        Assertions.assertEquals((Object)initBookmark, (Object)bookmarkHolder.getBookmark());
        bookmarkHolder.setBookmark(null);
        Assertions.assertEquals((Object)initBookmark, (Object)bookmarkHolder.getBookmark());
    }

    @Test
    void shouldNotOverwriteBookmarkWithEmptyBookmark() {
        Bookmark initBookmark = InternalBookmark.parse((String)"Cat");
        DefaultBookmarkHolder bookmarkHolder = new DefaultBookmarkHolder(initBookmark);
        Assertions.assertEquals((Object)initBookmark, (Object)bookmarkHolder.getBookmark());
        bookmarkHolder.setBookmark(InternalBookmark.empty());
        Assertions.assertEquals((Object)initBookmark, (Object)bookmarkHolder.getBookmark());
    }
}

