/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.junit.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.DatabaseNameUtil;
import org.neo4j.driver.internal.DirectConnectionProvider;
import org.neo4j.driver.internal.async.ConnectionContext;
import org.neo4j.driver.internal.async.connection.DirectConnection;
import org.neo4j.driver.internal.cluster.RediscoveryUtil;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.spi.ConnectionPool;
import org.neo4j.driver.util.TestUtil;

class DirectConnectionProviderTest {
    DirectConnectionProviderTest() {
    }

    @Test
    void acquiresConnectionsFromThePool() {
        BoltServerAddress address = BoltServerAddress.LOCAL_DEFAULT;
        Connection connection1 = (Connection)Mockito.mock(Connection.class);
        Connection connection2 = (Connection)Mockito.mock(Connection.class);
        ConnectionPool pool = DirectConnectionProviderTest.poolMock(address, connection1, connection2);
        DirectConnectionProvider provider = new DirectConnectionProvider(address, pool);
        Connection acquired1 = (Connection)TestUtil.await(provider.acquireConnection(RediscoveryUtil.contextWithMode(AccessMode.READ)));
        MatcherAssert.assertThat((Object)acquired1, (Matcher)Matchers.instanceOf(DirectConnection.class));
        Assertions.assertSame((Object)connection1, (Object)((DirectConnection)acquired1).connection());
        Connection acquired2 = (Connection)TestUtil.await(provider.acquireConnection(RediscoveryUtil.contextWithMode(AccessMode.WRITE)));
        MatcherAssert.assertThat((Object)acquired2, (Matcher)Matchers.instanceOf(DirectConnection.class));
        Assertions.assertSame((Object)connection2, (Object)((DirectConnection)acquired2).connection());
    }

    @ParameterizedTest
    @EnumSource(value=AccessMode.class)
    void returnsCorrectAccessMode(AccessMode mode) {
        BoltServerAddress address = BoltServerAddress.LOCAL_DEFAULT;
        ConnectionPool pool = DirectConnectionProviderTest.poolMock(address, (Connection)Mockito.mock(Connection.class), new Connection[0]);
        DirectConnectionProvider provider = new DirectConnectionProvider(address, pool);
        Connection acquired = (Connection)TestUtil.await(provider.acquireConnection(RediscoveryUtil.contextWithMode(mode)));
        Assertions.assertEquals((Object)mode, (Object)acquired.mode());
    }

    @Test
    void closesPool() {
        BoltServerAddress address = BoltServerAddress.LOCAL_DEFAULT;
        ConnectionPool pool = DirectConnectionProviderTest.poolMock(address, (Connection)Mockito.mock(Connection.class), new Connection[0]);
        DirectConnectionProvider provider = new DirectConnectionProvider(address, pool);
        provider.close();
        ((ConnectionPool)Mockito.verify((Object)pool)).close();
    }

    @Test
    void returnsCorrectAddress() {
        BoltServerAddress address = new BoltServerAddress("server-1", 25000);
        DirectConnectionProvider provider = new DirectConnectionProvider(address, (ConnectionPool)Mockito.mock(ConnectionPool.class));
        Assertions.assertEquals((Object)address, (Object)provider.getAddress());
    }

    @Test
    void shouldIgnoreDatabaseNameAndAccessModeWhenObtainConnectionFromPool() throws Throwable {
        BoltServerAddress address = BoltServerAddress.LOCAL_DEFAULT;
        Connection connection = (Connection)Mockito.mock(Connection.class);
        ConnectionPool pool = DirectConnectionProviderTest.poolMock(address, connection, new Connection[0]);
        DirectConnectionProvider provider = new DirectConnectionProvider(address, pool);
        Connection acquired1 = (Connection)TestUtil.await(provider.acquireConnection(RediscoveryUtil.contextWithMode(AccessMode.READ)));
        MatcherAssert.assertThat((Object)acquired1, (Matcher)Matchers.instanceOf(DirectConnection.class));
        Assertions.assertSame((Object)connection, (Object)((DirectConnection)acquired1).connection());
        ((ConnectionPool)Mockito.verify((Object)pool)).acquire(address);
    }

    @ParameterizedTest
    @ValueSource(strings={"", "foo", "data"})
    void shouldObtainDatabaseNameOnConnection(String databaseName) throws Throwable {
        BoltServerAddress address = BoltServerAddress.LOCAL_DEFAULT;
        ConnectionPool pool = DirectConnectionProviderTest.poolMock(address, (Connection)Mockito.mock(Connection.class), new Connection[0]);
        DirectConnectionProvider provider = new DirectConnectionProvider(address, pool);
        Connection acquired = (Connection)TestUtil.await(provider.acquireConnection(RediscoveryUtil.contextWithDatabase(databaseName)));
        Assertions.assertEquals((Object)databaseName, (Object)acquired.databaseName().description());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void ensuresCompletedDatabaseNameBeforeAccessingValue(boolean completed) {
        BoltServerAddress address = BoltServerAddress.LOCAL_DEFAULT;
        ConnectionPool pool = DirectConnectionProviderTest.poolMock(address, (Connection)Mockito.mock(Connection.class), new Connection[0]);
        DirectConnectionProvider provider = new DirectConnectionProvider(address, pool);
        ConnectionContext context = (ConnectionContext)Mockito.mock(ConnectionContext.class);
        CompletableFuture databaseNameFuture = (CompletableFuture)Mockito.spy(completed ? CompletableFuture.completedFuture(DatabaseNameUtil.systemDatabase()) : new CompletableFuture());
        Mockito.when((Object)context.databaseNameFuture()).thenReturn((Object)databaseNameFuture);
        Mockito.when((Object)context.mode()).thenReturn((Object)AccessMode.WRITE);
        TestUtil.await(provider.acquireConnection(context));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{context, databaseNameFuture});
        ((ConnectionContext)inOrder.verify((Object)context)).databaseNameFuture();
        ((CompletableFuture)inOrder.verify((Object)databaseNameFuture)).complete(DatabaseNameUtil.defaultDatabase());
        ((CompletableFuture)inOrder.verify((Object)databaseNameFuture)).isDone();
        ((CompletableFuture)inOrder.verify((Object)databaseNameFuture)).join();
    }

    private static ConnectionPool poolMock(BoltServerAddress address, Connection connection, Connection ... otherConnections) {
        ConnectionPool pool = (ConnectionPool)Mockito.mock(ConnectionPool.class);
        Object[] otherConnectionFutures = (CompletableFuture[])Stream.of(otherConnections).map(CompletableFuture::completedFuture).toArray(CompletableFuture[]::new);
        Mockito.when((Object)pool.acquire(address)).thenReturn(CompletableFuture.completedFuture(connection), otherConnectionFutures);
        return pool;
    }
}

