/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import io.netty.bootstrap.Bootstrap;
import io.netty.util.concurrent.EventExecutorGroup;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.junit.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Config;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Logging;
import org.neo4j.driver.MetricsAdapter;
import org.neo4j.driver.SessionConfig;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.DriverFactory;
import org.neo4j.driver.internal.InternalDriver;
import org.neo4j.driver.internal.SessionFactory;
import org.neo4j.driver.internal.async.LeakLoggingNetworkSession;
import org.neo4j.driver.internal.async.NetworkSession;
import org.neo4j.driver.internal.async.connection.BootstrapFactory;
import org.neo4j.driver.internal.cluster.RoutingContext;
import org.neo4j.driver.internal.cluster.RoutingSettings;
import org.neo4j.driver.internal.cluster.loadbalancing.LoadBalancer;
import org.neo4j.driver.internal.metrics.DevNullMetricsProvider;
import org.neo4j.driver.internal.metrics.InternalMetricsProvider;
import org.neo4j.driver.internal.metrics.MetricsProvider;
import org.neo4j.driver.internal.metrics.MicrometerMetricsProvider;
import org.neo4j.driver.internal.retry.RetryLogic;
import org.neo4j.driver.internal.retry.RetrySettings;
import org.neo4j.driver.internal.security.SecurityPlan;
import org.neo4j.driver.internal.security.SecurityPlanImpl;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.spi.ConnectionPool;
import org.neo4j.driver.internal.spi.ConnectionProvider;
import org.neo4j.driver.internal.util.Clock;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.internal.util.Matchers;

class DriverFactoryTest {
    DriverFactoryTest() {
    }

    private static Stream<String> testUris() {
        return Stream.of("bolt://localhost:7687", "neo4j://localhost:7687");
    }

    @ParameterizedTest
    @MethodSource(value={"testUris"})
    void connectionPoolClosedWhenDriverCreationFails(String uri) {
        ConnectionPool connectionPool = DriverFactoryTest.connectionPoolMock();
        ThrowingDriverFactory factory = new ThrowingDriverFactory(connectionPool);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.createDriver(uri, factory));
        ((ConnectionPool)Mockito.verify((Object)connectionPool)).close();
    }

    @ParameterizedTest
    @MethodSource(value={"testUris"})
    void connectionPoolCloseExceptionIsSuppressedWhenDriverCreationFails(String uri) {
        ConnectionPool connectionPool = DriverFactoryTest.connectionPoolMock();
        RuntimeException poolCloseError = new RuntimeException("Pool close error");
        Mockito.when((Object)connectionPool.close()).thenReturn((Object)Futures.failedFuture((Throwable)poolCloseError));
        ThrowingDriverFactory factory = new ThrowingDriverFactory(connectionPool);
        UnsupportedOperationException e = (UnsupportedOperationException)Assertions.assertThrows(UnsupportedOperationException.class, () -> this.createDriver(uri, factory));
        Assertions.assertArrayEquals((Object[])new Throwable[]{poolCloseError}, (Object[])e.getSuppressed());
        ((ConnectionPool)Mockito.verify((Object)connectionPool)).close();
    }

    @ParameterizedTest
    @MethodSource(value={"testUris"})
    void usesStandardSessionFactoryWhenNothingConfigured(String uri) {
        Config config = Config.defaultConfig();
        SessionFactoryCapturingDriverFactory factory = new SessionFactoryCapturingDriverFactory();
        this.createDriver(uri, factory, config);
        SessionFactory capturedFactory = factory.capturedSessionFactory;
        MatcherAssert.assertThat((Object)capturedFactory.newInstance(SessionConfig.defaultConfig()), (Matcher)org.hamcrest.Matchers.instanceOf(NetworkSession.class));
    }

    @ParameterizedTest
    @MethodSource(value={"testUris"})
    void usesLeakLoggingSessionFactoryWhenConfigured(String uri) {
        Config config = Config.builder().withLeakedSessionsLogging().build();
        SessionFactoryCapturingDriverFactory factory = new SessionFactoryCapturingDriverFactory();
        this.createDriver(uri, factory, config);
        SessionFactory capturedFactory = factory.capturedSessionFactory;
        MatcherAssert.assertThat((Object)capturedFactory.newInstance(SessionConfig.defaultConfig()), (Matcher)org.hamcrest.Matchers.instanceOf(LeakLoggingNetworkSession.class));
    }

    @ParameterizedTest
    @MethodSource(value={"testUris"})
    void shouldNotVerifyConnectivity(String uri) {
        SessionFactory sessionFactory = (SessionFactory)Mockito.mock(SessionFactory.class);
        Mockito.when((Object)sessionFactory.verifyConnectivity()).thenReturn((Object)Futures.completedWithNull());
        Mockito.when((Object)sessionFactory.close()).thenReturn((Object)Futures.completedWithNull());
        DriverFactoryWithSessions driverFactory = new DriverFactoryWithSessions(sessionFactory);
        try (Driver driver = this.createDriver(uri, driverFactory);){
            Assertions.assertNotNull((Object)driver);
            ((SessionFactory)Mockito.verify((Object)sessionFactory, (VerificationMode)Mockito.never())).verifyConnectivity();
        }
    }

    @Test
    void shouldNotCreateDriverMetrics() {
        Config config = (Config)Mockito.mock(Config.class);
        Mockito.when((Object)config.isMetricsEnabled()).thenReturn((Object)false);
        MetricsProvider provider = DriverFactory.getOrCreateMetricsProvider((Config)config, (Clock)Clock.SYSTEM);
        MatcherAssert.assertThat((Object)provider, (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)DevNullMetricsProvider.INSTANCE)));
    }

    @Test
    void shouldCreateDriverMetricsIfMonitoringEnabled() {
        Config config = (Config)Mockito.mock(Config.class);
        Mockito.when((Object)config.isMetricsEnabled()).thenReturn((Object)true);
        Mockito.when((Object)config.logging()).thenReturn((Object)Logging.none());
        MetricsProvider provider = DriverFactory.getOrCreateMetricsProvider((Config)config, (Clock)Clock.SYSTEM);
        MatcherAssert.assertThat((Object)(provider instanceof InternalMetricsProvider), (Matcher)org.hamcrest.Matchers.is((Object)true));
    }

    @Test
    void shouldCreateMicrometerDriverMetricsIfMonitoringEnabled() {
        Config config = (Config)Mockito.mock(Config.class);
        Mockito.when((Object)config.isMetricsEnabled()).thenReturn((Object)true);
        Mockito.when((Object)config.metricsAdapter()).thenReturn((Object)MetricsAdapter.MICROMETER);
        Mockito.when((Object)config.logging()).thenReturn((Object)Logging.none());
        MetricsProvider provider = DriverFactory.getOrCreateMetricsProvider((Config)config, (Clock)Clock.SYSTEM);
        MatcherAssert.assertThat((Object)(provider instanceof MicrometerMetricsProvider), (Matcher)org.hamcrest.Matchers.is((Object)true));
    }

    @ParameterizedTest
    @MethodSource(value={"testUris"})
    void shouldCreateAppropriateDriverType(String uri) {
        DriverFactory driverFactory = new DriverFactory();
        Driver driver = this.createDriver(uri, driverFactory);
        if (uri.startsWith("bolt://")) {
            MatcherAssert.assertThat((Object)driver, (Matcher)org.hamcrest.Matchers.is(Matchers.directDriver()));
        } else if (uri.startsWith("neo4j://")) {
            MatcherAssert.assertThat((Object)driver, (Matcher)org.hamcrest.Matchers.is(Matchers.clusterDriver()));
        } else {
            Assertions.fail((String)"Unexpected scheme provided in argument");
        }
    }

    private Driver createDriver(String uri, DriverFactory driverFactory) {
        return this.createDriver(uri, driverFactory, Config.defaultConfig());
    }

    private Driver createDriver(String uri, DriverFactory driverFactory, Config config) {
        AuthToken auth = AuthTokens.none();
        return driverFactory.newInstance(URI.create(uri), auth, RoutingSettings.DEFAULT, RetrySettings.DEFAULT, config, SecurityPlanImpl.insecure());
    }

    private static ConnectionPool connectionPoolMock() {
        ConnectionPool pool = (ConnectionPool)Mockito.mock(ConnectionPool.class);
        Connection connection = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)pool.acquire((BoltServerAddress)Mockito.any(BoltServerAddress.class))).thenReturn(CompletableFuture.completedFuture(connection));
        Mockito.when((Object)pool.close()).thenReturn((Object)Futures.completedWithNull());
        return pool;
    }

    private static class DriverFactoryWithSessions
    extends DriverFactory {
        final SessionFactory sessionFactory;

        DriverFactoryWithSessions(SessionFactory sessionFactory) {
            this.sessionFactory = sessionFactory;
        }

        protected Bootstrap createBootstrap(int ignored) {
            return BootstrapFactory.newBootstrap((int)1);
        }

        protected ConnectionPool createConnectionPool(AuthToken authToken, SecurityPlan securityPlan, Bootstrap bootstrap, MetricsProvider metricsProvider, Config config, boolean ownsEventLoopGroup, RoutingContext routingContext) {
            return DriverFactoryTest.connectionPoolMock();
        }

        protected SessionFactory createSessionFactory(ConnectionProvider connectionProvider, RetryLogic retryLogic, Config config) {
            return this.sessionFactory;
        }
    }

    private static class SessionFactoryCapturingDriverFactory
    extends DriverFactory {
        SessionFactory capturedSessionFactory;

        private SessionFactoryCapturingDriverFactory() {
        }

        protected InternalDriver createDriver(SecurityPlan securityPlan, SessionFactory sessionFactory, MetricsProvider metricsProvider, Config config) {
            InternalDriver driver = (InternalDriver)Mockito.mock(InternalDriver.class);
            Mockito.when((Object)driver.verifyConnectivityAsync()).thenReturn((Object)Futures.completedWithNull());
            return driver;
        }

        protected LoadBalancer createLoadBalancer(BoltServerAddress address, ConnectionPool connectionPool, EventExecutorGroup eventExecutorGroup, Config config, RoutingSettings routingSettings) {
            return null;
        }

        protected SessionFactory createSessionFactory(ConnectionProvider connectionProvider, RetryLogic retryLogic, Config config) {
            SessionFactory sessionFactory;
            this.capturedSessionFactory = sessionFactory = super.createSessionFactory(connectionProvider, retryLogic, config);
            return sessionFactory;
        }

        protected ConnectionPool createConnectionPool(AuthToken authToken, SecurityPlan securityPlan, Bootstrap bootstrap, MetricsProvider metricsProvider, Config config, boolean ownsEventLoopGroup, RoutingContext routingContext) {
            return DriverFactoryTest.connectionPoolMock();
        }
    }

    private static class ThrowingDriverFactory
    extends DriverFactory {
        final ConnectionPool connectionPool;

        ThrowingDriverFactory(ConnectionPool connectionPool) {
            this.connectionPool = connectionPool;
        }

        protected InternalDriver createDriver(SecurityPlan securityPlan, SessionFactory sessionFactory, MetricsProvider metricsProvider, Config config) {
            throw new UnsupportedOperationException("Can't create direct driver");
        }

        protected InternalDriver createRoutingDriver(SecurityPlan securityPlan, BoltServerAddress address, ConnectionPool connectionPool, EventExecutorGroup eventExecutorGroup, RoutingSettings routingSettings, RetryLogic retryLogic, MetricsProvider metricsProvider, Config config) {
            throw new UnsupportedOperationException("Can't create routing driver");
        }

        protected ConnectionPool createConnectionPool(AuthToken authToken, SecurityPlan securityPlan, Bootstrap bootstrap, MetricsProvider metricsProvider, Config config, boolean ownsEventLoopGroup, RoutingContext routingContext) {
            return this.connectionPool;
        }
    }
}

