/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.HashMap;
import java.util.Iterator;
import java.util.function.Function;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.junit.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.internal.InternalRelationship;

class InternalRelationshipTest {
    InternalRelationshipTest() {
    }

    @Test
    void extractValuesFromNode() {
        InternalRelationship relationship = this.createRelationship();
        Function<Value, Integer> extractor = Value::asInt;
        Iterable values = relationship.values(extractor);
        Iterator iterator = values.iterator();
        MatcherAssert.assertThat((Object)((Integer)iterator.next()), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)((Integer)iterator.next()), (Matcher)CoreMatchers.equalTo((Object)2));
        Assertions.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    void accessUnknownKeyShouldBeNull() {
        InternalRelationship relationship = this.createRelationship();
        MatcherAssert.assertThat((Object)relationship.get("k1"), (Matcher)CoreMatchers.equalTo((Object)Values.value((int)1)));
        MatcherAssert.assertThat((Object)relationship.get("k2"), (Matcher)CoreMatchers.equalTo((Object)Values.value((int)2)));
        MatcherAssert.assertThat((Object)relationship.get("k3"), (Matcher)CoreMatchers.equalTo((Object)Values.NULL));
    }

    private InternalRelationship createRelationship() {
        HashMap<String, Value> props = new HashMap<String, Value>();
        props.put("k1", Values.value((int)1));
        props.put("k2", Values.value((int)2));
        return new InternalRelationship(1L, 0L, 1L, "T", props);
    }
}

