/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.junit.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.driver.Query;
import org.neo4j.driver.Record;
import org.neo4j.driver.Records;
import org.neo4j.driver.Result;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.async.ResultCursor;
import org.neo4j.driver.exceptions.NoSuchRecordException;
import org.neo4j.driver.exceptions.ResultConsumedException;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.InternalResult;
import org.neo4j.driver.internal.cursor.AsyncResultCursor;
import org.neo4j.driver.internal.cursor.AsyncResultCursorImpl;
import org.neo4j.driver.internal.cursor.DisposableAsyncResultCursor;
import org.neo4j.driver.internal.handlers.LegacyPullAllResponseHandler;
import org.neo4j.driver.internal.handlers.PullAllResponseHandler;
import org.neo4j.driver.internal.handlers.PullResponseCompletionListener;
import org.neo4j.driver.internal.handlers.RunResponseHandler;
import org.neo4j.driver.internal.messaging.v3.BoltProtocolV3;
import org.neo4j.driver.internal.messaging.v43.BoltProtocolV43;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.value.NullValue;
import org.neo4j.driver.util.Pair;
import org.neo4j.driver.util.TestUtil;

class InternalResultTest {
    InternalResultTest() {
    }

    @Test
    void iterationShouldWorksAsExpected() {
        Result result = this.createResult(3);
        Assertions.assertTrue((boolean)result.hasNext());
        MatcherAssert.assertThat(this.values(result.next()), (Matcher)CoreMatchers.equalTo(Arrays.asList(Values.value((String)"v1-1"), Values.value((String)"v2-1"))));
        Assertions.assertTrue((boolean)result.hasNext());
        MatcherAssert.assertThat(this.values(result.next()), (Matcher)CoreMatchers.equalTo(Arrays.asList(Values.value((String)"v1-2"), Values.value((String)"v2-2"))));
        Assertions.assertTrue((boolean)result.hasNext());
        MatcherAssert.assertThat(this.values(result.next()), (Matcher)CoreMatchers.equalTo(Arrays.asList(Values.value((String)"v1-3"), Values.value((String)"v2-3"))));
        Assertions.assertFalse((boolean)result.hasNext());
        Assertions.assertThrows(NoSuchRecordException.class, () -> ((Result)result).next());
    }

    @Test
    void firstOfFieldNameShouldWorkAsExpected() {
        Result result = this.createResult(3);
        MatcherAssert.assertThat((Object)result.next().get("k1"), (Matcher)CoreMatchers.equalTo((Object)Values.value((String)"v1-1")));
        Assertions.assertTrue((boolean)result.hasNext());
    }

    @Test
    void firstOfFieldIndexShouldWorkAsExpected() {
        Result result = this.createResult(3);
        MatcherAssert.assertThat((Object)result.next().get(0), (Matcher)CoreMatchers.equalTo((Object)Values.value((String)"v1-1")));
        Assertions.assertTrue((boolean)result.hasNext());
    }

    @Test
    void singlePastFirstShouldFail() {
        Result result = this.createResult(2);
        result.next();
        result.next();
        Assertions.assertThrows(NoSuchRecordException.class, () -> ((Result)result).single());
    }

    @Test
    void singleNoneShouldFail() {
        Result result = this.createResult(0);
        Assertions.assertThrows(NoSuchRecordException.class, () -> ((Result)result).single());
    }

    @Test
    void singleWhenMoreThanOneShouldFail() {
        Result result = this.createResult(2);
        Assertions.assertThrows(NoSuchRecordException.class, () -> ((Result)result).single());
    }

    @Test
    void singleOfFieldNameShouldWorkAsExpected() {
        Result result = this.createResult(1);
        MatcherAssert.assertThat((Object)result.single().get("k1"), (Matcher)CoreMatchers.equalTo((Object)Values.value((String)"v1-1")));
        Assertions.assertFalse((boolean)result.hasNext());
    }

    @Test
    void singleOfFieldIndexShouldWorkAsExpected() {
        Result result = this.createResult(1);
        MatcherAssert.assertThat((Object)result.single().get(0), (Matcher)CoreMatchers.equalTo((Object)Values.value((String)"v1-1")));
        Assertions.assertFalse((boolean)result.hasNext());
    }

    @Test
    void singleShouldWorkAsExpected() {
        Assertions.assertNotNull((Object)this.createResult(1).single());
    }

    @Test
    void singleShouldThrowOnBigResult() {
        Assertions.assertThrows(NoSuchRecordException.class, () -> this.createResult(42).single());
    }

    @Test
    void singleShouldThrowOnEmptyResult() {
        Assertions.assertThrows(NoSuchRecordException.class, () -> this.createResult(0).single());
    }

    @Test
    void singleShouldThrowOnConsumedResult() {
        Assertions.assertThrows(ResultConsumedException.class, () -> {
            Result result = this.createResult(2);
            result.consume();
            result.single();
        });
    }

    @Test
    void shouldConsumeTwice() {
        Result result = this.createResult(2);
        result.consume();
        result.consume();
        Assertions.assertThrows(ResultConsumedException.class, () -> ((Result)result).hasNext());
    }

    @Test
    void shouldList() {
        Result result = this.createResult(2);
        List records = result.list(Records.column((String)"k1", (Function)Values.ofString()));
        MatcherAssert.assertThat((Object)records, (Matcher)CoreMatchers.equalTo(Arrays.asList("v1-1", "v1-2")));
    }

    @Test
    void shouldListTwice() {
        Result result = this.createResult(2);
        List firstList = result.list();
        MatcherAssert.assertThat((Object)firstList.size(), (Matcher)CoreMatchers.equalTo((Object)2));
        List secondList = result.list();
        MatcherAssert.assertThat((Object)secondList.size(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    void singleShouldNotThrowOnPartiallyConsumedResult() {
        Result result = this.createResult(2);
        result.next();
        Assertions.assertNotNull((Object)result.single());
    }

    @Test
    void singleShouldConsumeIfFailing() {
        Result result = this.createResult(2);
        Assertions.assertThrows(NoSuchRecordException.class, () -> ((Result)result).single());
        Assertions.assertFalse((boolean)result.hasNext());
    }

    @Test
    void retainShouldWorkAsExpected() {
        Result result = this.createResult(3);
        List records = result.list();
        Assertions.assertFalse((boolean)result.hasNext());
        MatcherAssert.assertThat((Object)records, (Matcher)IsCollectionWithSize.hasSize((int)3));
    }

    @Test
    void retainAndMapByKeyShouldWorkAsExpected() {
        Result result = this.createResult(3);
        List records = result.list(Records.column((String)"k1"));
        Assertions.assertFalse((boolean)result.hasNext());
        MatcherAssert.assertThat((Object)records, (Matcher)IsCollectionWithSize.hasSize((int)3));
    }

    @Test
    void retainAndMapByIndexShouldWorkAsExpected() {
        Result result = this.createResult(3);
        List records = result.list(Records.column((int)0));
        Assertions.assertFalse((boolean)result.hasNext());
        MatcherAssert.assertThat((Object)records, (Matcher)IsCollectionWithSize.hasSize((int)3));
    }

    @Test
    void accessingOutOfBoundsShouldBeNull() {
        Result result = this.createResult(1);
        Record record = result.single();
        MatcherAssert.assertThat((Object)record.get(0), (Matcher)CoreMatchers.equalTo((Object)Values.value((String)"v1-1")));
        MatcherAssert.assertThat((Object)record.get(1), (Matcher)CoreMatchers.equalTo((Object)Values.value((String)"v2-1")));
        MatcherAssert.assertThat((Object)record.get(2), (Matcher)CoreMatchers.equalTo((Object)NullValue.NULL));
        MatcherAssert.assertThat((Object)record.get(-37), (Matcher)CoreMatchers.equalTo((Object)NullValue.NULL));
    }

    @Test
    void accessingKeysWithoutCallingNextShouldNotFail() {
        Result result = this.createResult(11);
        MatcherAssert.assertThat((Object)result.keys(), (Matcher)CoreMatchers.equalTo(Arrays.asList("k1", "k2")));
    }

    @Test
    void shouldPeekIntoTheFuture() {
        Result result = this.createResult(2);
        MatcherAssert.assertThat((Object)result.peek().get("k1"), (Matcher)CoreMatchers.equalTo((Object)Values.value((String)"v1-1")));
        result.next();
        MatcherAssert.assertThat((Object)result.peek().get("k1"), (Matcher)CoreMatchers.equalTo((Object)Values.value((String)"v1-2")));
        result.next();
        Assertions.assertThrows(NoSuchRecordException.class, () -> ((Result)result).peek());
    }

    @Test
    void shouldNotPeekIntoTheFutureWhenResultIsEmpty() {
        Result result = this.createResult(0);
        Assertions.assertThrows(NoSuchRecordException.class, () -> ((Result)result).peek());
    }

    private Result createResult(int numberOfRecords) {
        RunResponseHandler runHandler = new RunResponseHandler(new CompletableFuture(), BoltProtocolV3.METADATA_EXTRACTOR, (Connection)Mockito.mock(Connection.class), null);
        runHandler.onSuccess(Collections.singletonMap("fields", Values.value(Arrays.asList("k1", "k2"))));
        Query query = new Query("<unknown>");
        Connection connection = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)connection.serverAddress()).thenReturn((Object)BoltServerAddress.LOCAL_DEFAULT);
        Mockito.when((Object)connection.serverVersion()).thenReturn((Object)TestUtil.anyServerVersion());
        Mockito.when((Object)connection.protocol()).thenReturn((Object)BoltProtocolV43.INSTANCE);
        Mockito.when((Object)connection.serverAgent()).thenReturn((Object)"Neo4j/4.2.5");
        LegacyPullAllResponseHandler pullAllHandler = new LegacyPullAllResponseHandler(query, runHandler, connection, BoltProtocolV3.METADATA_EXTRACTOR, (PullResponseCompletionListener)Mockito.mock(PullResponseCompletionListener.class));
        for (int i = 1; i <= numberOfRecords; ++i) {
            pullAllHandler.onRecord(new Value[]{Values.value((String)("v1-" + i)), Values.value((String)("v2-" + i))});
        }
        pullAllHandler.onSuccess(Collections.emptyMap());
        AsyncResultCursorImpl cursor = new AsyncResultCursorImpl(null, runHandler, (PullAllResponseHandler)pullAllHandler);
        return new InternalResult(connection, (ResultCursor)new DisposableAsyncResultCursor((AsyncResultCursor)cursor));
    }

    private List<Value> values(Record record) {
        ArrayList<Value> result = new ArrayList<Value>(record.keys().size());
        for (Pair property : record.fields()) {
            result.add((Value)property.value());
        }
        return result;
    }
}

