/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.NullSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.neo4j.driver.internal.Scheme;

class SchemeTest {
    SchemeTest() {
    }

    @ParameterizedTest
    @ValueSource(strings={"neo4j", "neo4j+s", "neo4j+ssc", "bolt", "bolt+s", "bolt+ssc"})
    void shouldAcceptValidSchemes(String input) {
        Scheme.validateScheme((String)input);
    }

    @ParameterizedTest
    @ValueSource(strings={"bob", "grey", "", " ", "blah"})
    void shouldRejectInvalidSchemes(String input) {
        IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Scheme.validateScheme((String)input));
        Assert.assertTrue((boolean)ex.getMessage().contains("Invalid address format " + input));
    }

    @ParameterizedTest
    @NullSource
    void shouldRejectNullScheme(String input) {
        IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Scheme.validateScheme((String)input));
        Assert.assertTrue((boolean)ex.getMessage().contains("Scheme must not be null"));
    }

    @ParameterizedTest
    @ValueSource(strings={"neo4j+s", "bolt+s"})
    void shouldAcceptValidHighTrustSchemes(String scheme) {
        Assert.assertTrue((boolean)Scheme.isHighTrustScheme((String)scheme));
    }

    @ParameterizedTest
    @ValueSource(strings={"neo4j", "neo4j+ssc", "bolt", "bolt+ssc", "blah"})
    void shouldRejectInvalidHighTrustSchemes(String scheme) {
        Assert.assertFalse((boolean)Scheme.isHighTrustScheme((String)scheme));
    }

    @ParameterizedTest
    @ValueSource(strings={"neo4j+ssc", "bolt+ssc"})
    void shouldAcceptValidLowTrustSchemes(String scheme) {
        Assert.assertTrue((boolean)Scheme.isLowTrustScheme((String)scheme));
    }

    @ParameterizedTest
    @ValueSource(strings={"neo4j", "neo4j+s", "bolt", "bolt+s", "blah"})
    void shouldRejectInvalidLowTrustSchemes(String scheme) {
        Assert.assertFalse((boolean)Scheme.isLowTrustScheme((String)scheme));
    }

    @ParameterizedTest
    @ValueSource(strings={"neo4j+s", "neo4j+ssc", "bolt+s", "bolt+ssc"})
    void shouldAcceptValidSecuritySchemes(String scheme) {
        Assert.assertTrue((boolean)Scheme.isSecurityScheme((String)scheme));
    }

    @ParameterizedTest
    @ValueSource(strings={"neo4j", "bolt", "blah"})
    void shouldRejectInvalidSecuritySchemes(String scheme) {
        Assert.assertFalse((boolean)Scheme.isSecurityScheme((String)scheme));
    }

    @ParameterizedTest
    @ValueSource(strings={"neo4j", "neo4j+s", "neo4j+ssc"})
    void shouldAcceptValidRoutingSchemes(String scheme) {
        Assert.assertTrue((boolean)Scheme.isRoutingScheme((String)scheme));
    }

    @ParameterizedTest
    @ValueSource(strings={"bolt", "bolt+s", "bolt+ssc", "blah"})
    void shouldRejectInvalidRoutingSchemes(String scheme) {
        Assert.assertFalse((boolean)Scheme.isRoutingScheme((String)scheme));
    }
}

