/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async;

import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.junit.MatcherAssert;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Query;
import org.neo4j.driver.Record;
import org.neo4j.driver.TransactionConfig;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.async.AsyncSession;
import org.neo4j.driver.async.AsyncTransaction;
import org.neo4j.driver.async.AsyncTransactionWork;
import org.neo4j.driver.async.ResultCursor;
import org.neo4j.driver.exceptions.ServiceUnavailableException;
import org.neo4j.driver.exceptions.SessionExpiredException;
import org.neo4j.driver.internal.InternalBookmark;
import org.neo4j.driver.internal.InternalRecord;
import org.neo4j.driver.internal.async.ConnectionContext;
import org.neo4j.driver.internal.async.InternalAsyncSession;
import org.neo4j.driver.internal.async.NetworkSession;
import org.neo4j.driver.internal.messaging.v4.BoltProtocolV4;
import org.neo4j.driver.internal.retry.RetryLogic;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.spi.ConnectionProvider;
import org.neo4j.driver.internal.util.FixedRetryLogic;
import org.neo4j.driver.internal.value.IntegerValue;
import org.neo4j.driver.summary.ResultSummary;
import org.neo4j.driver.util.TestUtil;

class InternalAsyncSessionTest {
    private Connection connection;
    private ConnectionProvider connectionProvider;
    private AsyncSession asyncSession;
    private NetworkSession session;

    InternalAsyncSessionTest() {
    }

    @BeforeEach
    void setUp() {
        this.connection = TestUtil.connectionMock(BoltProtocolV4.INSTANCE);
        this.connectionProvider = (ConnectionProvider)Mockito.mock(ConnectionProvider.class);
        Mockito.when((Object)this.connectionProvider.acquireConnection((ConnectionContext)ArgumentMatchers.any(ConnectionContext.class))).thenReturn(CompletableFuture.completedFuture(this.connection));
        this.session = TestUtil.newSession(this.connectionProvider);
        this.asyncSession = new InternalAsyncSession(this.session);
    }

    private static Stream<Function<AsyncSession, CompletionStage<ResultCursor>>> allSessionRunMethods() {
        return Stream.of(session -> session.runAsync("RETURN 1"), session -> session.runAsync("RETURN $x", Values.parameters((Object[])new Object[]{"x", 1})), session -> session.runAsync("RETURN $x", Collections.singletonMap("x", 1)), session -> session.runAsync("RETURN $x", (Record)new InternalRecord(Collections.singletonList("x"), new Value[]{new IntegerValue(1L)})), session -> session.runAsync(new Query("RETURN $x", Values.parameters((Object[])new Object[]{"x", 1}))), session -> session.runAsync(new Query("RETURN $x", Values.parameters((Object[])new Object[]{"x", 1})), TransactionConfig.empty()), session -> session.runAsync("RETURN $x", Collections.singletonMap("x", 1), TransactionConfig.empty()), session -> session.runAsync("RETURN 1", TransactionConfig.empty()));
    }

    private static Stream<Function<AsyncSession, CompletionStage<AsyncTransaction>>> allBeginTxMethods() {
        return Stream.of(session -> session.beginTransactionAsync(), session -> session.beginTransactionAsync(TransactionConfig.empty()));
    }

    private static Stream<Function<AsyncSession, CompletionStage<String>>> allRunTxMethods() {
        return Stream.of(session -> session.readTransactionAsync(tx -> CompletableFuture.completedFuture("a")), session -> session.writeTransactionAsync(tx -> CompletableFuture.completedFuture("a")), session -> session.readTransactionAsync(tx -> CompletableFuture.completedFuture("a"), TransactionConfig.empty()), session -> session.writeTransactionAsync(tx -> CompletableFuture.completedFuture("a"), TransactionConfig.empty()));
    }

    @ParameterizedTest
    @MethodSource(value={"allSessionRunMethods"})
    void shouldFlushOnRun(Function<AsyncSession, CompletionStage<ResultCursor>> runReturnOne) throws Throwable {
        TestUtil.setupSuccessfulRunAndPull(this.connection);
        ResultCursor cursor = (ResultCursor)TestUtil.await(runReturnOne.apply(this.asyncSession));
        TestUtil.verifyRunAndPull(this.connection, ((ResultSummary)TestUtil.await(cursor.consumeAsync())).query().text());
    }

    @ParameterizedTest
    @MethodSource(value={"allBeginTxMethods"})
    void shouldDelegateBeginTx(Function<AsyncSession, CompletionStage<AsyncTransaction>> beginTx) throws Throwable {
        AsyncTransaction tx = (AsyncTransaction)TestUtil.await(beginTx.apply(this.asyncSession));
        TestUtil.verifyBeginTx(this.connection);
        Assert.assertNotNull((Object)tx);
    }

    @ParameterizedTest
    @MethodSource(value={"allRunTxMethods"})
    void txRunShouldBeginAndCommitTx(Function<AsyncSession, CompletionStage<String>> runTx) throws Throwable {
        String string = (String)TestUtil.await(runTx.apply(this.asyncSession));
        TestUtil.verifyBeginTx(this.connection);
        TestUtil.verifyCommitTx(this.connection);
        ((Connection)Mockito.verify((Object)this.connection)).release();
        Assert.assertThat((Object)string, (Matcher)CoreMatchers.equalTo((Object)"a"));
    }

    @Test
    void rollsBackReadTxWhenFunctionThrows() {
        this.testTxRollbackWhenThrows(AccessMode.READ);
    }

    @Test
    void rollsBackWriteTxWhenFunctionThrows() {
        this.testTxRollbackWhenThrows(AccessMode.WRITE);
    }

    @Test
    void readTxRetriedUntilSuccessWhenFunctionThrows() {
        this.testTxIsRetriedUntilSuccessWhenFunctionThrows(AccessMode.READ);
    }

    @Test
    void writeTxRetriedUntilSuccessWhenFunctionThrows() {
        this.testTxIsRetriedUntilSuccessWhenFunctionThrows(AccessMode.WRITE);
    }

    @Test
    void readTxRetriedUntilSuccessWhenTxCloseThrows() {
        this.testTxIsRetriedUntilSuccessWhenCommitThrows(AccessMode.READ);
    }

    @Test
    void writeTxRetriedUntilSuccessWhenTxCloseThrows() {
        this.testTxIsRetriedUntilSuccessWhenCommitThrows(AccessMode.WRITE);
    }

    @Test
    void readTxRetriedUntilFailureWhenFunctionThrows() {
        this.testTxIsRetriedUntilFailureWhenFunctionThrows(AccessMode.READ);
    }

    @Test
    void writeTxRetriedUntilFailureWhenFunctionThrows() {
        this.testTxIsRetriedUntilFailureWhenFunctionThrows(AccessMode.WRITE);
    }

    @Test
    void readTxRetriedUntilFailureWhenTxCloseThrows() {
        this.testTxIsRetriedUntilFailureWhenCommitFails(AccessMode.READ);
    }

    @Test
    void writeTxRetriedUntilFailureWhenTxCloseThrows() {
        this.testTxIsRetriedUntilFailureWhenCommitFails(AccessMode.WRITE);
    }

    @Test
    void shouldCloseSession() throws Throwable {
        TestUtil.await(this.asyncSession.closeAsync());
        Assert.assertFalse((boolean)this.session.isOpen());
    }

    @Test
    void shouldReturnBookmark() throws Throwable {
        this.session = TestUtil.newSession(this.connectionProvider, InternalBookmark.parse((String)"Bookmark1"));
        this.asyncSession = new InternalAsyncSession(this.session);
        Assert.assertThat((Object)this.asyncSession.lastBookmark(), (Matcher)CoreMatchers.equalTo((Object)this.session.lastBookmark()));
    }

    private void testTxRollbackWhenThrows(AccessMode transactionMode) {
        IllegalStateException error = new IllegalStateException("Oh!");
        AsyncTransactionWork work = tx -> {
            throw error;
        };
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> InternalAsyncSessionTest.executeTransaction(this.asyncSession, transactionMode, work));
        Assertions.assertEquals((Object)error, (Object)e);
        ((ConnectionProvider)Mockito.verify((Object)this.connectionProvider)).acquireConnection((ConnectionContext)ArgumentMatchers.any(ConnectionContext.class));
        TestUtil.verifyBeginTx(this.connection);
        TestUtil.verifyRollbackTx(this.connection);
    }

    private void testTxIsRetriedUntilSuccessWhenFunctionThrows(AccessMode mode) {
        int failures = 12;
        int retries = failures + 1;
        FixedRetryLogic retryLogic = new FixedRetryLogic(retries);
        this.session = TestUtil.newSession(this.connectionProvider, (RetryLogic)retryLogic);
        this.asyncSession = new InternalAsyncSession(this.session);
        TxWork work = (TxWork)Mockito.spy((Object)new TxWork(42, failures, (RuntimeException)new SessionExpiredException("")));
        int answer = InternalAsyncSessionTest.executeTransaction(this.asyncSession, mode, work);
        Assertions.assertEquals((int)42, (int)answer);
        InternalAsyncSessionTest.verifyInvocationCount(work, failures + 1);
        TestUtil.verifyCommitTx(this.connection);
        TestUtil.verifyRollbackTx(this.connection, Mockito.times((int)failures));
    }

    private void testTxIsRetriedUntilSuccessWhenCommitThrows(AccessMode mode) {
        int failures = 13;
        int retries = failures + 1;
        FixedRetryLogic retryLogic = new FixedRetryLogic(retries);
        TestUtil.setupFailingCommit(this.connection, failures);
        this.session = TestUtil.newSession(this.connectionProvider, (RetryLogic)retryLogic);
        this.asyncSession = new InternalAsyncSession(this.session);
        TxWork work = (TxWork)Mockito.spy((Object)new TxWork(43));
        int answer = InternalAsyncSessionTest.executeTransaction(this.asyncSession, mode, work);
        Assertions.assertEquals((int)43, (int)answer);
        InternalAsyncSessionTest.verifyInvocationCount(work, failures + 1);
        TestUtil.verifyCommitTx(this.connection, Mockito.times((int)retries));
    }

    private void testTxIsRetriedUntilFailureWhenFunctionThrows(AccessMode mode) {
        int failures = 14;
        int retries = failures - 1;
        FixedRetryLogic retryLogic = new FixedRetryLogic(retries);
        this.session = TestUtil.newSession(this.connectionProvider, (RetryLogic)retryLogic);
        this.asyncSession = new InternalAsyncSession(this.session);
        TxWork work = (TxWork)Mockito.spy((Object)new TxWork(42, failures, (RuntimeException)new SessionExpiredException("Oh!")));
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> InternalAsyncSessionTest.executeTransaction(this.asyncSession, mode, work));
        MatcherAssert.assertThat((Object)e, (Matcher)CoreMatchers.instanceOf(SessionExpiredException.class));
        Assertions.assertEquals((Object)"Oh!", (Object)e.getMessage());
        InternalAsyncSessionTest.verifyInvocationCount(work, failures);
        TestUtil.verifyCommitTx(this.connection, Mockito.never());
        TestUtil.verifyRollbackTx(this.connection, Mockito.times((int)failures));
    }

    private void testTxIsRetriedUntilFailureWhenCommitFails(AccessMode mode) {
        int failures = 17;
        int retries = failures - 1;
        FixedRetryLogic retryLogic = new FixedRetryLogic(retries);
        TestUtil.setupFailingCommit(this.connection, failures);
        this.session = TestUtil.newSession(this.connectionProvider, (RetryLogic)retryLogic);
        this.asyncSession = new InternalAsyncSession(this.session);
        TxWork work = (TxWork)Mockito.spy((Object)new TxWork(42));
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> InternalAsyncSessionTest.executeTransaction(this.asyncSession, mode, work));
        MatcherAssert.assertThat((Object)e, (Matcher)CoreMatchers.instanceOf(ServiceUnavailableException.class));
        InternalAsyncSessionTest.verifyInvocationCount(work, failures);
        TestUtil.verifyCommitTx(this.connection, Mockito.times((int)failures));
    }

    private static <T> T executeTransaction(AsyncSession session, AccessMode mode, AsyncTransactionWork<CompletionStage<T>> work) {
        if (mode == AccessMode.READ) {
            return TestUtil.await(session.readTransactionAsync(work));
        }
        if (mode == AccessMode.WRITE) {
            return TestUtil.await(session.writeTransactionAsync(work));
        }
        throw new IllegalArgumentException("Unknown mode " + mode);
    }

    private static void verifyInvocationCount(AsyncTransactionWork<?> workSpy, int expectedInvocationCount) {
        ((AsyncTransactionWork)Mockito.verify(workSpy, (VerificationMode)Mockito.times((int)expectedInvocationCount))).execute((AsyncTransaction)ArgumentMatchers.any(AsyncTransaction.class));
    }

    private static class TxWork
    implements AsyncTransactionWork<CompletionStage<Integer>> {
        final int result;
        final int timesToThrow;
        final Supplier<RuntimeException> errorSupplier;
        int invoked;

        TxWork(int result) {
            this(result, 0, (Supplier<RuntimeException>)null);
        }

        TxWork(int result, int timesToThrow, RuntimeException error) {
            this.result = result;
            this.timesToThrow = timesToThrow;
            this.errorSupplier = () -> error;
        }

        TxWork(int result, int timesToThrow, Supplier<RuntimeException> errorSupplier) {
            this.result = result;
            this.timesToThrow = timesToThrow;
            this.errorSupplier = errorSupplier;
        }

        public CompletionStage<Integer> execute(AsyncTransaction tx) {
            if (this.timesToThrow > 0 && this.invoked++ < this.timesToThrow) {
                throw this.errorSupplier.get();
            }
            return CompletableFuture.completedFuture(this.result);
        }
    }
}

