/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async.connection;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelPromise;
import io.netty.channel.embedded.EmbeddedChannel;
import java.io.IOException;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.exceptions.ServiceUnavailableException;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.async.connection.BoltProtocolUtil;
import org.neo4j.driver.internal.async.connection.ChannelConnectedListener;
import org.neo4j.driver.internal.async.connection.ChannelPipelineBuilder;
import org.neo4j.driver.internal.async.connection.ChannelPipelineBuilderImpl;
import org.neo4j.driver.internal.async.connection.HandshakeHandler;
import org.neo4j.driver.internal.logging.DevNullLogging;
import org.neo4j.driver.util.TestUtil;

class ChannelConnectedListenerTest {
    private final EmbeddedChannel channel = new EmbeddedChannel();

    ChannelConnectedListenerTest() {
    }

    @AfterEach
    void tearDown() {
        this.channel.finishAndReleaseAll();
    }

    @Test
    void shouldFailPromiseWhenChannelConnectionFails() {
        ChannelPromise handshakeCompletedPromise = this.channel.newPromise();
        ChannelConnectedListener listener = ChannelConnectedListenerTest.newListener(handshakeCompletedPromise);
        ChannelPromise channelConnectedPromise = this.channel.newPromise();
        IOException cause = new IOException("Unable to connect!");
        channelConnectedPromise.setFailure((Throwable)cause);
        listener.operationComplete((ChannelFuture)channelConnectedPromise);
        ServiceUnavailableException error = (ServiceUnavailableException)Assertions.assertThrows(ServiceUnavailableException.class, () -> TestUtil.await(handshakeCompletedPromise));
        Assertions.assertEquals((Object)cause, (Object)error.getCause());
    }

    @Test
    void shouldWriteHandshakeWhenChannelConnected() {
        ChannelPromise handshakeCompletedPromise = this.channel.newPromise();
        ChannelConnectedListener listener = ChannelConnectedListenerTest.newListener(handshakeCompletedPromise);
        ChannelPromise channelConnectedPromise = this.channel.newPromise();
        channelConnectedPromise.setSuccess();
        listener.operationComplete((ChannelFuture)channelConnectedPromise);
        Assertions.assertNotNull((Object)this.channel.pipeline().get(HandshakeHandler.class));
        Assertions.assertTrue((boolean)this.channel.finish());
        Assertions.assertEquals((Object)BoltProtocolUtil.handshakeBuf(), (Object)this.channel.readOutbound());
    }

    private static ChannelConnectedListener newListener(ChannelPromise handshakeCompletedPromise) {
        return new ChannelConnectedListener(BoltServerAddress.LOCAL_DEFAULT, (ChannelPipelineBuilder)new ChannelPipelineBuilderImpl(), handshakeCompletedPromise, DevNullLogging.DEV_NULL_LOGGING);
    }
}

