/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async.connection;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.CodecException;
import java.io.IOException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.junit.MatcherAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.exceptions.ServiceUnavailableException;
import org.neo4j.driver.internal.async.connection.ChannelAttributes;
import org.neo4j.driver.internal.async.inbound.ChannelErrorHandler;
import org.neo4j.driver.internal.async.inbound.InboundMessageDispatcher;
import org.neo4j.driver.internal.logging.DevNullLogging;

class ChannelErrorHandlerTest {
    private EmbeddedChannel channel;
    private InboundMessageDispatcher messageDispatcher;

    ChannelErrorHandlerTest() {
    }

    @BeforeEach
    void setUp() {
        this.channel = new EmbeddedChannel();
        this.messageDispatcher = new InboundMessageDispatcher((Channel)this.channel, DevNullLogging.DEV_NULL_LOGGING);
        ChannelAttributes.setMessageDispatcher((Channel)this.channel, (InboundMessageDispatcher)this.messageDispatcher);
        this.channel.pipeline().addLast(new ChannelHandler[]{new ChannelErrorHandler(DevNullLogging.DEV_NULL_LOGGING)});
    }

    @AfterEach
    void tearDown() {
        if (this.channel != null) {
            this.channel.close();
        }
    }

    @Test
    void shouldHandleChannelInactive() {
        this.channel.pipeline().fireChannelInactive();
        Throwable error = this.messageDispatcher.currentError();
        MatcherAssert.assertThat((Object)error, (Matcher)Matchers.instanceOf(ServiceUnavailableException.class));
        MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)Matchers.startsWith((String)"Connection to the database terminated"));
        Assertions.assertFalse((boolean)this.channel.isOpen());
    }

    @Test
    void shouldHandleChannelInactiveAfterExceptionCaught() {
        RuntimeException originalError = new RuntimeException("Hi!");
        this.channel.pipeline().fireExceptionCaught((Throwable)originalError);
        this.channel.pipeline().fireChannelInactive();
        Throwable error = this.messageDispatcher.currentError();
        Assertions.assertEquals((Object)originalError, (Object)error);
        Assertions.assertFalse((boolean)this.channel.isOpen());
    }

    @Test
    void shouldHandleChannelInactiveWhenTerminationReasonSet() {
        String terminationReason = "Something really bad happened";
        ChannelAttributes.setTerminationReason((Channel)this.channel, (String)terminationReason);
        this.channel.pipeline().fireChannelInactive();
        Throwable error = this.messageDispatcher.currentError();
        MatcherAssert.assertThat((Object)error, (Matcher)Matchers.instanceOf(ServiceUnavailableException.class));
        MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)Matchers.startsWith((String)"Connection to the database terminated"));
        MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)Matchers.containsString((String)terminationReason));
        Assertions.assertFalse((boolean)this.channel.isOpen());
    }

    @Test
    void shouldHandleCodecException() {
        RuntimeException cause = new RuntimeException("Hi!");
        CodecException codecException = new CodecException("Unable to encode or decode message", (Throwable)cause);
        this.channel.pipeline().fireExceptionCaught((Throwable)codecException);
        Throwable error = this.messageDispatcher.currentError();
        Assertions.assertEquals((Object)cause, (Object)error);
        Assertions.assertFalse((boolean)this.channel.isOpen());
    }

    @Test
    void shouldHandleCodecExceptionWithoutCause() {
        CodecException codecException = new CodecException("Unable to encode or decode message");
        this.channel.pipeline().fireExceptionCaught((Throwable)codecException);
        Throwable error = this.messageDispatcher.currentError();
        Assertions.assertEquals((Object)codecException, (Object)error);
        Assertions.assertFalse((boolean)this.channel.isOpen());
    }

    @Test
    void shouldHandleIOException() {
        IOException ioException = new IOException("Write or read failed");
        this.channel.pipeline().fireExceptionCaught((Throwable)ioException);
        Throwable error = this.messageDispatcher.currentError();
        MatcherAssert.assertThat((Object)error, (Matcher)Matchers.instanceOf(ServiceUnavailableException.class));
        Assertions.assertEquals((Object)ioException, (Object)error.getCause());
        Assertions.assertFalse((boolean)this.channel.isOpen());
    }

    @Test
    void shouldHandleException() {
        RuntimeException originalError = new RuntimeException("Random failure");
        this.channel.pipeline().fireExceptionCaught((Throwable)originalError);
        Throwable error = this.messageDispatcher.currentError();
        Assertions.assertEquals((Object)originalError, (Object)error);
        Assertions.assertFalse((boolean)this.channel.isOpen());
    }

    @Test
    void shouldHandleMultipleExceptions() {
        RuntimeException error1 = new RuntimeException("Failure 1");
        RuntimeException error2 = new RuntimeException("Failure 2");
        this.channel.pipeline().fireExceptionCaught((Throwable)error1);
        this.channel.pipeline().fireExceptionCaught((Throwable)error2);
        Throwable error = this.messageDispatcher.currentError();
        Assertions.assertEquals((Object)error1, (Object)error);
        Assertions.assertFalse((boolean)this.channel.isOpen());
    }
}

