/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async.connection;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import java.util.Iterator;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.junit.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.internal.async.connection.ChannelAttributes;
import org.neo4j.driver.internal.async.connection.ChannelPipelineBuilderImpl;
import org.neo4j.driver.internal.async.inbound.ChannelErrorHandler;
import org.neo4j.driver.internal.async.inbound.ChunkDecoder;
import org.neo4j.driver.internal.async.inbound.InboundMessageDispatcher;
import org.neo4j.driver.internal.async.inbound.InboundMessageHandler;
import org.neo4j.driver.internal.async.inbound.MessageDecoder;
import org.neo4j.driver.internal.async.outbound.OutboundMessageHandler;
import org.neo4j.driver.internal.logging.DevNullLogging;
import org.neo4j.driver.internal.messaging.MessageFormat;
import org.neo4j.driver.internal.messaging.v3.MessageFormatV3;

class ChannelPipelineBuilderImplTest {
    ChannelPipelineBuilderImplTest() {
    }

    @Test
    void shouldBuildPipeline() {
        EmbeddedChannel channel = new EmbeddedChannel();
        ChannelAttributes.setMessageDispatcher((Channel)channel, (InboundMessageDispatcher)new InboundMessageDispatcher((Channel)channel, DevNullLogging.DEV_NULL_LOGGING));
        new ChannelPipelineBuilderImpl().build((MessageFormat)new MessageFormatV3(), channel.pipeline(), DevNullLogging.DEV_NULL_LOGGING);
        Iterator iterator = channel.pipeline().iterator();
        MatcherAssert.assertThat((Object)((ChannelHandler)((Map.Entry)iterator.next()).getValue()), (Matcher)Matchers.instanceOf(ChunkDecoder.class));
        MatcherAssert.assertThat((Object)((ChannelHandler)((Map.Entry)iterator.next()).getValue()), (Matcher)Matchers.instanceOf(MessageDecoder.class));
        MatcherAssert.assertThat((Object)((ChannelHandler)((Map.Entry)iterator.next()).getValue()), (Matcher)Matchers.instanceOf(InboundMessageHandler.class));
        MatcherAssert.assertThat((Object)((ChannelHandler)((Map.Entry)iterator.next()).getValue()), (Matcher)Matchers.instanceOf(OutboundMessageHandler.class));
        MatcherAssert.assertThat((Object)((ChannelHandler)((Map.Entry)iterator.next()).getValue()), (Matcher)Matchers.instanceOf(ChannelErrorHandler.class));
        Assertions.assertFalse((boolean)iterator.hasNext());
    }
}

