/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async.connection;

import io.netty.channel.Channel;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.ssl.SslHandler;
import java.security.GeneralSecurityException;
import java.util.List;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.junit.MatcherAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.RevocationStrategy;
import org.neo4j.driver.internal.async.connection.ChannelAttributes;
import org.neo4j.driver.internal.async.connection.NettyChannelInitializer;
import org.neo4j.driver.internal.logging.DevNullLogging;
import org.neo4j.driver.internal.security.SecurityPlan;
import org.neo4j.driver.internal.security.SecurityPlanImpl;
import org.neo4j.driver.internal.util.Clock;
import org.neo4j.driver.internal.util.FakeClock;

class NettyChannelInitializerTest {
    private final EmbeddedChannel channel = new EmbeddedChannel();

    NettyChannelInitializerTest() {
    }

    @AfterEach
    void tearDown() {
        this.channel.finishAndReleaseAll();
    }

    @Test
    void shouldAddSslHandlerWhenRequiresEncryption() throws Exception {
        SecurityPlan security = NettyChannelInitializerTest.trustAllCertificates();
        NettyChannelInitializer initializer = NettyChannelInitializerTest.newInitializer(security);
        initializer.initChannel((Channel)this.channel);
        Assertions.assertNotNull((Object)this.channel.pipeline().get(SslHandler.class));
    }

    @Test
    void shouldNotAddSslHandlerWhenDoesNotRequireEncryption() {
        SecurityPlan security = SecurityPlanImpl.insecure();
        NettyChannelInitializer initializer = NettyChannelInitializerTest.newInitializer(security);
        initializer.initChannel((Channel)this.channel);
        Assertions.assertNull((Object)this.channel.pipeline().get(SslHandler.class));
    }

    @Test
    void shouldAddSslHandlerWithHandshakeTimeout() throws Exception {
        int timeoutMillis = 424242;
        SecurityPlan security = NettyChannelInitializerTest.trustAllCertificates();
        NettyChannelInitializer initializer = NettyChannelInitializerTest.newInitializer(security, timeoutMillis);
        initializer.initChannel((Channel)this.channel);
        SslHandler sslHandler = (SslHandler)this.channel.pipeline().get(SslHandler.class);
        Assertions.assertNotNull((Object)sslHandler);
        Assertions.assertEquals((long)timeoutMillis, (long)sslHandler.getHandshakeTimeoutMillis());
    }

    @Test
    void shouldUpdateChannelAttributes() {
        Clock clock = (Clock)Mockito.mock(Clock.class);
        Mockito.when((Object)clock.millis()).thenReturn((Object)42L);
        SecurityPlan security = SecurityPlanImpl.insecure();
        NettyChannelInitializer initializer = NettyChannelInitializerTest.newInitializer(security, Integer.MAX_VALUE, clock);
        initializer.initChannel((Channel)this.channel);
        Assertions.assertEquals((Object)BoltServerAddress.LOCAL_DEFAULT, (Object)ChannelAttributes.serverAddress((Channel)this.channel));
        Assertions.assertEquals((long)42L, (long)ChannelAttributes.creationTimestamp((Channel)this.channel));
        Assertions.assertNotNull((Object)ChannelAttributes.messageDispatcher((Channel)this.channel));
    }

    @Test
    void shouldIncludeSniHostName() throws Exception {
        BoltServerAddress address = new BoltServerAddress("database.neo4j.com", 8989);
        NettyChannelInitializer initializer = new NettyChannelInitializer(address, NettyChannelInitializerTest.trustAllCertificates(), 10000, Clock.SYSTEM, DevNullLogging.DEV_NULL_LOGGING);
        initializer.initChannel((Channel)this.channel);
        SslHandler sslHandler = (SslHandler)this.channel.pipeline().get(SslHandler.class);
        SSLEngine sslEngine = sslHandler.engine();
        SSLParameters sslParameters = sslEngine.getSSLParameters();
        List<SNIServerName> sniServerNames = sslParameters.getServerNames();
        MatcherAssert.assertThat(sniServerNames, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)sniServerNames.get(0), (Matcher)Matchers.instanceOf(SNIHostName.class));
        MatcherAssert.assertThat((Object)((SNIHostName)sniServerNames.get(0)).getAsciiName(), (Matcher)Matchers.equalTo((Object)address.host()));
    }

    @Test
    void shouldEnableHostnameVerificationWhenConfigured() throws Exception {
        this.testHostnameVerificationSetting(true, "HTTPS");
    }

    @Test
    void shouldNotEnableHostnameVerificationWhenNotConfigured() throws Exception {
        this.testHostnameVerificationSetting(false, null);
    }

    private void testHostnameVerificationSetting(boolean enabled, String expectedValue) throws Exception {
        NettyChannelInitializer initializer = NettyChannelInitializerTest.newInitializer(SecurityPlanImpl.forAllCertificates((boolean)enabled, (RevocationStrategy)RevocationStrategy.NO_CHECKS));
        initializer.initChannel((Channel)this.channel);
        SslHandler sslHandler = (SslHandler)this.channel.pipeline().get(SslHandler.class);
        SSLEngine sslEngine = sslHandler.engine();
        SSLParameters sslParameters = sslEngine.getSSLParameters();
        Assertions.assertEquals((Object)expectedValue, (Object)sslParameters.getEndpointIdentificationAlgorithm());
    }

    private static NettyChannelInitializer newInitializer(SecurityPlan securityPlan) {
        return NettyChannelInitializerTest.newInitializer(securityPlan, Integer.MAX_VALUE);
    }

    private static NettyChannelInitializer newInitializer(SecurityPlan securityPlan, int connectTimeoutMillis) {
        return NettyChannelInitializerTest.newInitializer(securityPlan, connectTimeoutMillis, new FakeClock());
    }

    private static NettyChannelInitializer newInitializer(SecurityPlan securityPlan, int connectTimeoutMillis, Clock clock) {
        return new NettyChannelInitializer(BoltServerAddress.LOCAL_DEFAULT, securityPlan, connectTimeoutMillis, clock, DevNullLogging.DEV_NULL_LOGGING);
    }

    private static SecurityPlan trustAllCertificates() throws GeneralSecurityException {
        return SecurityPlanImpl.forAllCertificates((boolean)false, (RevocationStrategy)RevocationStrategy.NO_CHECKS);
    }
}

