/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async.inbound;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.driver.Logger;
import org.neo4j.driver.Logging;
import org.neo4j.driver.internal.async.inbound.ChunkDecoder;
import org.neo4j.driver.internal.logging.DevNullLogging;
import org.neo4j.driver.util.TestUtil;

class ChunkDecoderTest {
    private ByteBuf buffer;
    private EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{ChunkDecoderTest.newChunkDecoder()});

    ChunkDecoderTest() {
    }

    @AfterEach
    void tearDown() {
        if (this.buffer != null) {
            this.buffer.release(this.buffer.refCnt());
        }
        if (this.channel != null) {
            this.channel.finishAndReleaseAll();
        }
    }

    @Test
    void shouldDecodeFullChunk() {
        ByteBuf input = Unpooled.buffer();
        input.writeShort(7);
        input.writeByte(1);
        input.writeByte(11);
        input.writeByte(2);
        input.writeByte(22);
        input.writeByte(3);
        input.writeByte(33);
        input.writeByte(4);
        Assertions.assertTrue((boolean)this.channel.writeInbound(new Object[]{input}));
        Assertions.assertTrue((boolean)this.channel.finish());
        Assertions.assertEquals((int)1, (int)this.channel.inboundMessages().size());
        TestUtil.assertByteBufEquals(input.slice(2, 7), (ByteBuf)this.channel.readInbound());
    }

    @Test
    void shouldDecodeSplitChunk() {
        ByteBuf input1 = Unpooled.buffer();
        input1.writeShort(9);
        input1.writeByte(1);
        input1.writeByte(11);
        input1.writeByte(2);
        Assertions.assertFalse((boolean)this.channel.writeInbound(new Object[]{input1}));
        ByteBuf input2 = Unpooled.buffer();
        input2.writeByte(22);
        Assertions.assertFalse((boolean)this.channel.writeInbound(new Object[]{input2}));
        ByteBuf input3 = Unpooled.buffer();
        input3.writeByte(3);
        input3.writeByte(33);
        input3.writeByte(4);
        Assertions.assertFalse((boolean)this.channel.writeInbound(new Object[]{input3}));
        ByteBuf input4 = Unpooled.buffer();
        input4.writeByte(44);
        input4.writeByte(5);
        Assertions.assertTrue((boolean)this.channel.writeInbound(new Object[]{input4}));
        Assertions.assertTrue((boolean)this.channel.finish());
        Assertions.assertEquals((int)1, (int)this.channel.inboundMessages().size());
        TestUtil.assertByteBufEquals(Unpooled.wrappedBuffer((byte[])new byte[]{1, 11, 2, 22, 3, 33, 4, 44, 5}), (ByteBuf)this.channel.readInbound());
    }

    @Test
    void shouldDecodeEmptyChunk() {
        ByteBuf input = Unpooled.copyShort((int)0);
        Assertions.assertTrue((boolean)this.channel.writeInbound(new Object[]{input}));
        Assertions.assertTrue((boolean)this.channel.finish());
        Assertions.assertEquals((int)1, (int)this.channel.inboundMessages().size());
        TestUtil.assertByteBufEquals(Unpooled.wrappedBuffer((byte[])new byte[0]), (ByteBuf)this.channel.readInbound());
    }

    @Test
    void shouldLogEmptyChunkOnTraceLevel() {
        Logger logger = ChunkDecoderTest.newTraceLogger();
        this.channel = new EmbeddedChannel(new ChannelHandler[]{new ChunkDecoder(ChunkDecoderTest.newLogging(logger))});
        this.buffer = Unpooled.copyShort((int)0);
        Assertions.assertTrue((boolean)this.channel.writeInbound(new Object[]{this.buffer.copy()}));
        Assertions.assertTrue((boolean)this.channel.finish());
        ArgumentCaptor messageCaptor = ArgumentCaptor.forClass(String.class);
        ((Logger)Mockito.verify((Object)logger)).trace(ArgumentMatchers.anyString(), new Object[]{messageCaptor.capture()});
        Assertions.assertEquals((Object)ByteBufUtil.hexDump((ByteBuf)this.buffer), (Object)messageCaptor.getValue());
        Assertions.assertEquals((int)1, (int)this.channel.inboundMessages().size());
        TestUtil.assertByteBufEquals(Unpooled.wrappedBuffer((byte[])new byte[0]), (ByteBuf)this.channel.readInbound());
    }

    @Test
    void shouldLogNonEmptyChunkOnTraceLevel() {
        Logger logger = ChunkDecoderTest.newTraceLogger();
        this.channel = new EmbeddedChannel(new ChannelHandler[]{new ChunkDecoder(ChunkDecoderTest.newLogging(logger))});
        byte[] bytes = "Hello".getBytes();
        this.buffer = Unpooled.buffer();
        this.buffer.writeShort(bytes.length);
        this.buffer.writeBytes(bytes);
        Assertions.assertTrue((boolean)this.channel.writeInbound(new Object[]{this.buffer.copy()}));
        Assertions.assertTrue((boolean)this.channel.finish());
        ArgumentCaptor messageCaptor = ArgumentCaptor.forClass(String.class);
        ((Logger)Mockito.verify((Object)logger)).trace(ArgumentMatchers.anyString(), new Object[]{messageCaptor.capture()});
        Assertions.assertEquals((Object)ByteBufUtil.hexDump((ByteBuf)this.buffer), (Object)messageCaptor.getValue());
        Assertions.assertEquals((int)1, (int)this.channel.inboundMessages().size());
        TestUtil.assertByteBufEquals(Unpooled.wrappedBuffer((byte[])bytes), (ByteBuf)this.channel.readInbound());
    }

    @Test
    public void shouldDecodeMaxSizeChunk() {
        byte[] message = new byte[65535];
        ByteBuf input = Unpooled.buffer();
        input.writeShort(message.length);
        input.writeBytes(message);
        Assertions.assertTrue((boolean)this.channel.writeInbound(new Object[]{input}));
        Assertions.assertTrue((boolean)this.channel.finish());
        Assertions.assertEquals((int)1, (int)this.channel.inboundMessages().size());
        TestUtil.assertByteBufEquals(Unpooled.wrappedBuffer((byte[])message), (ByteBuf)this.channel.readInbound());
    }

    private static ChunkDecoder newChunkDecoder() {
        return new ChunkDecoder(DevNullLogging.DEV_NULL_LOGGING);
    }

    private static Logger newTraceLogger() {
        Logger logger = (Logger)Mockito.mock(Logger.class);
        Mockito.when((Object)logger.isTraceEnabled()).thenReturn((Object)true);
        return logger;
    }

    private static Logging newLogging(Logger logger) {
        Logging logging = (Logging)Mockito.mock(Logging.class);
        Mockito.when((Object)logging.getLog((Class)ArgumentMatchers.any(Class.class))).thenReturn((Object)logger);
        return logging;
    }
}

