/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async.inbound;

import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.exceptions.ServiceUnavailableException;
import org.neo4j.driver.internal.async.inbound.ConnectTimeoutHandler;

class ConnectTimeoutHandlerTest {
    private final EmbeddedChannel channel = new EmbeddedChannel();

    ConnectTimeoutHandlerTest() {
    }

    @AfterEach
    void tearDown() {
        this.channel.finishAndReleaseAll();
    }

    @Test
    void shouldFireExceptionOnTimeout() throws Exception {
        int timeoutMillis = 100;
        this.channel.pipeline().addLast(new ChannelHandler[]{new ConnectTimeoutHandler((long)timeoutMillis)});
        Thread.sleep(timeoutMillis * 4);
        this.channel.runPendingTasks();
        ServiceUnavailableException error = (ServiceUnavailableException)Assertions.assertThrows(ServiceUnavailableException.class, () -> ((EmbeddedChannel)this.channel).checkException());
        Assertions.assertEquals((Object)error.getMessage(), (Object)("Unable to establish connection in " + timeoutMillis + "ms"));
    }

    @Test
    void shouldNotFireExceptionMultipleTimes() throws Exception {
        int timeoutMillis = 70;
        this.channel.pipeline().addLast(new ChannelHandler[]{new ConnectTimeoutHandler((long)timeoutMillis)});
        Thread.sleep(timeoutMillis * 4);
        this.channel.runPendingTasks();
        ServiceUnavailableException error = (ServiceUnavailableException)Assertions.assertThrows(ServiceUnavailableException.class, () -> ((EmbeddedChannel)this.channel).checkException());
        Assertions.assertEquals((Object)error.getMessage(), (Object)("Unable to establish connection in " + timeoutMillis + "ms"));
        Thread.sleep(timeoutMillis * 4);
        this.channel.runPendingTasks();
        this.channel.checkException();
    }
}

