/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async.outbound;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;
import org.neo4j.driver.internal.async.outbound.ChunkAwareByteBufOutput;
import org.neo4j.driver.util.TestUtil;

class ChunkAwareByteBufOutputTest {
    ChunkAwareByteBufOutputTest() {
    }

    private static Stream<ByteBuf> testBuffers() {
        return IntStream.iterate(1, size -> size * 2).limit(20L).mapToObj(Unpooled::buffer);
    }

    @Test
    void shouldThrowForIllegalMaxChunkSize() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ChunkAwareByteBufOutput(-42));
    }

    @Test
    void shouldThrowWhenStartedWithNullBuf() {
        ChunkAwareByteBufOutput output = new ChunkAwareByteBufOutput(16);
        Assertions.assertThrows(NullPointerException.class, () -> output.start(null));
    }

    @Test
    void shouldThrowWhenStartedTwice() {
        ChunkAwareByteBufOutput output = new ChunkAwareByteBufOutput(16);
        output.start((ByteBuf)Mockito.mock(ByteBuf.class));
        Assertions.assertThrows(IllegalStateException.class, () -> output.start((ByteBuf)Mockito.mock(ByteBuf.class)));
    }

    @ParameterizedTest
    @MethodSource(value={"testBuffers"})
    void shouldWriteByteAtTheBeginningOfChunk(ByteBuf buf) {
        ChunkAwareByteBufOutput output = new ChunkAwareByteBufOutput(16);
        output.start(buf);
        output.writeByte((byte)42);
        output.stop();
        TestUtil.assertByteBufContains(buf, (short)1, (byte)42);
    }

    @ParameterizedTest
    @MethodSource(value={"testBuffers"})
    void shouldWriteByteWhenCurrentChunkContainsSpace(ByteBuf buf) {
        ChunkAwareByteBufOutput output = new ChunkAwareByteBufOutput(16);
        output.start(buf);
        output.writeByte((byte)1);
        output.writeByte((byte)2);
        output.writeByte((byte)-24);
        output.writeByte((byte)42);
        output.stop();
        TestUtil.assertByteBufContains(buf, (short)4, (byte)1, (byte)2, (byte)-24, (byte)42);
    }

    @ParameterizedTest
    @MethodSource(value={"testBuffers"})
    void shouldWriteByteWhenCurrentChunkIsFull(ByteBuf buf) {
        ChunkAwareByteBufOutput output = new ChunkAwareByteBufOutput(5);
        output.start(buf);
        output.writeByte((byte)5);
        output.writeByte((byte)3);
        output.writeByte((byte)-5);
        output.writeByte((byte)42);
        output.stop();
        TestUtil.assertByteBufContains(buf, (short)3, (byte)5, (byte)3, (byte)-5, (short)1, (byte)42);
    }

    @ParameterizedTest
    @MethodSource(value={"testBuffers"})
    void shouldWriteShortAtTheBeginningOfChunk(ByteBuf buf) {
        ChunkAwareByteBufOutput output = new ChunkAwareByteBufOutput(10);
        output.start(buf);
        output.writeShort((short)Short.MAX_VALUE);
        output.stop();
        TestUtil.assertByteBufContains(buf, (short)2, (short)Short.MAX_VALUE);
    }

    @ParameterizedTest
    @MethodSource(value={"testBuffers"})
    void shouldWriteShortWhenCurrentChunkContainsSpace(ByteBuf buf) {
        ChunkAwareByteBufOutput output = new ChunkAwareByteBufOutput(12);
        output.start(buf);
        output.writeShort((short)1);
        output.writeShort((short)42);
        output.writeShort((short)4242);
        output.writeShort((short)4242);
        output.writeShort((short)-30);
        output.stop();
        TestUtil.assertByteBufContains(buf, (short)10, (short)1, (short)42, (short)4242, (short)4242, (short)-30);
    }

    @ParameterizedTest
    @MethodSource(value={"testBuffers"})
    void shouldWriteShortWhenCurrentChunkIsFull(ByteBuf buf) {
        ChunkAwareByteBufOutput output = new ChunkAwareByteBufOutput(8);
        output.start(buf);
        output.writeShort((short)14);
        output.writeShort((short)-99);
        output.writeShort((short)202);
        output.writeShort((short)Short.MIN_VALUE);
        output.stop();
        TestUtil.assertByteBufContains(buf, (short)6, (short)14, (short)-99, (short)202, (short)2, (short)Short.MIN_VALUE);
    }

    @ParameterizedTest
    @MethodSource(value={"testBuffers"})
    void shouldWriteIntAtTheBeginningOfChunk(ByteBuf buf) {
        ChunkAwareByteBufOutput output = new ChunkAwareByteBufOutput(18);
        output.start(buf);
        output.writeInt(73649);
        output.stop();
        TestUtil.assertByteBufContains(buf, (short)4, 73649);
    }

    @ParameterizedTest
    @MethodSource(value={"testBuffers"})
    void shouldWriteIntWhenCurrentChunkContainsSpace(ByteBuf buf) {
        ChunkAwareByteBufOutput output = new ChunkAwareByteBufOutput(40);
        output.start(buf);
        output.writeInt(Integer.MAX_VALUE);
        output.writeInt(20);
        output.writeInt(-173);
        output.writeInt(Integer.MIN_VALUE);
        output.stop();
        TestUtil.assertByteBufContains(buf, (short)16, Integer.MAX_VALUE, 20, -173, Integer.MIN_VALUE);
    }

    @ParameterizedTest
    @MethodSource(value={"testBuffers"})
    void shouldWriteIntWhenCurrentChunkIsFull(ByteBuf buf) {
        ChunkAwareByteBufOutput output = new ChunkAwareByteBufOutput(27);
        output.start(buf);
        output.writeInt(42);
        output.writeInt(-73467193);
        output.writeInt(373);
        output.writeInt(-93);
        output.writeInt(1312345);
        output.writeInt(785);
        output.writeInt(42);
        output.stop();
        TestUtil.assertByteBufContains(buf, (short)24, 42, -73467193, 373, -93, 1312345, 785, (short)4, 42);
    }

    @ParameterizedTest
    @MethodSource(value={"testBuffers"})
    void shouldWriteLongAtTheBeginningOfChunk(ByteBuf buf) {
        ChunkAwareByteBufOutput output = new ChunkAwareByteBufOutput(12);
        output.start(buf);
        output.writeLong(15L);
        output.stop();
        TestUtil.assertByteBufContains(buf, (short)8, 15L);
    }

    @ParameterizedTest
    @MethodSource(value={"testBuffers"})
    void shouldWriteLongWhenCurrentChunkContainsSpace(ByteBuf buf) {
        ChunkAwareByteBufOutput output = new ChunkAwareByteBufOutput(34);
        output.start(buf);
        output.writeLong(Long.MAX_VALUE);
        output.writeLong(-1L);
        output.writeLong(-100L);
        output.writeLong(-4611686018427387904L);
        output.stop();
        TestUtil.assertByteBufContains(buf, (short)32, Long.MAX_VALUE, -1L, -100L, -4611686018427387904L);
    }

    @ParameterizedTest
    @MethodSource(value={"testBuffers"})
    void shouldWriteLongWhenCurrentChunkIsFull(ByteBuf buf) {
        ChunkAwareByteBufOutput output = new ChunkAwareByteBufOutput(38);
        output.start(buf);
        output.writeLong(12L);
        output.writeLong(8741L);
        output.writeLong(2314L);
        output.writeLong(-85793L);
        output.writeLong(-57999999L);
        output.stop();
        TestUtil.assertByteBufContains(buf, (short)32, 12L, 8741L, 2314L, -85793L, (short)8, -57999999L);
    }

    @ParameterizedTest
    @MethodSource(value={"testBuffers"})
    void shouldWriteDoubleAtTheBeginningOfChunk(ByteBuf buf) {
        ChunkAwareByteBufOutput output = new ChunkAwareByteBufOutput(10);
        output.start(buf);
        output.writeDouble(12.99937);
        output.stop();
        TestUtil.assertByteBufContains(buf, (short)8, 12.99937);
    }

    @ParameterizedTest
    @MethodSource(value={"testBuffers"})
    void shouldWriteDoubleWhenCurrentChunkContainsSpace(ByteBuf buf) {
        ChunkAwareByteBufOutput output = new ChunkAwareByteBufOutput(18);
        output.start(buf);
        output.writeDouble(-5.0);
        output.writeDouble(991.3333);
        output.stop();
        TestUtil.assertByteBufContains(buf, (short)16, -5.0, 991.3333);
    }

    @ParameterizedTest
    @MethodSource(value={"testBuffers"})
    void shouldWriteDoubleWhenCurrentChunkIsFull(ByteBuf buf) {
        ChunkAwareByteBufOutput output = new ChunkAwareByteBufOutput(20);
        output.start(buf);
        output.writeDouble(1839.0);
        output.writeDouble(5710923.34873);
        output.writeDouble(-47389.333399);
        output.stop();
        TestUtil.assertByteBufContains(buf, (short)16, 1839.0, 5710923.34873, (short)8, -47389.333399);
    }

    @ParameterizedTest
    @MethodSource(value={"testBuffers"})
    void shouldWriteBytesAtTheBeginningOfChunk(ByteBuf buf) {
        ChunkAwareByteBufOutput output = new ChunkAwareByteBufOutput(10);
        output.start(buf);
        output.writeBytes(new byte[]{1, 2, 3, -1, -2, -3, 127});
        output.stop();
        TestUtil.assertByteBufContains(buf, (short)7, (byte)1, (byte)2, (byte)3, (byte)-1, (byte)-2, (byte)-3, (byte)127);
    }

    @ParameterizedTest
    @MethodSource(value={"testBuffers"})
    void shouldWriteBytesWhenCurrentChunkContainsSpace(ByteBuf buf) {
        ChunkAwareByteBufOutput output = new ChunkAwareByteBufOutput(13);
        output.start(buf);
        output.writeBytes(new byte[]{9, 8, -10});
        output.writeBytes(new byte[]{127, 126, -128, -126});
        output.writeBytes(new byte[]{0, 99});
        output.writeBytes(new byte[]{-42, 42});
        output.stop();
        TestUtil.assertByteBufContains(buf, (short)11, (byte)9, (byte)8, (byte)-10, (byte)127, (byte)126, (byte)-128, (byte)-126, (byte)0, (byte)99, (byte)-42, (byte)42);
    }

    @ParameterizedTest
    @MethodSource(value={"testBuffers"})
    void shouldWriteBytesWhenCurrentChunkIsFull(ByteBuf buf) {
        ChunkAwareByteBufOutput output = new ChunkAwareByteBufOutput(9);
        output.start(buf);
        output.writeBytes(new byte[]{1, 2});
        output.writeBytes(new byte[]{3, 4, 5});
        output.writeBytes(new byte[]{10});
        output.writeBytes(new byte[]{-1, -42, -43});
        output.stop();
        TestUtil.assertByteBufContains(buf, (short)7, (byte)1, (byte)2, (byte)3, (byte)4, (byte)5, (byte)10, (byte)-1, (short)2, (byte)-42, (byte)-43);
    }

    @ParameterizedTest
    @MethodSource(value={"testBuffers"})
    void shouldWriteBytesThatSpanMultipleChunks(ByteBuf buf) {
        ChunkAwareByteBufOutput output = new ChunkAwareByteBufOutput(7);
        output.start(buf);
        output.writeBytes(new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18});
        output.stop();
        TestUtil.assertByteBufContains(buf, (short)5, (byte)1, (byte)2, (byte)3, (byte)4, (byte)5, (short)5, (byte)6, (byte)7, (byte)8, (byte)9, (byte)10, (short)5, (byte)11, (byte)12, (byte)13, (byte)14, (byte)15, (short)3, (byte)16, (byte)17, (byte)18);
    }

    @ParameterizedTest
    @MethodSource(value={"testBuffers"})
    void shouldWriteDataToMultipleChunks(ByteBuf buf) {
        ChunkAwareByteBufOutput output = new ChunkAwareByteBufOutput(13);
        output.start(buf);
        output.writeDouble(12.3);
        output.writeByte((byte)42);
        output.writeInt(-10);
        output.writeInt(99);
        output.writeLong(99L);
        output.writeBytes(new byte[]{9, 8, 7, 6});
        output.writeDouble(0.333);
        output.writeShort((short)0);
        output.writeShort((short)1);
        output.writeInt(12345);
        output.writeBytes(new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10});
        output.stop();
        TestUtil.assertByteBufContains(buf, (short)9, 12.3, (byte)42, (short)8, -10, 99, (short)11, 99L, (byte)9, (byte)8, (byte)7, (short)11, (byte)6, 0.333, (short)0, (short)11, (short)1, 12345, (byte)1, (byte)2, (byte)3, (byte)4, (byte)5, (short)5, (byte)6, (byte)7, (byte)8, (byte)9, (byte)10);
    }
}

