/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async.pool;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.ExecutionException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.async.connection.ChannelAttributes;
import org.neo4j.driver.internal.async.pool.ExtendedChannelPool;
import org.neo4j.driver.internal.async.pool.NettyChannelHealthChecker;
import org.neo4j.driver.internal.async.pool.NettyChannelTracker;
import org.neo4j.driver.internal.async.pool.PoolSettings;
import org.neo4j.driver.internal.async.pool.TestConnectionPool;
import org.neo4j.driver.internal.logging.DevNullLogging;
import org.neo4j.driver.internal.metrics.DevNullMetricsListener;
import org.neo4j.driver.internal.metrics.MetricsListener;
import org.neo4j.driver.internal.util.FakeClock;
import org.neo4j.driver.net.ServerAddress;

class ConnectionPoolImplTest {
    private static final BoltServerAddress ADDRESS_1 = new BoltServerAddress("server:1");
    private static final BoltServerAddress ADDRESS_2 = new BoltServerAddress("server:2");
    private static final BoltServerAddress ADDRESS_3 = new BoltServerAddress("server:3");

    ConnectionPoolImplTest() {
    }

    @Test
    void shouldDoNothingWhenRetainOnEmptyPool() {
        NettyChannelTracker nettyChannelTracker = (NettyChannelTracker)Mockito.mock(NettyChannelTracker.class);
        TestConnectionPool pool = ConnectionPoolImplTest.newConnectionPool(nettyChannelTracker);
        pool.retainAll(Collections.singleton(BoltServerAddress.LOCAL_DEFAULT));
        Mockito.verifyNoInteractions((Object[])new Object[]{nettyChannelTracker});
    }

    @Test
    void shouldRetainSpecifiedAddresses() {
        NettyChannelTracker nettyChannelTracker = (NettyChannelTracker)Mockito.mock(NettyChannelTracker.class);
        TestConnectionPool pool = ConnectionPoolImplTest.newConnectionPool(nettyChannelTracker);
        pool.acquire(ADDRESS_1);
        pool.acquire(ADDRESS_2);
        pool.acquire(ADDRESS_3);
        pool.retainAll(new HashSet<BoltServerAddress>(Arrays.asList(ADDRESS_1, ADDRESS_2, ADDRESS_3)));
        for (ExtendedChannelPool channelPool : pool.channelPoolsByAddress.values()) {
            Assertions.assertFalse((boolean)channelPool.isClosed());
        }
    }

    @Test
    void shouldClosePoolsWhenRetaining() {
        NettyChannelTracker nettyChannelTracker = (NettyChannelTracker)Mockito.mock(NettyChannelTracker.class);
        TestConnectionPool pool = ConnectionPoolImplTest.newConnectionPool(nettyChannelTracker);
        pool.acquire(ADDRESS_1);
        pool.acquire(ADDRESS_2);
        pool.acquire(ADDRESS_3);
        Mockito.when((Object)nettyChannelTracker.inUseChannelCount((ServerAddress)ADDRESS_1)).thenReturn((Object)2);
        Mockito.when((Object)nettyChannelTracker.inUseChannelCount((ServerAddress)ADDRESS_2)).thenReturn((Object)0);
        Mockito.when((Object)nettyChannelTracker.inUseChannelCount((ServerAddress)ADDRESS_3)).thenReturn((Object)3);
        pool.retainAll(new HashSet<BoltServerAddress>(Arrays.asList(ADDRESS_1, ADDRESS_3)));
        Assertions.assertFalse((boolean)pool.getPool(ADDRESS_1).isClosed());
        Assertions.assertTrue((boolean)pool.getPool(ADDRESS_2).isClosed());
        Assertions.assertFalse((boolean)pool.getPool(ADDRESS_3).isClosed());
    }

    @Test
    void shouldNotClosePoolsWithActiveConnectionsWhenRetaining() {
        NettyChannelTracker nettyChannelTracker = (NettyChannelTracker)Mockito.mock(NettyChannelTracker.class);
        TestConnectionPool pool = ConnectionPoolImplTest.newConnectionPool(nettyChannelTracker);
        pool.acquire(ADDRESS_1);
        pool.acquire(ADDRESS_2);
        pool.acquire(ADDRESS_3);
        Mockito.when((Object)nettyChannelTracker.inUseChannelCount((ServerAddress)ADDRESS_1)).thenReturn((Object)1);
        Mockito.when((Object)nettyChannelTracker.inUseChannelCount((ServerAddress)ADDRESS_2)).thenReturn((Object)42);
        Mockito.when((Object)nettyChannelTracker.inUseChannelCount((ServerAddress)ADDRESS_3)).thenReturn((Object)0);
        pool.retainAll(Collections.singleton(ADDRESS_2));
        Assertions.assertFalse((boolean)pool.getPool(ADDRESS_1).isClosed());
        Assertions.assertFalse((boolean)pool.getPool(ADDRESS_2).isClosed());
        Assertions.assertTrue((boolean)pool.getPool(ADDRESS_3).isClosed());
    }

    @Test
    void shouldRegisterAuthorizationStateListenerWithChannel() throws ExecutionException, InterruptedException {
        NettyChannelTracker nettyChannelTracker = (NettyChannelTracker)Mockito.mock(NettyChannelTracker.class);
        NettyChannelHealthChecker nettyChannelHealthChecker = (NettyChannelHealthChecker)Mockito.mock(NettyChannelHealthChecker.class);
        ArgumentCaptor channelArgumentCaptor = ArgumentCaptor.forClass(Channel.class);
        TestConnectionPool pool = ConnectionPoolImplTest.newConnectionPool(nettyChannelTracker, nettyChannelHealthChecker);
        pool.acquire(ADDRESS_1).toCompletableFuture().get();
        ((NettyChannelTracker)Mockito.verify((Object)nettyChannelTracker)).channelAcquired((Channel)channelArgumentCaptor.capture());
        Channel channel = (Channel)channelArgumentCaptor.getValue();
        Assertions.assertEquals((Object)nettyChannelHealthChecker, (Object)ChannelAttributes.authorizationStateListener((Channel)channel));
    }

    private static PoolSettings newSettings() {
        return new PoolSettings(10, 5000L, -1L, -1L);
    }

    private static TestConnectionPool newConnectionPool(NettyChannelTracker nettyChannelTracker) {
        return ConnectionPoolImplTest.newConnectionPool(nettyChannelTracker, (NettyChannelHealthChecker)Mockito.mock(NettyChannelHealthChecker.class));
    }

    private static TestConnectionPool newConnectionPool(NettyChannelTracker nettyChannelTracker, NettyChannelHealthChecker nettyChannelHealthChecker) {
        return new TestConnectionPool((Bootstrap)Mockito.mock(Bootstrap.class), nettyChannelTracker, nettyChannelHealthChecker, ConnectionPoolImplTest.newSettings(), (MetricsListener)DevNullMetricsListener.INSTANCE, DevNullLogging.DEV_NULL_LOGGING, new FakeClock(), true);
    }
}

