/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async.pool;

import io.netty.channel.Channel;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.channel.group.ChannelGroup;
import org.bouncycastle.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.async.connection.ChannelAttributes;
import org.neo4j.driver.internal.async.inbound.InboundMessageDispatcher;
import org.neo4j.driver.internal.async.pool.NettyChannelTracker;
import org.neo4j.driver.internal.logging.DevNullLogging;
import org.neo4j.driver.internal.messaging.BoltProtocolVersion;
import org.neo4j.driver.internal.messaging.request.GoodbyeMessage;
import org.neo4j.driver.internal.messaging.v3.BoltProtocolV3;
import org.neo4j.driver.internal.metrics.DevNullMetricsListener;
import org.neo4j.driver.internal.metrics.MetricsListener;
import org.neo4j.driver.net.ServerAddress;

class NettyChannelTrackerTest {
    private final BoltServerAddress address = BoltServerAddress.LOCAL_DEFAULT;
    private final NettyChannelTracker tracker = new NettyChannelTracker((MetricsListener)DevNullMetricsListener.INSTANCE, (ChannelGroup)Mockito.mock(ChannelGroup.class), DevNullLogging.DEV_NULL_LOGGING);

    NettyChannelTrackerTest() {
    }

    @Test
    void shouldIncrementIdleCountWhenChannelCreated() {
        Channel channel = this.newChannel();
        Assertions.assertEquals((int)0, (int)this.tracker.inUseChannelCount((ServerAddress)this.address));
        Assertions.assertEquals((int)0, (int)this.tracker.idleChannelCount((ServerAddress)this.address));
        this.tracker.channelCreated(channel, null);
        Assertions.assertEquals((int)0, (int)this.tracker.inUseChannelCount((ServerAddress)this.address));
        Assertions.assertEquals((int)1, (int)this.tracker.idleChannelCount((ServerAddress)this.address));
    }

    @Test
    void shouldIncrementInUseCountWhenChannelAcquired() {
        Channel channel = this.newChannel();
        Assertions.assertEquals((int)0, (int)this.tracker.inUseChannelCount((ServerAddress)this.address));
        Assertions.assertEquals((int)0, (int)this.tracker.idleChannelCount((ServerAddress)this.address));
        this.tracker.channelCreated(channel, null);
        Assertions.assertEquals((int)0, (int)this.tracker.inUseChannelCount((ServerAddress)this.address));
        Assertions.assertEquals((int)1, (int)this.tracker.idleChannelCount((ServerAddress)this.address));
        this.tracker.channelAcquired(channel);
        Assertions.assertEquals((int)1, (int)this.tracker.inUseChannelCount((ServerAddress)this.address));
        Assertions.assertEquals((int)0, (int)this.tracker.idleChannelCount((ServerAddress)this.address));
    }

    @Test
    void shouldIncrementIdleCountWhenChannelReleased() {
        Channel channel = this.newChannel();
        Assertions.assertEquals((int)0, (int)this.tracker.inUseChannelCount((ServerAddress)this.address));
        Assertions.assertEquals((int)0, (int)this.tracker.idleChannelCount((ServerAddress)this.address));
        this.channelCreatedAndAcquired(channel);
        Assertions.assertEquals((int)1, (int)this.tracker.inUseChannelCount((ServerAddress)this.address));
        Assertions.assertEquals((int)0, (int)this.tracker.idleChannelCount((ServerAddress)this.address));
        this.tracker.channelReleased(channel);
        Assertions.assertEquals((int)0, (int)this.tracker.inUseChannelCount((ServerAddress)this.address));
        Assertions.assertEquals((int)1, (int)this.tracker.idleChannelCount((ServerAddress)this.address));
    }

    @Test
    void shouldIncrementIdleCountForAddress() {
        Channel channel1 = this.newChannel();
        Channel channel2 = this.newChannel();
        Channel channel3 = this.newChannel();
        Assertions.assertEquals((int)0, (int)this.tracker.idleChannelCount((ServerAddress)this.address));
        this.tracker.channelCreated(channel1, null);
        Assertions.assertEquals((int)1, (int)this.tracker.idleChannelCount((ServerAddress)this.address));
        this.tracker.channelCreated(channel2, null);
        Assertions.assertEquals((int)2, (int)this.tracker.idleChannelCount((ServerAddress)this.address));
        this.tracker.channelCreated(channel3, null);
        Assertions.assertEquals((int)3, (int)this.tracker.idleChannelCount((ServerAddress)this.address));
        Assertions.assertEquals((int)0, (int)this.tracker.inUseChannelCount((ServerAddress)this.address));
    }

    @Test
    void shouldDecrementCountForAddress() {
        Channel channel1 = this.newChannel();
        Channel channel2 = this.newChannel();
        Channel channel3 = this.newChannel();
        this.channelCreatedAndAcquired(channel1);
        this.channelCreatedAndAcquired(channel2);
        this.channelCreatedAndAcquired(channel3);
        Assertions.assertEquals((int)3, (int)this.tracker.inUseChannelCount((ServerAddress)this.address));
        Assertions.assertEquals((int)0, (int)this.tracker.idleChannelCount((ServerAddress)this.address));
        this.tracker.channelReleased(channel1);
        Assertions.assertEquals((int)2, (int)this.tracker.inUseChannelCount((ServerAddress)this.address));
        Assertions.assertEquals((int)1, (int)this.tracker.idleChannelCount((ServerAddress)this.address));
        this.tracker.channelReleased(channel2);
        Assertions.assertEquals((int)1, (int)this.tracker.inUseChannelCount((ServerAddress)this.address));
        Assertions.assertEquals((int)2, (int)this.tracker.idleChannelCount((ServerAddress)this.address));
        this.tracker.channelReleased(channel3);
        Assertions.assertEquals((int)0, (int)this.tracker.inUseChannelCount((ServerAddress)this.address));
        Assertions.assertEquals((int)3, (int)this.tracker.idleChannelCount((ServerAddress)this.address));
    }

    @Test
    void shouldDecreaseIdleWhenClosedOutsidePool() throws Throwable {
        Channel channel = this.newChannel();
        this.channelCreatedAndAcquired(channel);
        Assertions.assertEquals((int)1, (int)this.tracker.inUseChannelCount((ServerAddress)this.address));
        Assertions.assertEquals((int)0, (int)this.tracker.idleChannelCount((ServerAddress)this.address));
        channel.close().sync();
        Assertions.assertEquals((int)1, (int)this.tracker.inUseChannelCount((ServerAddress)this.address));
        Assertions.assertEquals((int)0, (int)this.tracker.idleChannelCount((ServerAddress)this.address));
        this.tracker.channelReleased(channel);
        Assertions.assertEquals((int)0, (int)this.tracker.inUseChannelCount((ServerAddress)this.address));
        Assertions.assertEquals((int)0, (int)this.tracker.idleChannelCount((ServerAddress)this.address));
    }

    @Test
    void shouldDecreaseIdleWhenClosedInsidePool() throws Throwable {
        Channel channel = this.newChannel();
        this.channelCreatedAndAcquired(channel);
        Assertions.assertEquals((int)1, (int)this.tracker.inUseChannelCount((ServerAddress)this.address));
        Assertions.assertEquals((int)0, (int)this.tracker.idleChannelCount((ServerAddress)this.address));
        this.tracker.channelReleased(channel);
        Assertions.assertEquals((int)0, (int)this.tracker.inUseChannelCount((ServerAddress)this.address));
        Assertions.assertEquals((int)1, (int)this.tracker.idleChannelCount((ServerAddress)this.address));
        channel.close().sync();
        Assertions.assertEquals((int)0, (int)this.tracker.inUseChannelCount((ServerAddress)this.address));
        Assertions.assertEquals((int)0, (int)this.tracker.idleChannelCount((ServerAddress)this.address));
    }

    @Test
    void shouldThrowWhenDecrementingForUnknownAddress() {
        Channel channel = this.newChannel();
        Assertions.assertThrows(IllegalStateException.class, () -> this.tracker.channelReleased(channel));
    }

    @Test
    void shouldReturnZeroActiveCountForUnknownAddress() {
        Assertions.assertEquals((int)0, (int)this.tracker.inUseChannelCount((ServerAddress)this.address));
    }

    @Test
    void shouldAddChannelToGroupWhenChannelCreated() {
        Channel channel = this.newChannel();
        Channel anotherChannel = this.newChannel();
        ChannelGroup group = (ChannelGroup)Mockito.mock(ChannelGroup.class);
        NettyChannelTracker tracker = new NettyChannelTracker((MetricsListener)DevNullMetricsListener.INSTANCE, group, DevNullLogging.DEV_NULL_LOGGING);
        tracker.channelCreated(channel, null);
        tracker.channelCreated(anotherChannel, null);
        ((ChannelGroup)Mockito.verify((Object)group)).add((Object)channel);
        ((ChannelGroup)Mockito.verify((Object)group)).add((Object)anotherChannel);
    }

    @Test
    void shouldDelegateToProtocolPrepareToClose() {
        EmbeddedChannel channel = this.newChannelWithProtocolV3();
        EmbeddedChannel anotherChannel = this.newChannelWithProtocolV3();
        ChannelGroup group = (ChannelGroup)Mockito.mock(ChannelGroup.class);
        Mockito.when((Object)group.iterator()).thenReturn((Object)new Arrays.Iterator((Object[])new Channel[]{channel, anotherChannel}));
        NettyChannelTracker tracker = new NettyChannelTracker((MetricsListener)DevNullMetricsListener.INSTANCE, group, DevNullLogging.DEV_NULL_LOGGING);
        tracker.prepareToCloseChannels();
        MatcherAssert.assertThat((Object)channel.outboundMessages().size(), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)channel.outboundMessages(), (Matcher)Matchers.hasItem((Object)GoodbyeMessage.GOODBYE));
        MatcherAssert.assertThat((Object)anotherChannel.outboundMessages().size(), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)anotherChannel.outboundMessages(), (Matcher)Matchers.hasItem((Object)GoodbyeMessage.GOODBYE));
    }

    private Channel newChannel() {
        EmbeddedChannel channel = new EmbeddedChannel();
        ChannelAttributes.setServerAddress((Channel)channel, (BoltServerAddress)this.address);
        return channel;
    }

    private EmbeddedChannel newChannelWithProtocolV3() {
        EmbeddedChannel channel = new EmbeddedChannel();
        ChannelAttributes.setServerAddress((Channel)channel, (BoltServerAddress)this.address);
        ChannelAttributes.setProtocolVersion((Channel)channel, (BoltProtocolVersion)BoltProtocolV3.VERSION);
        ChannelAttributes.setMessageDispatcher((Channel)channel, (InboundMessageDispatcher)((InboundMessageDispatcher)Mockito.mock(InboundMessageDispatcher.class)));
        return channel;
    }

    private void channelCreatedAndAcquired(Channel channel) {
        this.tracker.channelCreated(channel, null);
        this.tracker.channelAcquired(channel);
    }
}

