/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async.pool;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.embedded.EmbeddedChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import org.mockito.Mockito;
import org.neo4j.driver.Logging;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.async.connection.ChannelAttributes;
import org.neo4j.driver.internal.async.connection.ChannelConnector;
import org.neo4j.driver.internal.async.pool.ConnectionFactory;
import org.neo4j.driver.internal.async.pool.ConnectionPoolImpl;
import org.neo4j.driver.internal.async.pool.ExtendedChannelPool;
import org.neo4j.driver.internal.async.pool.NettyChannelHealthChecker;
import org.neo4j.driver.internal.async.pool.NettyChannelTracker;
import org.neo4j.driver.internal.async.pool.PoolSettings;
import org.neo4j.driver.internal.metrics.ListenerEvent;
import org.neo4j.driver.internal.metrics.MetricsListener;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.util.Clock;
import org.neo4j.driver.internal.util.Futures;

public class TestConnectionPool
extends ConnectionPoolImpl {
    final Map<BoltServerAddress, ExtendedChannelPool> channelPoolsByAddress = new HashMap<BoltServerAddress, ExtendedChannelPool>();
    private final NettyChannelTracker nettyChannelTracker;

    public TestConnectionPool(Bootstrap bootstrap, NettyChannelTracker nettyChannelTracker, NettyChannelHealthChecker nettyChannelHealthChecker, PoolSettings settings, MetricsListener metricsListener, Logging logging, Clock clock, boolean ownsEventLoopGroup) {
        super((ChannelConnector)Mockito.mock(ChannelConnector.class), bootstrap, nettyChannelTracker, nettyChannelHealthChecker, settings, metricsListener, logging, clock, ownsEventLoopGroup, TestConnectionPool.newConnectionFactory());
        this.nettyChannelTracker = nettyChannelTracker;
    }

    ExtendedChannelPool getPool(BoltServerAddress address) {
        return this.channelPoolsByAddress.get(address);
    }

    ExtendedChannelPool newPool(final BoltServerAddress address) {
        ExtendedChannelPool channelPool = new ExtendedChannelPool(){
            private final AtomicBoolean isClosed = new AtomicBoolean(false);

            public CompletionStage<Channel> acquire() {
                EmbeddedChannel channel = new EmbeddedChannel();
                ChannelAttributes.setServerAddress((Channel)channel, (BoltServerAddress)address);
                ChannelAttributes.setPoolId((Channel)channel, (String)this.id());
                ListenerEvent event = TestConnectionPool.this.nettyChannelTracker.channelCreating(this.id());
                TestConnectionPool.this.nettyChannelTracker.channelCreated((Channel)channel, event);
                TestConnectionPool.this.nettyChannelTracker.channelAcquired((Channel)channel);
                return CompletableFuture.completedFuture(channel);
            }

            public CompletionStage<Void> release(Channel channel) {
                TestConnectionPool.this.nettyChannelTracker.channelReleased(channel);
                TestConnectionPool.this.nettyChannelTracker.channelClosed(channel);
                return Futures.completedWithNull();
            }

            public boolean isClosed() {
                return this.isClosed.get();
            }

            public String id() {
                return "Pool-" + this.hashCode();
            }

            public CompletionStage<Void> close() {
                this.isClosed.set(true);
                return Futures.completedWithNull();
            }
        };
        this.channelPoolsByAddress.put(address, channelPool);
        return channelPool;
    }

    private static ConnectionFactory newConnectionFactory() {
        return (channel, pool) -> {
            Connection conn = (Connection)Mockito.mock(Connection.class);
            Mockito.when((Object)conn.release()).thenAnswer(invocation -> pool.release(channel));
            return conn;
        };
    }
}

