/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cluster;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.junit.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.Record;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.InternalRecord;
import org.neo4j.driver.internal.cluster.ClusterComposition;
import org.neo4j.driver.internal.util.ClusterCompositionUtil;

class ClusterCompositionTest {
    ClusterCompositionTest() {
    }

    @Test
    void hasWritersReturnsFalseWhenNoWriters() {
        ClusterComposition composition = ClusterCompositionTest.newComposition(1L, ClusterCompositionTest.addresses(ClusterCompositionUtil.A, ClusterCompositionUtil.B), ClusterCompositionTest.addresses(new BoltServerAddress[0]), ClusterCompositionTest.addresses(ClusterCompositionUtil.C, ClusterCompositionUtil.D));
        Assertions.assertFalse((boolean)composition.hasWriters());
    }

    @Test
    void hasWritersReturnsTrueWhenSomeWriters() {
        ClusterComposition composition = ClusterCompositionTest.newComposition(1L, ClusterCompositionTest.addresses(ClusterCompositionUtil.A, ClusterCompositionUtil.B), ClusterCompositionTest.addresses(ClusterCompositionUtil.C, ClusterCompositionUtil.D), ClusterCompositionTest.addresses(ClusterCompositionUtil.E, ClusterCompositionUtil.F));
        Assertions.assertTrue((boolean)composition.hasWriters());
    }

    @Test
    void hasRoutersAndReadersReturnsFalseWhenNoRouters() {
        ClusterComposition composition = ClusterCompositionTest.newComposition(1L, ClusterCompositionTest.addresses(ClusterCompositionUtil.A, ClusterCompositionUtil.B), ClusterCompositionTest.addresses(ClusterCompositionUtil.C, ClusterCompositionUtil.D), ClusterCompositionTest.addresses(new BoltServerAddress[0]));
        Assertions.assertFalse((boolean)composition.hasRoutersAndReaders());
    }

    @Test
    void hasRoutersAndReadersReturnsFalseWhenNoReaders() {
        ClusterComposition composition = ClusterCompositionTest.newComposition(1L, ClusterCompositionTest.addresses(new BoltServerAddress[0]), ClusterCompositionTest.addresses(ClusterCompositionUtil.A, ClusterCompositionUtil.B), ClusterCompositionTest.addresses(ClusterCompositionUtil.C, ClusterCompositionUtil.D));
        Assertions.assertFalse((boolean)composition.hasRoutersAndReaders());
    }

    @Test
    void hasRoutersAndReadersWhenSomeReadersAndRouters() {
        ClusterComposition composition = ClusterCompositionTest.newComposition(1L, ClusterCompositionTest.addresses(ClusterCompositionUtil.A, ClusterCompositionUtil.B), ClusterCompositionTest.addresses(ClusterCompositionUtil.C, ClusterCompositionUtil.D), ClusterCompositionTest.addresses(ClusterCompositionUtil.E, ClusterCompositionUtil.F));
        Assertions.assertTrue((boolean)composition.hasRoutersAndReaders());
    }

    @Test
    void readersWhenEmpty() {
        ClusterComposition composition = ClusterCompositionTest.newComposition(1L, ClusterCompositionTest.addresses(new BoltServerAddress[0]), ClusterCompositionTest.addresses(ClusterCompositionUtil.A, ClusterCompositionUtil.B), ClusterCompositionTest.addresses(ClusterCompositionUtil.C, ClusterCompositionUtil.D));
        Assertions.assertEquals((int)0, (int)composition.readers().size());
    }

    @Test
    void writersWhenEmpty() {
        ClusterComposition composition = ClusterCompositionTest.newComposition(1L, ClusterCompositionTest.addresses(ClusterCompositionUtil.A, ClusterCompositionUtil.B), ClusterCompositionTest.addresses(new BoltServerAddress[0]), ClusterCompositionTest.addresses(ClusterCompositionUtil.C, ClusterCompositionUtil.D));
        Assertions.assertEquals((int)0, (int)composition.writers().size());
    }

    @Test
    void routersWhenEmpty() {
        ClusterComposition composition = ClusterCompositionTest.newComposition(1L, ClusterCompositionTest.addresses(ClusterCompositionUtil.A, ClusterCompositionUtil.B), ClusterCompositionTest.addresses(ClusterCompositionUtil.C, ClusterCompositionUtil.D), ClusterCompositionTest.addresses(new BoltServerAddress[0]));
        Assertions.assertEquals((int)0, (int)composition.routers().size());
    }

    @Test
    void readersWhenNonEmpty() {
        ClusterComposition composition = ClusterCompositionTest.newComposition(1L, ClusterCompositionTest.addresses(ClusterCompositionUtil.A, ClusterCompositionUtil.B), ClusterCompositionTest.addresses(ClusterCompositionUtil.C, ClusterCompositionUtil.D), ClusterCompositionTest.addresses(ClusterCompositionUtil.E, ClusterCompositionUtil.F));
        Assertions.assertEquals(ClusterCompositionTest.addresses(ClusterCompositionUtil.A, ClusterCompositionUtil.B), (Object)composition.readers());
    }

    @Test
    void writersWhenNonEmpty() {
        ClusterComposition composition = ClusterCompositionTest.newComposition(1L, ClusterCompositionTest.addresses(ClusterCompositionUtil.A, ClusterCompositionUtil.B), ClusterCompositionTest.addresses(ClusterCompositionUtil.C, ClusterCompositionUtil.D), ClusterCompositionTest.addresses(ClusterCompositionUtil.E, ClusterCompositionUtil.F));
        Assertions.assertEquals(ClusterCompositionTest.addresses(ClusterCompositionUtil.C, ClusterCompositionUtil.D), (Object)composition.writers());
    }

    @Test
    void routersWhenNonEmpty() {
        ClusterComposition composition = ClusterCompositionTest.newComposition(1L, ClusterCompositionTest.addresses(ClusterCompositionUtil.A, ClusterCompositionUtil.B), ClusterCompositionTest.addresses(ClusterCompositionUtil.C, ClusterCompositionUtil.D), ClusterCompositionTest.addresses(ClusterCompositionUtil.E, ClusterCompositionUtil.F));
        Assertions.assertEquals(ClusterCompositionTest.addresses(ClusterCompositionUtil.E, ClusterCompositionUtil.F), (Object)composition.routers());
    }

    @Test
    void expirationTimestamp() {
        ClusterComposition composition = ClusterCompositionTest.newComposition(42L, ClusterCompositionTest.addresses(ClusterCompositionUtil.A, ClusterCompositionUtil.B), ClusterCompositionTest.addresses(ClusterCompositionUtil.C, ClusterCompositionUtil.D), ClusterCompositionTest.addresses(ClusterCompositionUtil.E, ClusterCompositionUtil.F));
        Assertions.assertEquals((long)42L, (long)composition.expirationTimestamp());
    }

    @Test
    void parseCorrectRecord() {
        Value[] values = new Value[]{Values.value((long)42L), Values.value(Arrays.asList(ClusterCompositionTest.serversEntry("READ", ClusterCompositionUtil.A, ClusterCompositionUtil.B), ClusterCompositionTest.serversEntry("WRITE", ClusterCompositionUtil.C, ClusterCompositionUtil.D), ClusterCompositionTest.serversEntry("ROUTE", ClusterCompositionUtil.E, ClusterCompositionUtil.F)))};
        InternalRecord record = new InternalRecord(Arrays.asList("ttl", "servers"), values);
        ClusterComposition composition = ClusterComposition.parse((Record)record, (long)0L);
        Assertions.assertEquals((long)42000L, (long)composition.expirationTimestamp());
        Assertions.assertEquals(ClusterCompositionTest.addresses(ClusterCompositionUtil.A, ClusterCompositionUtil.B), (Object)composition.readers());
        Assertions.assertEquals(ClusterCompositionTest.addresses(ClusterCompositionUtil.C, ClusterCompositionUtil.D), (Object)composition.writers());
        Assertions.assertEquals(ClusterCompositionTest.addresses(ClusterCompositionUtil.E, ClusterCompositionUtil.F), (Object)composition.routers());
    }

    @Test
    void parsePreservesOrderOfReaders() {
        Value[] values = new Value[]{Values.value((long)42L), Values.value(Arrays.asList(ClusterCompositionTest.serversEntry("READ", ClusterCompositionUtil.A, ClusterCompositionUtil.C, ClusterCompositionUtil.E, ClusterCompositionUtil.B, ClusterCompositionUtil.F, ClusterCompositionUtil.D), ClusterCompositionTest.serversEntry("WRITE", new BoltServerAddress[0]), ClusterCompositionTest.serversEntry("ROUTE", new BoltServerAddress[0])))};
        InternalRecord record = new InternalRecord(Arrays.asList("ttl", "servers"), values);
        ClusterComposition composition = ClusterComposition.parse((Record)record, (long)0L);
        MatcherAssert.assertThat((Object)composition.readers(), (Matcher)Matchers.contains((Object[])new BoltServerAddress[]{ClusterCompositionUtil.A, ClusterCompositionUtil.C, ClusterCompositionUtil.E, ClusterCompositionUtil.B, ClusterCompositionUtil.F, ClusterCompositionUtil.D}));
        Assertions.assertEquals((int)0, (int)composition.writers().size());
        Assertions.assertEquals((int)0, (int)composition.routers().size());
    }

    @Test
    void parsePreservesOrderOfWriters() {
        Value[] values = new Value[]{Values.value((long)42L), Values.value(Arrays.asList(ClusterCompositionTest.serversEntry("READ", new BoltServerAddress[0]), ClusterCompositionTest.serversEntry("WRITE", ClusterCompositionUtil.C, ClusterCompositionUtil.F, ClusterCompositionUtil.D, ClusterCompositionUtil.A, ClusterCompositionUtil.B, ClusterCompositionUtil.E), ClusterCompositionTest.serversEntry("ROUTE", new BoltServerAddress[0])))};
        InternalRecord record = new InternalRecord(Arrays.asList("ttl", "servers"), values);
        ClusterComposition composition = ClusterComposition.parse((Record)record, (long)0L);
        Assertions.assertEquals((int)0, (int)composition.readers().size());
        MatcherAssert.assertThat((Object)composition.writers(), (Matcher)Matchers.contains((Object[])new BoltServerAddress[]{ClusterCompositionUtil.C, ClusterCompositionUtil.F, ClusterCompositionUtil.D, ClusterCompositionUtil.A, ClusterCompositionUtil.B, ClusterCompositionUtil.E}));
        Assertions.assertEquals((int)0, (int)composition.routers().size());
    }

    @Test
    void parsePreservesOrderOfRouters() {
        Value[] values = new Value[]{Values.value((long)42L), Values.value(Arrays.asList(ClusterCompositionTest.serversEntry("READ", new BoltServerAddress[0]), ClusterCompositionTest.serversEntry("WRITE", new BoltServerAddress[0]), ClusterCompositionTest.serversEntry("ROUTE", ClusterCompositionUtil.F, ClusterCompositionUtil.D, ClusterCompositionUtil.A, ClusterCompositionUtil.B, ClusterCompositionUtil.C, ClusterCompositionUtil.E)))};
        InternalRecord record = new InternalRecord(Arrays.asList("ttl", "servers"), values);
        ClusterComposition composition = ClusterComposition.parse((Record)record, (long)0L);
        Assertions.assertEquals((int)0, (int)composition.readers().size());
        Assertions.assertEquals((int)0, (int)composition.writers().size());
        MatcherAssert.assertThat((Object)composition.routers(), (Matcher)Matchers.contains((Object[])new BoltServerAddress[]{ClusterCompositionUtil.F, ClusterCompositionUtil.D, ClusterCompositionUtil.A, ClusterCompositionUtil.B, ClusterCompositionUtil.C, ClusterCompositionUtil.E}));
    }

    private static ClusterComposition newComposition(long expirationTimestamp, Set<BoltServerAddress> readers, Set<BoltServerAddress> writers, Set<BoltServerAddress> routers) {
        return new ClusterComposition(expirationTimestamp, readers, writers, routers, null);
    }

    private static Set<BoltServerAddress> addresses(BoltServerAddress ... elements) {
        return new LinkedHashSet<BoltServerAddress>(Arrays.asList(elements));
    }

    private static Map<String, Object> serversEntry(String role, BoltServerAddress ... addresses) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("role", role);
        ArrayList<String> addressStrings = new ArrayList<String>();
        for (BoltServerAddress address : addresses) {
            addressStrings.add(address.toString());
        }
        map.put("addresses", addressStrings);
        return map;
    }
}

