/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cluster;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.DatabaseNameUtil;
import org.neo4j.driver.internal.cluster.ClusterRoutingTable;
import org.neo4j.driver.internal.util.Clock;
import org.neo4j.driver.internal.util.ClusterCompositionUtil;
import org.neo4j.driver.internal.util.FakeClock;

class ClusterRoutingTableTest {
    ClusterRoutingTableTest() {
    }

    @Test
    void shouldReturnStaleIfTtlExpired() {
        FakeClock clock = new FakeClock();
        ClusterRoutingTable routingTable = this.newRoutingTable(clock);
        routingTable.update(ClusterCompositionUtil.createClusterComposition(1000L, Arrays.asList(ClusterCompositionUtil.A, ClusterCompositionUtil.B), Arrays.asList(ClusterCompositionUtil.C), Arrays.asList(ClusterCompositionUtil.D, ClusterCompositionUtil.E)));
        clock.progress(1234L);
        Assertions.assertTrue((boolean)routingTable.isStaleFor(AccessMode.READ));
        Assertions.assertTrue((boolean)routingTable.isStaleFor(AccessMode.WRITE));
    }

    @Test
    void shouldReturnStaleIfNoRouter() {
        ClusterRoutingTable routingTable = this.newRoutingTable();
        routingTable.update(ClusterCompositionUtil.createClusterComposition(ClusterCompositionUtil.EMPTY, Arrays.asList(ClusterCompositionUtil.C), Arrays.asList(ClusterCompositionUtil.D, ClusterCompositionUtil.E)));
        Assertions.assertTrue((boolean)routingTable.isStaleFor(AccessMode.READ));
        Assertions.assertTrue((boolean)routingTable.isStaleFor(AccessMode.WRITE));
    }

    @Test
    void shouldBeStaleForReadsButNotWritesWhenNoReaders() {
        ClusterRoutingTable routingTable = this.newRoutingTable();
        routingTable.update(ClusterCompositionUtil.createClusterComposition(Arrays.asList(ClusterCompositionUtil.A, ClusterCompositionUtil.B), Arrays.asList(ClusterCompositionUtil.C), ClusterCompositionUtil.EMPTY));
        Assertions.assertTrue((boolean)routingTable.isStaleFor(AccessMode.READ));
        Assertions.assertFalse((boolean)routingTable.isStaleFor(AccessMode.WRITE));
    }

    @Test
    void shouldBeStaleForWritesButNotReadsWhenNoWriters() {
        ClusterRoutingTable routingTable = this.newRoutingTable();
        routingTable.update(ClusterCompositionUtil.createClusterComposition(Arrays.asList(ClusterCompositionUtil.A, ClusterCompositionUtil.B), ClusterCompositionUtil.EMPTY, Arrays.asList(ClusterCompositionUtil.D, ClusterCompositionUtil.E)));
        Assertions.assertFalse((boolean)routingTable.isStaleFor(AccessMode.READ));
        Assertions.assertTrue((boolean)routingTable.isStaleFor(AccessMode.WRITE));
    }

    @Test
    void shouldBeNotStaleWithReadersWritersAndRouters() {
        ClusterRoutingTable routingTable = this.newRoutingTable();
        routingTable.update(ClusterCompositionUtil.createClusterComposition(Arrays.asList(ClusterCompositionUtil.A, ClusterCompositionUtil.B), Arrays.asList(ClusterCompositionUtil.C), Arrays.asList(ClusterCompositionUtil.D, ClusterCompositionUtil.E)));
        Assertions.assertFalse((boolean)routingTable.isStaleFor(AccessMode.READ));
        Assertions.assertFalse((boolean)routingTable.isStaleFor(AccessMode.WRITE));
    }

    @Test
    void shouldBeStaleForReadsAndWritesAfterCreation() {
        FakeClock clock = new FakeClock();
        ClusterRoutingTable routingTable = new ClusterRoutingTable(DatabaseNameUtil.defaultDatabase(), (Clock)clock, new BoltServerAddress[]{ClusterCompositionUtil.A});
        Assertions.assertTrue((boolean)routingTable.isStaleFor(AccessMode.READ));
        Assertions.assertTrue((boolean)routingTable.isStaleFor(AccessMode.WRITE));
    }

    @ParameterizedTest
    @ValueSource(strings={"Molly", "", "I AM A NAME"})
    void shouldReturnDatabaseNameCorrectly(String db) {
        FakeClock clock = new FakeClock();
        ClusterRoutingTable routingTable = new ClusterRoutingTable(DatabaseNameUtil.database((String)db), (Clock)clock, new BoltServerAddress[]{ClusterCompositionUtil.A});
        Assertions.assertEquals((Object)db, (Object)routingTable.database().description());
    }

    @Test
    void shouldContainInitialRouters() {
        FakeClock clock = new FakeClock();
        ClusterRoutingTable routingTable = new ClusterRoutingTable(DatabaseNameUtil.defaultDatabase(), (Clock)clock, new BoltServerAddress[]{ClusterCompositionUtil.A, ClusterCompositionUtil.B, ClusterCompositionUtil.C});
        Assertions.assertArrayEquals((Object[])new BoltServerAddress[]{ClusterCompositionUtil.A, ClusterCompositionUtil.B, ClusterCompositionUtil.C}, (Object[])routingTable.routers().toArray());
        Assertions.assertArrayEquals((Object[])new BoltServerAddress[0], (Object[])routingTable.readers().toArray());
        Assertions.assertArrayEquals((Object[])new BoltServerAddress[0], (Object[])routingTable.writers().toArray());
    }

    @Test
    void shouldPreserveOrderingOfRouters() {
        ClusterRoutingTable routingTable = this.newRoutingTable();
        List<BoltServerAddress> routers = Arrays.asList(ClusterCompositionUtil.A, ClusterCompositionUtil.C, ClusterCompositionUtil.D, ClusterCompositionUtil.F, ClusterCompositionUtil.B, ClusterCompositionUtil.E);
        routingTable.update(ClusterCompositionUtil.createClusterComposition(routers, ClusterCompositionUtil.EMPTY, ClusterCompositionUtil.EMPTY));
        Assertions.assertArrayEquals((Object[])new BoltServerAddress[]{ClusterCompositionUtil.A, ClusterCompositionUtil.C, ClusterCompositionUtil.D, ClusterCompositionUtil.F, ClusterCompositionUtil.B, ClusterCompositionUtil.E}, (Object[])routingTable.routers().toArray());
    }

    @Test
    void shouldPreserveOrderingOfWriters() {
        ClusterRoutingTable routingTable = this.newRoutingTable();
        List<BoltServerAddress> writers = Arrays.asList(ClusterCompositionUtil.D, ClusterCompositionUtil.F, ClusterCompositionUtil.A, ClusterCompositionUtil.C, ClusterCompositionUtil.E);
        routingTable.update(ClusterCompositionUtil.createClusterComposition(ClusterCompositionUtil.EMPTY, writers, ClusterCompositionUtil.EMPTY));
        Assertions.assertArrayEquals((Object[])new BoltServerAddress[]{ClusterCompositionUtil.D, ClusterCompositionUtil.F, ClusterCompositionUtil.A, ClusterCompositionUtil.C, ClusterCompositionUtil.E}, (Object[])routingTable.writers().toArray());
    }

    @Test
    void shouldPreserveOrderingOfReaders() {
        ClusterRoutingTable routingTable = this.newRoutingTable();
        List<BoltServerAddress> readers = Arrays.asList(ClusterCompositionUtil.B, ClusterCompositionUtil.A, ClusterCompositionUtil.F, ClusterCompositionUtil.C, ClusterCompositionUtil.D);
        routingTable.update(ClusterCompositionUtil.createClusterComposition(ClusterCompositionUtil.EMPTY, ClusterCompositionUtil.EMPTY, readers));
        Assertions.assertArrayEquals((Object[])new BoltServerAddress[]{ClusterCompositionUtil.B, ClusterCompositionUtil.A, ClusterCompositionUtil.F, ClusterCompositionUtil.C, ClusterCompositionUtil.D}, (Object[])routingTable.readers().toArray());
    }

    @Test
    void shouldTreatOneRouterAsValid() {
        ClusterRoutingTable routingTable = this.newRoutingTable();
        List<BoltServerAddress> routers = Collections.singletonList(ClusterCompositionUtil.A);
        List<BoltServerAddress> writers = Arrays.asList(ClusterCompositionUtil.B, ClusterCompositionUtil.C);
        List<BoltServerAddress> readers = Arrays.asList(ClusterCompositionUtil.D, ClusterCompositionUtil.E);
        routingTable.update(ClusterCompositionUtil.createClusterComposition(routers, writers, readers));
        Assertions.assertFalse((boolean)routingTable.isStaleFor(AccessMode.READ));
        Assertions.assertFalse((boolean)routingTable.isStaleFor(AccessMode.WRITE));
    }

    @Test
    void shouldHaveBeStaleForExpiredTime() throws Throwable {
        ClusterRoutingTable routingTable = this.newRoutingTable(Clock.SYSTEM);
        Assertions.assertTrue((boolean)routingTable.hasBeenStaleFor(0L));
    }

    @Test
    void shouldNotHaveBeStaleForUnexpiredTime() throws Throwable {
        ClusterRoutingTable routingTable = this.newRoutingTable(Clock.SYSTEM);
        Assertions.assertFalse((boolean)routingTable.hasBeenStaleFor(Duration.ofSeconds(30L).toMillis()));
    }

    @Test
    void shouldDefaultToPreferInitialRouter() throws Throwable {
        ClusterRoutingTable routingTable = this.newRoutingTable();
        Assertions.assertTrue((boolean)routingTable.preferInitialRouter());
    }

    @Test
    void shouldPreferInitialRouterIfNoWriter() throws Throwable {
        ClusterRoutingTable routingTable = this.newRoutingTable();
        routingTable.update(ClusterCompositionUtil.createClusterComposition(ClusterCompositionUtil.EMPTY, ClusterCompositionUtil.EMPTY, ClusterCompositionUtil.EMPTY));
        Assertions.assertTrue((boolean)routingTable.preferInitialRouter());
        routingTable.update(ClusterCompositionUtil.createClusterComposition(Collections.singletonList(ClusterCompositionUtil.A), ClusterCompositionUtil.EMPTY, Collections.singletonList(ClusterCompositionUtil.A)));
        Assertions.assertTrue((boolean)routingTable.preferInitialRouter());
        routingTable.update(ClusterCompositionUtil.createClusterComposition(Arrays.asList(ClusterCompositionUtil.A, ClusterCompositionUtil.B), ClusterCompositionUtil.EMPTY, Arrays.asList(ClusterCompositionUtil.A, ClusterCompositionUtil.B)));
        Assertions.assertTrue((boolean)routingTable.preferInitialRouter());
        routingTable.update(ClusterCompositionUtil.createClusterComposition(ClusterCompositionUtil.EMPTY, ClusterCompositionUtil.EMPTY, Collections.singletonList(ClusterCompositionUtil.A)));
        Assertions.assertTrue((boolean)routingTable.preferInitialRouter());
        routingTable.update(ClusterCompositionUtil.createClusterComposition(Collections.singletonList(ClusterCompositionUtil.A), ClusterCompositionUtil.EMPTY, ClusterCompositionUtil.EMPTY));
        Assertions.assertTrue((boolean)routingTable.preferInitialRouter());
    }

    @Test
    void shouldNotPreferInitialRouterIfHasWriter() throws Throwable {
        ClusterRoutingTable routingTable = this.newRoutingTable();
        routingTable.update(ClusterCompositionUtil.createClusterComposition(ClusterCompositionUtil.EMPTY, Collections.singletonList(ClusterCompositionUtil.A), ClusterCompositionUtil.EMPTY));
        Assertions.assertFalse((boolean)routingTable.preferInitialRouter());
        routingTable.update(ClusterCompositionUtil.createClusterComposition(Collections.singletonList(ClusterCompositionUtil.A), Collections.singletonList(ClusterCompositionUtil.A), Collections.singletonList(ClusterCompositionUtil.A)));
        Assertions.assertFalse((boolean)routingTable.preferInitialRouter());
        routingTable.update(ClusterCompositionUtil.createClusterComposition(Arrays.asList(ClusterCompositionUtil.A, ClusterCompositionUtil.B), Collections.singletonList(ClusterCompositionUtil.A), Arrays.asList(ClusterCompositionUtil.A, ClusterCompositionUtil.B)));
        Assertions.assertFalse((boolean)routingTable.preferInitialRouter());
        routingTable.update(ClusterCompositionUtil.createClusterComposition(ClusterCompositionUtil.EMPTY, Collections.singletonList(ClusterCompositionUtil.A), Collections.singletonList(ClusterCompositionUtil.A)));
        Assertions.assertFalse((boolean)routingTable.preferInitialRouter());
        routingTable.update(ClusterCompositionUtil.createClusterComposition(Collections.singletonList(ClusterCompositionUtil.A), Collections.singletonList(ClusterCompositionUtil.A), ClusterCompositionUtil.EMPTY));
        Assertions.assertFalse((boolean)routingTable.preferInitialRouter());
    }

    private ClusterRoutingTable newRoutingTable() {
        return new ClusterRoutingTable(DatabaseNameUtil.defaultDatabase(), (Clock)new FakeClock(), new BoltServerAddress[0]);
    }

    private ClusterRoutingTable newRoutingTable(Clock clock) {
        return new ClusterRoutingTable(DatabaseNameUtil.defaultDatabase(), clock, new BoltServerAddress[0]);
    }
}

